/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.provider;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.semantic.provider.Messages;
import org.eclipse.core.internal.resources.semantic.spi.SemanticFileSystemSpiCore;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.DefaultMinimalSemanticResourceRuleFactory;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderFederation;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderREST;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticResourceRuleFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticTreeDeepFirstVisitor;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticTreeWalker;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContentProvider
extends CachingContentProvider
implements ISemanticContentProviderFederation,
ISemanticContentProviderREST {
    private static final String TRUE = "true";
    private static final QualifiedName RESOURCE_NOT_ACCESSIBLE = new QualifiedName("org.eclipse.core.resources.semantic", "ResourceNotAccessible");
    private static final QualifiedName RESOURCE_NOT_ACCESSIBLE_MESSAGE = new QualifiedName("org.eclipse.core.resources.semantic", "ResourceNotAccessibleMessage");

    @Override
    public String getFederatedProviderIDForPath(IPath path) {
        IPath checkPath = path.removeFirstSegments(this.getRootStore().getPath().segmentCount());
        return SemanticFileSystemSpiCore.getInstance().getFolderTemplateMapping(checkPath);
    }

    @Override
    public void revertChanges(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, semanticFileStore.getPath(), Messages.DefaultContentProvider_NotSupported_XMSG);
    }

    @Override
    public void addFileFromRemoteByURI(ISemanticFileStore childStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        childStore.addChildResource(name, false, this.getFederatedProviderIDForPath(childStore.getPath().append(name)), null);
        ISemanticFileStore newChild = (ISemanticFileStore)childStore.getChild(name);
        newChild.setRemoteURIString(uri.toString());
        this.setReadOnly(newChild, true, monitor);
        MultiStatus stat = new MultiStatus("org.eclipse.core.resources.semantic", 0, NLS.bind((String)Messages.DefaultContentProvider_CacheFillError_XMSG, (Object)newChild.getPath().toString()), null);
        this.fillCache(newChild, monitor, stat);
        if (!stat.isOK()) {
            newChild.remove(monitor);
            throw new CoreException((IStatus)stat);
        }
    }

    @Override
    public void addFolderFromRemoteByURI(ISemanticFileStore childStore, String name, URI uri, IProgressMonitor monitor) throws CoreException {
        childStore.addChildResource(name, true, this.getFederatedProviderIDForPath(childStore.getPath().append(name)), null);
        ISemanticFileStore newChild = (ISemanticFileStore)childStore.getChild(name);
        newChild.setRemoteURIString(uri.toString());
        this.setReadOnly(newChild, true, monitor);
    }

    @Override
    public String getURIString(ISemanticFileStore childStore) throws CoreException {
        return childStore.getRemoteURIString();
    }

    @Override
    public void setURIString(ISemanticFileStore semanticFileStore, URI uri, IProgressMonitor monitor) throws CoreException {
        if (semanticFileStore.getType() == 1) {
            semanticFileStore.setRemoteURIString(uri.toString());
            this.setReadOnly(semanticFileStore, true, monitor);
            this.deleteCache(semanticFileStore, monitor);
            MultiStatus status = new MultiStatus("org.eclipse.core.resources.semantic", 0, NLS.bind((String)Messages.DefaultContentProvider_CacheFillError_XMSG, (Object)uri.toString()), null);
            this.fillCache(semanticFileStore, monitor, status);
            if (!status.isOK()) {
                throw new CoreException((IStatus)status);
            }
        } else {
            throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, semanticFileStore.getPath(), Messages.DefaultContentProvider_NotSupported_XMSG);
        }
    }

    @Override
    public ICacheServiceFactory getCacheServiceFactory() throws CoreException {
        return new FileCacheServiceFactory();
    }

    @Override
    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        String remoteURI;
        String uriString = SemanticSpiResourceInfo.isOptionRequested(64, options) ? semanticFileStore.getRemoteURIString() : null;
        boolean readOnly = SemanticSpiResourceInfo.isOptionRequested(16, options) ? this.isReadOnlyInternal(semanticFileStore) : false;
        boolean existsRemotely = false;
        if (SemanticSpiResourceInfo.isOptionRequested(32, options) && (remoteURI = this.getURIString(semanticFileStore)) != null) {
            URI uri = URI.create(remoteURI);
            try {
                URL url = uri.toURL();
                InputStream is = null;
                try {
                    is = url.openConnection().getInputStream();
                    existsRemotely = is != null;
                }
                finally {
                    Util.safeClose(is);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return new SemanticSpiResourceInfo(options, false, false, readOnly, existsRemotely, uriString, null);
    }

    @Override
    public InputStream openInputStreamInternal(ISemanticFileStore childStore, IProgressMonitor monitor, CachingContentProvider.ICacheTimestampSetter setter) throws CoreException {
        String remoteURI = this.getURIString(childStore);
        if (childStore.getPersistentProperty(RESOURCE_NOT_ACCESSIBLE) != null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, childStore.getPath(), childStore.getPersistentProperty(RESOURCE_NOT_ACCESSIBLE_MESSAGE));
        }
        if (remoteURI == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_URI_NOT_FOUND, childStore.getPath(), NLS.bind((String)Messages.DefaultContentProvider_RemotURINotSet_XMSG, (Object)childStore.getPath().toString()));
        }
        try {
            URI uri = new URI(remoteURI);
            URL url = uri.toURL();
            URLConnection conn = url.openConnection();
            if (conn.getLastModified() != 0L) {
                setter.setTimestamp(conn.getLastModified());
            } else {
                setter.setTimestamp(conn.getDate());
            }
            InputStream is = conn.getInputStream();
            this.clearStateResourceNotAccessible(childStore);
            return is;
        }
        catch (UnknownHostException e) {
            this.setStateResourceNotAccessible(childStore, e);
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, childStore.getPath(), NLS.bind((String)Messages.DefaultContentProvider_UnknownHostError_XMSG, (Object)e.getMessage()), e);
        }
        catch (IOException e) {
            this.setStateResourceNotAccessible(childStore, e);
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, childStore.getPath(), e.getMessage(), e);
        }
        catch (URISyntaxException e) {
            this.setStateResourceNotAccessible(childStore, e);
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_CONNECT_EXCEPTION, childStore.getPath(), e.getMessage(), e);
        }
    }

    @Override
    public void setReadOnly(ISemanticFileStore childStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        this.setReadOnlyInternal(childStore, readonly);
    }

    @Override
    public void removeResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        ISemanticTreeDeepFirstVisitor visitor = new ISemanticTreeDeepFirstVisitor(){

            public void visit(ISemanticFileStore store, IProgressMonitor actMonitor) throws CoreException {
                if (store.getContentProviderID() == null || store.getPath().equals((Object)DefaultContentProvider.this.getRootStore().getPath())) {
                    if (store.getType() == 1) {
                        try {
                            DefaultContentProvider.this.getCacheService().removeContent(store.getPath(), actMonitor);
                        }
                        catch (CoreException coreException) {}
                    }
                    store.remove(actMonitor);
                } else {
                    store.getEffectiveContentProvider().removeResource(store, actMonitor);
                }
            }

            public boolean shouldVisitChildren(ISemanticFileStore store, IProgressMonitor actMonitor) throws CoreException {
                return store.getContentProviderID() == null;
            }
        };
        SemanticTreeWalker.accept(childStore, visitor, monitor);
    }

    @Override
    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        if (semanticFileStore.getType() == 1) {
            if (semanticFileStore.isLocalOnly()) {
                return;
            }
            try {
                if (!this.isReadOnlyInternal(semanticFileStore)) {
                    return;
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            if (direction == SyncDirection.INCOMING || direction == SyncDirection.BOTH) {
                this.dropCache(semanticFileStore, monitor, this.deleteAllVisitor, status);
                try {
                    this.clearStateResourceNotAccessible(semanticFileStore);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                    return;
                }
                this.fillCache(semanticFileStore, monitor, status);
            }
        } else {
            IFileStore[] childStores;
            try {
                childStores = semanticFileStore.childStores(0, monitor);
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            IFileStore[] iFileStoreArray = childStores;
            int n = childStores.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore store = iFileStoreArray[n2];
                if (store instanceof ISemanticFileStore) {
                    ISemanticFileStore sfs = (ISemanticFileStore)store;
                    String providerId = sfs.getContentProviderID();
                    if (providerId == null) {
                        this.synchronizeContentWithRemote(sfs, direction, monitor, status);
                    } else {
                        try {
                            sfs.getEffectiveContentProvider().synchronizeContentWithRemote(sfs, direction, monitor, status);
                        }
                        catch (CoreException e) {
                            status.add(e.getStatus());
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        MultiStatus status = new MultiStatus("org.eclipse.core.resources.semantic", 0, Messages.DefaultContentProvider_ValidateEditResult_XGRP, null);
        ISemanticFileStore[] iSemanticFileStoreArray = stores;
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticFileStore store = iSemanticFileStoreArray[n2];
            if (!store.isLocalOnly()) {
                return new Status(8, "org.eclipse.core.resources.semantic", Messages.DefaultContentProvider_NoRemoteEdit_XMSG);
            }
            try {
                this.setReadOnly(store, false, null);
            }
            catch (CoreException e) {
                status.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic", e.getMessage(), (Throwable)e));
            }
            ++n2;
        }
        return status;
    }

    @Override
    public IStatus validateSave(ISemanticFileStore childStore) {
        return this.validateEdit(new ISemanticFileStore[]{childStore}, null);
    }

    @Override
    public ISemanticResourceRuleFactory getRuleFactory() {
        return new DefaultMinimalSemanticResourceRuleFactory(this.getRootStore());
    }

    @Override
    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        throw new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, parentStore.getPath(), Messages.DefaultContentProvider_NotSupported_XMSG);
    }

    @Override
    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, String contentProviderID, Map<QualifiedName, String> properties) throws CoreException {
        switch (resourceType) {
            case FILE_TYPE: {
                parentStore.addChildResource(name, false, contentProviderID, properties);
                if (contentProviderID != null) break;
                ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
                this.setReadOnly(newChild, true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case FOLDER_TYPE: {
                parentStore.addChildResource(name, true, contentProviderID, properties);
                break;
            }
        }
    }

    private void setStateResourceNotAccessible(ISemanticFileStore childStore, Exception e) throws CoreException {
        childStore.setPersistentProperty(RESOURCE_NOT_ACCESSIBLE, TRUE);
        if (e instanceof UnknownHostException) {
            childStore.setPersistentProperty(RESOURCE_NOT_ACCESSIBLE_MESSAGE, NLS.bind((String)Messages.DefaultContentProvider_UnknownHostError_XMSG, (Object)e.getMessage()));
        } else {
            childStore.setPersistentProperty(RESOURCE_NOT_ACCESSIBLE_MESSAGE, e.getMessage());
        }
    }

    private void clearStateResourceNotAccessible(ISemanticFileStore semanticFileStore) throws CoreException {
        semanticFileStore.setPersistentProperty(RESOURCE_NOT_ACCESSIBLE, null);
        semanticFileStore.setPersistentProperty(RESOURCE_NOT_ACCESSIBLE_MESSAGE, null);
    }
}

