/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.test.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStoreTransient;
import org.eclipse.core.resources.semantic.spi.ContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderLocking;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderRemote;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;

public class PlainTestContentProvider
extends ContentProvider
implements ISemanticContentProviderRemote,
ISemanticContentProviderLocking {
    private static final QualifiedName LOCKHANDLE = new QualifiedName("org.eclipse.core.resources.semantic.test", "LockHandle");
    private static final QualifiedName READONLY = new QualifiedName("org.eclipse.core.resources.semantic.test", "ReadOnly");
    private static final QualifiedName TIMESTAMP = new QualifiedName("org.eclipse.core.resources.semantic.test", "Timestamp");

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        RemoteItem parentItem = this.getStore().getItemByPath(parentStore.getPath().removeFirstSegments(2));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        RemoteItem item = ((RemoteFolder)parentItem).getChild(name);
        if (item == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, parentStore.getPath(), "No such resource");
        }
        switch (resourceType) {
            case UNKNOWN_TYPE: {
                if (item.getType() == RemoteItem.Type.FILE) {
                    parentStore.addChildFile(name);
                    ISemanticFileStore newStore = (ISemanticFileStore)parentStore.getChild(name);
                    this.setReadOnly(newStore, true, monitor);
                    newStore.setPersistentProperty(TIMESTAMP, Long.toString(((RemoteFile)item).getTimestamp()));
                    break;
                }
                if (item.getType() == RemoteItem.Type.FOLDER) {
                    parentStore.addChildFolder(name);
                    break;
                }
                Status result = new Status(4, "org.eclipse.core.resources.semantic.test", "Unknown resource type");
                throw new CoreException((IStatus)result);
            }
            case FILE_TYPE: {
                if (item.getType() != RemoteItem.Type.FILE) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
                }
                parentStore.addChildFile(name);
                ISemanticFileStore newStore = (ISemanticFileStore)parentStore.getChild(name);
                this.setReadOnly(newStore, true, monitor);
                newStore.setPersistentProperty(TIMESTAMP, Long.toString(((RemoteFile)item).getTimestamp()));
                break;
            }
            case FOLDER_TYPE: {
                if (item.getType() != RemoteItem.Type.FOLDER) {
                    throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
                }
                parentStore.addChildFolder(name);
                break;
            }
            case PROJECT_TYPE: {
                throw new SemanticResourceException(SemanticResourceStatusCode.INVALID_RESOURCE_TYPE, item.getPath(), "");
            }
        }
    }

    public void createFileRemotely(ISemanticFileStore childStore, String name, InputStream source, Object context, IProgressMonitor monitor) throws CoreException {
        byte[] buffer;
        if (source != null) {
            try {
                int size = source.available();
                buffer = new byte[size];
                source.read(buffer);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", e.getMessage(), (Throwable)e));
            }
        }
        if (context == null) {
            buffer = new byte[]{};
        } else {
            try {
                buffer = context.toString().getBytes("UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                buffer = new byte[]{};
            }
        }
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        ((RemoteFolder)parentItem).addFile(name, buffer, System.currentTimeMillis());
        childStore.addChildFile(name);
        ISemanticFileStore newStore = (ISemanticFileStore)childStore.getChild(name);
        this.setReadOnly(newStore, false, monitor);
        this.lockResource(newStore, monitor);
    }

    public void createResourceRemotely(ISemanticFileStore childStore, String name, Object context, IProgressMonitor monitor) throws CoreException {
        this.createFileRemotely(childStore, name, null, context, monitor);
    }

    public void deleteRemotely(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        RemoteItem parentItem = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2).removeLastSegments(1));
        if (parentItem.getType() != RemoteItem.Type.FOLDER) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentItem.getPath(), "");
        }
        ((RemoteFolder)parentItem).deleteChild(childStore.getName());
        childStore.remove(monitor);
    }

    public IStatus lockResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        childStore.setSessionProperty(LOCKHANDLE, (Object)"");
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public IStatus unlockResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        childStore.setSessionProperty(LOCKHANDLE, null);
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        return new SemanticSpiResourceInfo(options, semanticFileStore.getSessionProperty(LOCKHANDLE) != null, true, semanticFileStore.getPersistentProperty(READONLY) != null, this.getStore().getItemByPath(semanticFileStore.getPath().removeFirstSegments(2)) != null, null, null);
    }

    public InputStream openInputStream(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        return new ByteArrayInputStream(((RemoteFile)item).getContent());
    }

    public OutputStream openOutputStream(ISemanticFileStore childStore, int options, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        boolean append = (options & 1) > 0;
        return ((RemoteFile)item).getOutputStream(append);
    }

    public void removeResource(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        childStore.remove(monitor);
    }

    public void revertChanges(ISemanticFileStore childStore, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, item.getPath(), "");
        }
        ((RemoteFile)item).getOutputStream(false).reset();
    }

    public void setReadOnly(ISemanticFileStore childStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        if (readonly) {
            childStore.setPersistentProperty(READONLY, "");
        } else {
            childStore.setPersistentProperty(READONLY, null);
        }
    }

    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        MultiStatus multi = new MultiStatus("org.eclipse.core.resources.semantic.test", 0, "Validate Edit Result", null);
        ISemanticFileStore[] iSemanticFileStoreArray = stores;
        int n = stores.length;
        int n2 = 0;
        while (n2 < n) {
            ISemanticFileStore store = iSemanticFileStoreArray[n2];
            RemoteItem item = this.getStore().getItemByPath(store.getPath().removeFirstSegments(2));
            if (item == null) {
                multi.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "Resource not found"));
            } else if (item.getType() != RemoteItem.Type.FILE) {
                multi.add((IStatus)new Status(4, "org.eclipse.core.resources.semantic.test", "Can only edit files"));
            } else {
                try {
                    this.lockResource(store, null);
                    this.setReadOnly(store, false, null);
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
        return multi;
    }

    public IStatus validateRemoteCreate(ISemanticFileStore childStore, String childName, Object shell) {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item != null) {
            return new Status(4, "org.eclipse.core.resources.semantic.test", "Resource already exists");
        }
        return null;
    }

    public IStatus validateRemoteDelete(ISemanticFileStore childStore, Object shell) {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item == null) {
            return new Status(4, "org.eclipse.core.resources.semantic.test", "Resource not found");
        }
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public IStatus validateSave(ISemanticFileStore childStore) {
        RemoteItem item = this.getStore().getItemByPath(childStore.getPath().removeFirstSegments(2));
        if (item == null) {
            return new Status(4, "org.eclipse.core.resources.semantic.test", "Resource not found");
        }
        return new Status(0, "org.eclipse.core.resources.semantic.test", "");
    }

    public long getResourceTimestamp(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        String test = semanticFileStore.getPersistentProperty(TIMESTAMP);
        if (test != null) {
            try {
                return Long.parseLong(test);
            }
            catch (NumberFormatException numberFormatException) {
                return 0L;
            }
        }
        return 0L;
    }

    public void setResourceTimestamp(ISemanticFileStore semanticFileStore, long timestamp, IProgressMonitor monitor) throws CoreException {
        semanticFileStore.setPersistentProperty(TIMESTAMP, Long.toString(timestamp));
    }

    public void synchronizeContentWithRemote(ISemanticFileStore store, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        RemoteItem item = this.getStore().getItemByPath(store.getPath().removeFirstSegments(2));
        try {
            if (item.isLocked()) {
                store.setSessionProperty(LOCKHANDLE, (Object)"");
            } else {
                store.setSessionProperty(LOCKHANDLE, null);
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
        try {
            IFileStore[] children;
            IFileStore[] iFileStoreArray = children = store.childStores(0, monitor);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IFileStore childStore = iFileStoreArray[n2];
                this.synchronizeContentWithRemote((ISemanticFileStore)childStore, direction, monitor, status);
                ++n2;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    protected RemoteStoreTransient getStore() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getRootStore().getPath()).getProject();
        return (RemoteStoreTransient)project.getAdapter(RemoteStoreTransient.class);
    }
}

