/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo;

import edu.umd.cs.piccolo.PRoot;
import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PColorActivity;
import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import edu.umd.cs.piccolo.activities.PTransformActivity;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PLayout;
import edu.umd.cs.piccolo.util.PNodeFilter;
import edu.umd.cs.piccolo.util.PObjectOutputStream;
import edu.umd.cs.piccolo.util.PPaintContext;
import edu.umd.cs.piccolo.util.PPickPath;
import edu.umd.cs.piccolo.util.PUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.swing.event.EventListenerList;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import org.eclipse.e4.tm.graphics.util.Dimension;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Rectangle;
import org.eclipse.e4.tm.graphics.util.Transform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class PNode
implements Cloneable,
Serializable {
    public static final String PROPERTY_CLIENT_PROPERTIES = "clientProperties";
    public static final int PROPERTY_CODE_CLIENT_PROPERTIES = 1;
    public static final String PROPERTY_BOUNDS = "bounds";
    public static final int PROPERTY_CODE_BOUNDS = 2;
    public static final String PROPERTY_FULL_BOUNDS = "fullBounds";
    public static final int PROPERTY_CODE_FULL_BOUNDS = 4;
    public static final String PROPERTY_TRANSFORM = "transform";
    public static final int PROPERTY_CODE_TRANSFORM = 8;
    public static final String PROPERTY_VISIBLE = "visible";
    public static final int PROPERTY_CODE_VISIBLE = 16;
    public static final String PROPERTY_PAINT = "paint";
    public static final int PROPERTY_CODE_PAINT = 32;
    public static final String PROPERTY_TRANSPARENCY = "transparency";
    public static final int PROPERTY_CODE_TRANSPARENCY = 64;
    public static final String PROPERTY_PICKABLE = "pickable";
    public static final int PROPERTY_CODE_PICKABLE = 128;
    public static final String PROPERTY_CHILDREN_PICKABLE = "childrenPickable";
    public static final int PROPERTY_CODE_CHILDREN_PICKABLE = 256;
    public static final String PROPERTY_CHILDREN = "children";
    public static final int PROPERTY_CODE_CHILDREN = 512;
    public static final String PROPERTY_PARENT = "parent";
    public static final int PROPERTY_CODE_PARENT = 1024;
    private static final PBounds TEMP_REPAINT_BOUNDS = new PBounds();
    public static PSceneGraphDelegate SCENE_GRAPH_DELEGATE = null;
    private transient PNode parent;
    private List children;
    private PBounds bounds = new PBounds();
    private PAffineTransform transform;
    private Color paint;
    private float transparency = 1.0f;
    private MutableAttributeSet clientProperties;
    private PBounds fullBoundsCache = new PBounds();
    private int propertyChangeParentMask = 0;
    private transient EventListenerList listenerList;
    private boolean pickable = true;
    private boolean childrenPickable = true;
    private boolean visible = true;
    private boolean childBoundsVolatile;
    private boolean paintInvalid;
    private boolean childPaintInvalid;
    private boolean boundsChanged;
    private boolean fullBoundsInvalid;
    private boolean childBoundsInvalid;
    private boolean occluded;
    private IPropertyChangeListener[] propertyChangeListeners = null;
    private PLayout layout = null;
    private Object layoutData = null;

    public PInterpolatingActivity animateToBounds(double x, double y, double width, double height, long duration) {
        if (duration == 0L) {
            this.setBounds(x, y, width, height);
            return null;
        }
        final PBounds dst = new PBounds(x, y, width, height);
        PInterpolatingActivity ta = new PInterpolatingActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE){
            private PBounds src;

            protected void activityStarted() {
                this.src = PNode.this.getBounds();
                PNode.this.startResizeBounds();
                super.activityStarted();
            }

            public void setRelativeTargetValue(float zeroToOne) {
                PNode.this.setBounds(this.src.x + (double)zeroToOne * (dst.x - this.src.x), this.src.y + (double)zeroToOne * (dst.y - this.src.y), this.src.width + (double)zeroToOne * (dst.width - this.src.width), this.src.height + (double)zeroToOne * (dst.height - this.src.height));
            }

            protected void activityFinished() {
                super.activityFinished();
                PNode.this.endResizeBounds();
            }
        };
        this.addActivity(ta);
        return ta;
    }

    public PTransformActivity animateTransformToBounds(double x, double y, double width, double height, long duration) {
        PAffineTransform t = new PAffineTransform();
        t.setToScale(width / this.getWidth(), height / this.getHeight());
        t.setOffset(x, y);
        return this.animateToTransform(t, duration);
    }

    public PTransformActivity animateToPositionScaleRotation(double x, double y, double scale, double theta, long duration) {
        PAffineTransform t = this.getTransform();
        t.setOffset(x, y);
        t.setScale(scale);
        t.setRotation(theta);
        return this.animateToTransform(t, duration);
    }

    public PTransformActivity animateToTransform(Transform destTransform, long duration) {
        if (duration == 0L) {
            this.setTransform(destTransform);
            return null;
        }
        PTransformActivity.Target t = new PTransformActivity.Target(){

            public void setTransform(Transform aTransform) {
                PNode.this.setTransform(aTransform);
            }

            public void getSourceMatrix(double[] aSource) {
                PNode.this.getTransformReference(true).getMatrix(aSource);
            }
        };
        PTransformActivity ta = new PTransformActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destTransform);
        this.addActivity(ta);
        return ta;
    }

    public PInterpolatingActivity animateToColor(Color destColor, long duration) {
        if (duration == 0L) {
            this.setPaint(destColor);
            return null;
        }
        PColorActivity.Target t = new PColorActivity.Target(){

            public Color getColor() {
                return PNode.this.getPaint();
            }

            public void setColor(Color color) {
                PNode.this.setPaint(color);
            }
        };
        PColorActivity ca = new PColorActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE, t, destColor);
        this.addActivity(ca);
        return ca;
    }

    public PInterpolatingActivity animateToTransparency(float zeroToOne, long duration) {
        if (duration == 0L) {
            this.setTransparency(zeroToOne);
            return null;
        }
        final float dest = zeroToOne;
        PInterpolatingActivity ta = new PInterpolatingActivity(duration, PUtil.DEFAULT_ACTIVITY_STEP_RATE){
            private float source;

            protected void activityStarted() {
                this.source = PNode.this.getTransparency();
                super.activityStarted();
            }

            public void setRelativeTargetValue(float zeroToOne) {
                PNode.this.setTransparency(this.source + zeroToOne * (dest - this.source));
            }
        };
        this.addActivity(ta);
        return ta;
    }

    public boolean addActivity(PActivity activity) {
        PRoot r = this.getRoot();
        if (r != null) {
            return r.addActivity(activity);
        }
        return false;
    }

    public MutableAttributeSet getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new SimpleAttributeSet();
        }
        return this.clientProperties;
    }

    public Object getAttribute(Object key) {
        if (this.clientProperties == null || key == null) {
            return null;
        }
        return this.clientProperties.getAttribute(key);
    }

    public void addAttribute(Object key, Object value) {
        if (value == null && this.clientProperties == null) {
            return;
        }
        Object oldValue = this.getAttribute(key);
        if (value != oldValue) {
            if (this.clientProperties == null) {
                this.clientProperties = new SimpleAttributeSet();
            }
            if (value == null) {
                this.clientProperties.removeAttribute(key);
            } else {
                this.clientProperties.addAttribute(key, value);
            }
            if (this.clientProperties.getAttributeCount() == 0 && this.clientProperties.getResolveParent() == null) {
                this.clientProperties = null;
            }
            this.firePropertyChange(1, PROPERTY_CLIENT_PROPERTIES, null, this.clientProperties);
            this.firePropertyChange(1, key.toString(), oldValue, value);
        }
    }

    public Enumeration getClientPropertyKeysEnumeration() {
        if (this.clientProperties == null) {
            return PUtil.NULL_ENUMERATION;
        }
        return this.clientProperties.getAttributeNames();
    }

    public Object getAttribute(Object key, Object def) {
        Object o = this.getAttribute(key);
        return o == null ? def : o;
    }

    public boolean getBooleanAttribute(Object key, boolean def) {
        Boolean b = (Boolean)this.getAttribute(key);
        return b == null ? def : b;
    }

    public int getIntegerAttribute(Object key, int def) {
        Number n = (Number)this.getAttribute(key);
        return n == null ? def : n.intValue();
    }

    public double getDoubleAttribute(Object key, double def) {
        Number n = (Number)this.getAttribute(key);
        return n == null ? def : n.doubleValue();
    }

    public Object getClientProperty(Object key) {
        return this.getAttribute(key);
    }

    public void addClientProperty(Object key, Object value) {
        this.addAttribute(key, value);
    }

    public Iterator getClientPropertyKeysIterator() {
        final Enumeration enumeration = this.getClientPropertyKeysEnumeration();
        return new Iterator(){

            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            public Object next() {
                return enumeration.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object clone() {
        try {
            byte[] ser = PObjectOutputStream.toByteArray(this);
            return (PNode)new ObjectInputStream(new ByteArrayInputStream(ser)).readObject();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Point localToParent(Point localPoint) {
        if (this.transform == null) {
            return localPoint;
        }
        return this.transform.transform(localPoint, localPoint);
    }

    public Dimension localToParent(Dimension localDimension) {
        if (this.transform == null) {
            return localDimension;
        }
        return this.transform.transform(localDimension, localDimension);
    }

    public Rectangle localToParent(Rectangle localRectangle) {
        if (this.transform == null) {
            return localRectangle;
        }
        return this.transform.transform(localRectangle, localRectangle);
    }

    public Point parentToLocal(Point parentPoint) {
        if (this.transform == null) {
            return parentPoint;
        }
        try {
            return this.transform.inverseTransform(parentPoint, parentPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Dimension parentToLocal(Dimension parentDimension) {
        if (this.transform == null) {
            return parentDimension;
        }
        return this.transform.inverseTransform(parentDimension, parentDimension);
    }

    public Rectangle parentToLocal(Rectangle parentRectangle) {
        if (this.transform == null) {
            return parentRectangle;
        }
        return this.transform.inverseTransform(parentRectangle, parentRectangle);
    }

    public Point localToGlobal(Point localPoint) {
        PNode n = this;
        while (n != null) {
            localPoint = n.localToParent(localPoint);
            n = n.parent;
        }
        return localPoint;
    }

    public Dimension localToGlobal(Dimension localDimension) {
        PNode n = this;
        while (n != null) {
            localDimension = n.localToParent(localDimension);
            n = n.parent;
        }
        return localDimension;
    }

    public Rectangle localToGlobal(Rectangle localRectangle) {
        PNode n = this;
        while (n != null) {
            localRectangle = n.localToParent(localRectangle);
            n = n.parent;
        }
        return localRectangle;
    }

    public Point globalToLocal(Point globalPoint) {
        if (this.parent != null) {
            globalPoint = this.parent.globalToLocal(globalPoint);
        }
        return this.parentToLocal(globalPoint);
    }

    public Dimension globalToLocal(Dimension globalDimension) {
        if (this.parent != null) {
            globalDimension = this.parent.globalToLocal(globalDimension);
        }
        return this.parentToLocal(globalDimension);
    }

    public Rectangle globalToLocal(Rectangle globalRectangle) {
        if (this.parent != null) {
            globalRectangle = this.parent.globalToLocal(globalRectangle);
        }
        return this.parentToLocal(globalRectangle);
    }

    public PAffineTransform getLocalToGlobalTransform(PAffineTransform dest) {
        if (this.parent != null) {
            dest = this.parent.getLocalToGlobalTransform(dest);
            if (this.transform != null) {
                dest.concatenate(this.transform);
            }
        } else if (dest == null) {
            dest = this.getTransform();
        } else if (this.transform != null) {
            dest.setTransform(this.transform);
        } else {
            dest.setToIdentity();
        }
        return dest;
    }

    public PAffineTransform getGlobalToLocalTransform(PAffineTransform dest) {
        try {
            dest = this.getLocalToGlobalTransform(dest);
            dest.setTransform(dest.createInverse());
            return dest;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public EventListenerList getListenerList() {
        return this.listenerList;
    }

    public void addInputEventListener(PInputEventListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.getListenerList().add(PInputEventListener.class, listener);
    }

    public void removeInputEventListener(PInputEventListener listener) {
        if (this.listenerList == null) {
            return;
        }
        this.getListenerList().remove(PInputEventListener.class, listener);
        if (this.listenerList.getListenerCount() == 0) {
            this.listenerList = null;
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.propertyChangeListeners == null) {
            this.propertyChangeListeners = new IPropertyChangeListener[4];
        }
        int pos = 0;
        while (pos < this.propertyChangeListeners.length) {
            if (this.propertyChangeListeners[pos] == null) break;
        }
        if (pos == this.propertyChangeListeners.length) {
            IPropertyChangeListener[] newArray = new IPropertyChangeListener[this.propertyChangeListeners.length + 4];
            System.arraycopy(this.propertyChangeListeners, 0, newArray, 0, this.propertyChangeListeners.length);
            this.propertyChangeListeners = newArray;
        }
        this.propertyChangeListeners[pos] = listener;
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.propertyChangeListeners != null) {
            int nullCount = 0;
            int i = 0;
            while (i < this.propertyChangeListeners.length) {
                if (this.propertyChangeListeners[i] == listener) {
                    this.propertyChangeListeners[i] = null;
                }
                if (this.propertyChangeListeners[i] == null) {
                    ++nullCount;
                }
                ++i;
            }
            if (nullCount == this.propertyChangeListeners.length) {
                this.propertyChangeListeners = null;
            }
        }
    }

    public int getPropertyChangeParentMask() {
        return this.propertyChangeParentMask;
    }

    public void setPropertyChangeParentMask(int propertyChangeParentMask) {
        this.propertyChangeParentMask = propertyChangeParentMask;
    }

    private PropertyChangeEvent firePropertyChange(int propertyCode, String propertyName, Object oldValue, Object newValue, PropertyChangeEvent event) {
        if (this.propertyChangeListeners != null) {
            if (event == null) {
                event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
            }
            int i = 0;
            while (i < this.propertyChangeListeners.length) {
                if (this.propertyChangeListeners[i] != null) {
                    this.propertyChangeListeners[i].propertyChange(event);
                }
                ++i;
            }
        }
        return event;
    }

    protected void firePropertyChange(int propertyCode, String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent event = this.firePropertyChange(propertyCode, propertyName, oldValue, newValue, null);
        if (this.parent != null && (propertyCode & this.propertyChangeParentMask) != 0) {
            if (event == null) {
                event = new PropertyChangeEvent((Object)this, propertyName, oldValue, newValue);
            }
            this.parent.fireChildPropertyChange(event, propertyCode);
        }
    }

    protected void fireChildPropertyChange(PropertyChangeEvent event, int propertyCode) {
        this.firePropertyChange(0, null, null, null, event);
        if (this.parent != null && (propertyCode & this.propertyChangeParentMask) != 0) {
            this.parent.fireChildPropertyChange(event, propertyCode);
        }
    }

    public PBounds getBounds() {
        return (PBounds)this.getBoundsReference().clone();
    }

    public PBounds getBoundsReference() {
        return this.bounds;
    }

    public void startResizeBounds() {
    }

    public void endResizeBounds() {
    }

    public boolean setX(double x) {
        return this.setBounds(x, this.getY(), this.getWidth(), this.getHeight());
    }

    public boolean setY(double y) {
        return this.setBounds(this.getX(), y, this.getWidth(), this.getHeight());
    }

    public boolean setWidth(double width) {
        return this.setBounds(this.getX(), this.getY(), width, this.getHeight());
    }

    public boolean setHeight(double height) {
        return this.setBounds(this.getX(), this.getY(), this.getWidth(), height);
    }

    public boolean setBounds(Rectangle newBounds) {
        return this.setBounds(newBounds.x, newBounds.y, newBounds.width, newBounds.height);
    }

    public boolean setBounds(double x, double y, double width, double height) {
        if (this.bounds.x != x || this.bounds.y != y || this.bounds.width != width || this.bounds.height != height) {
            this.bounds.setRect(x, y, width, height);
            if (width <= 0.0 || height <= 0.0) {
                this.bounds.reset();
            }
            this.internalUpdateBounds(x, y, width, height);
            this.invalidatePaint();
            this.signalBoundsChanged();
            return true;
        }
        return false;
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
    }

    public void resetBounds() {
        this.setBounds(0.0, 0.0, 0.0, 0.0);
    }

    public double getX() {
        return this.getBoundsReference().getX();
    }

    public double getY() {
        return this.getBoundsReference().getY();
    }

    public double getWidth() {
        return this.getBoundsReference().getWidth();
    }

    public double getHeight() {
        return this.getBoundsReference().getHeight();
    }

    public PBounds getGlobalBounds() {
        return (PBounds)this.localToGlobal(this.getBounds());
    }

    public boolean centerBoundsOnPoint(double localX, double localY) {
        double dx = localX - this.bounds.getCenterX();
        double dy = localY - this.bounds.getCenterY();
        return this.setBounds(this.bounds.x + dx, this.bounds.y + dy, this.bounds.width, this.bounds.height);
    }

    public void centerFullBoundsOnPoint(double parentX, double parentY) {
        double dx = parentX - this.getFullBoundsReference().getCenterX();
        double dy = parentY - this.getFullBoundsReference().getCenterY();
        this.offset(dx, dy);
    }

    public boolean intersects(Rectangle localBounds) {
        if (localBounds == null) {
            return true;
        }
        return this.getBoundsReference().intersects(localBounds);
    }

    public PBounds getFullBounds() {
        return (PBounds)this.getFullBoundsReference().clone();
    }

    public PBounds getFullBoundsReference() {
        this.validateFullBounds();
        return this.fullBoundsCache;
    }

    public PBounds computeFullBounds(PBounds dstBounds) {
        PBounds result = this.getUnionOfChildrenBounds(dstBounds);
        result.add(this.getBoundsReference());
        this.localToParent(result);
        return result;
    }

    public PBounds getUnionOfChildrenBounds(PBounds dstBounds) {
        if (dstBounds == null) {
            dstBounds = new PBounds();
        } else {
            dstBounds.resetToZero();
        }
        int count = this.getChildrenCount();
        int i = 0;
        while (i < count) {
            PNode each = (PNode)this.children.get(i);
            dstBounds.add(each.getFullBoundsReference());
            ++i;
        }
        return dstBounds;
    }

    public PBounds getGlobalFullBounds() {
        PBounds b = this.getFullBounds();
        if (this.parent != null) {
            this.parent.localToGlobal(b);
        }
        return b;
    }

    public boolean fullIntersects(Rectangle parentBounds) {
        if (parentBounds == null) {
            return true;
        }
        return this.getFullBoundsReference().intersects(parentBounds);
    }

    protected boolean getBoundsVolatile() {
        return false;
    }

    protected boolean getChildBoundsVolatile() {
        return this.childBoundsVolatile;
    }

    protected void setChildBoundsVolatile(boolean childBoundsVolatile) {
        this.childBoundsVolatile = childBoundsVolatile;
    }

    protected boolean getBoundsChanged() {
        return this.boundsChanged;
    }

    protected void setBoundsChanged(boolean boundsChanged) {
        this.boundsChanged = boundsChanged;
    }

    protected boolean getFullBoundsInvalid() {
        return this.fullBoundsInvalid;
    }

    protected void setFullBoundsInvalid(boolean fullBoundsInvalid) {
        this.fullBoundsInvalid = fullBoundsInvalid;
    }

    protected boolean getChildBoundsInvalid() {
        return this.childBoundsInvalid;
    }

    protected void setChildBoundsInvalid(boolean childBoundsInvalid) {
        this.childBoundsInvalid = childBoundsInvalid;
    }

    public void signalBoundsChanged() {
        this.invalidateFullBounds();
        this.setBoundsChanged(true);
        this.firePropertyChange(2, PROPERTY_BOUNDS, null, this.bounds);
        int count = this.getChildrenCount();
        int i = 0;
        while (i < count) {
            PNode each = (PNode)this.children.get(i);
            each.parentBoundsChanged();
            ++i;
        }
    }

    public void invalidateLayout() {
        this.invalidateFullBounds();
    }

    protected void parentBoundsChanged() {
    }

    public void invalidateFullBounds() {
        this.setFullBoundsInvalid(true);
        PNode n = this.parent;
        while (n != null && !n.getChildBoundsInvalid()) {
            n.setChildBoundsInvalid(true);
            n = n.parent;
        }
        if (SCENE_GRAPH_DELEGATE != null) {
            SCENE_GRAPH_DELEGATE.nodeFullBoundsInvalidated(this);
        }
    }

    protected boolean validateFullBounds() {
        boolean boundsVolatile = this.getBoundsVolatile();
        if (this.fullBoundsInvalid || this.childBoundsInvalid || boundsVolatile || this.childBoundsVolatile) {
            if (boundsVolatile && !this.boundsChanged) {
                this.signalBoundsChanged();
            }
            if (this.childBoundsInvalid || this.childBoundsVolatile) {
                this.childBoundsVolatile = false;
                int count = this.getChildrenCount();
                int i = 0;
                while (i < count) {
                    PNode each = (PNode)this.children.get(i);
                    this.childBoundsVolatile |= each.validateFullBounds();
                    ++i;
                }
            }
            this.layoutChildren();
            if (this.fullBoundsInvalid) {
                boolean fullBoundsChanged;
                double oldX = this.fullBoundsCache.x;
                double oldY = this.fullBoundsCache.y;
                double oldWidth = this.fullBoundsCache.width;
                double oldHeight = this.fullBoundsCache.height;
                boolean oldEmpty = this.fullBoundsCache.isEmpty();
                this.fullBoundsCache = this.computeFullBounds(this.fullBoundsCache);
                boolean bl = fullBoundsChanged = this.fullBoundsCache.x != oldX || this.fullBoundsCache.y != oldY || this.fullBoundsCache.width != oldWidth || this.fullBoundsCache.height != oldHeight || this.fullBoundsCache.isEmpty() != oldEmpty;
                if (fullBoundsChanged) {
                    if (this.parent != null) {
                        this.parent.invalidateFullBounds();
                    }
                    this.firePropertyChange(4, PROPERTY_FULL_BOUNDS, null, this.fullBoundsCache);
                    if (this.paintInvalid && !oldEmpty) {
                        TEMP_REPAINT_BOUNDS.setRect(oldX, oldY, oldWidth, oldHeight);
                        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
                    }
                }
            }
            this.boundsChanged = false;
            this.fullBoundsInvalid = false;
            this.childBoundsInvalid = false;
        }
        return boundsVolatile || this.childBoundsVolatile;
    }

    public PLayout getLayout() {
        return this.layout;
    }

    public void setLayout(PLayout layout) {
        this.layout = layout;
        if (this.layout != null) {
            this.invalidateLayout();
        }
    }

    public Object getLayoutData() {
        return this.layoutData;
    }

    public void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
    }

    protected void layoutChildren() {
        if (this.layout != null) {
            this.layout.layoutChildren(this);
        }
    }

    public double getRotation() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getRotation();
    }

    public void setRotation(double theta) {
        this.rotate(theta - this.getRotation());
    }

    public void rotate(double theta) {
        this.rotateAboutPoint(theta, 0.0, 0.0);
    }

    public void rotateInPlace(double theta) {
        PBounds b = this.getFullBoundsReference();
        double px = b.x;
        double py = b.y;
        this.rotateAboutPoint(theta, 0.0, 0.0);
        b = this.getFullBoundsReference();
        this.offset(px - b.x, py - b.y);
    }

    public void rotateAboutPoint(double theta, Point point) {
        this.rotateAboutPoint(theta, point.getX(), point.getY());
    }

    public void rotateAboutPoint(double theta, double x, double y) {
        this.getTransformReference(true).rotate(theta, x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public double getGlobalRotation() {
        return this.getLocalToGlobalTransform(null).getRotation();
    }

    public void setGlobalRotation(double theta) {
        if (this.parent != null) {
            this.setRotation(theta - this.parent.getGlobalRotation());
        } else {
            this.setRotation(theta);
        }
    }

    public double getScale() {
        if (this.transform == null) {
            return 1.0;
        }
        return this.transform.getScale();
    }

    public void setScale(double scale) {
        if (scale == 0.0) {
            throw new RuntimeException("Can't set scale to 0");
        }
        this.scale(scale / this.getScale());
    }

    public void scale(double scale) {
        this.scaleAboutPoint(scale, 0.0, 0.0);
    }

    public void scaleAboutPoint(double scale, Point point) {
        this.scaleAboutPoint(scale, point.getX(), point.getY());
    }

    public void scaleAboutPoint(double scale, double x, double y) {
        this.getTransformReference(true).scaleAboutPoint(scale, x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public double getGlobalScale() {
        return this.getLocalToGlobalTransform(null).getScale();
    }

    public void setGlobalScale(double scale) {
        if (this.parent != null) {
            this.setScale(scale / this.parent.getGlobalScale());
        } else {
            this.setScale(scale);
        }
    }

    public double getXOffset() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getTranslateX();
    }

    public double getYOffset() {
        if (this.transform == null) {
            return 0.0;
        }
        return this.transform.getTranslateY();
    }

    public Point getOffset() {
        if (this.transform == null) {
            return new Point();
        }
        return new Point(this.transform.getTranslateX(), this.transform.getTranslateY());
    }

    public void setOffset(Point point) {
        this.setOffset(point.getX(), point.getY());
    }

    public void setOffset(double x, double y) {
        this.getTransformReference(true).setOffset(x, y);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public void offset(double dx, double dy) {
        this.getTransformReference(true);
        this.setOffset(this.transform.getTranslateX() + dx, this.transform.getTranslateY() + dy);
    }

    public void translate(double dx, double dy) {
        this.getTransformReference(true).translate(dx, dy);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public Point getGlobalTranslation() {
        Point p = this.getOffset();
        if (this.parent != null) {
            this.parent.localToGlobal(p);
        }
        return p;
    }

    public void setGlobalTranslation(Point globalPoint) {
        if (this.parent != null) {
            this.parent.getGlobalToLocalTransform(null).transform(globalPoint, globalPoint);
        }
        this.setOffset(globalPoint);
    }

    public void transformBy(Transform aTransform) {
        this.getTransformReference(true).concatenate(aTransform);
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public static double lerp(double t, double a, double b) {
        return a + t * (b - a);
    }

    public void position(Point srcPt, Point destPt, Rectangle destBounds, int millis) {
        if (this.parent != null) {
            PBounds srcBounds = this.getGlobalFullBounds();
            double srcx = PNode.lerp(srcPt.getX(), srcBounds.getX(), srcBounds.getX() + srcBounds.getWidth());
            double srcy = PNode.lerp(srcPt.getY(), srcBounds.getY(), srcBounds.getY() + srcBounds.getHeight());
            double destx = PNode.lerp(destPt.getX(), destBounds.getX(), destBounds.getX() + destBounds.getWidth());
            double desty = PNode.lerp(destPt.getY(), destBounds.getY(), destBounds.getY() + destBounds.getHeight());
            Point pt1 = new Point(srcx, srcy);
            this.globalToLocal(pt1);
            Point pt2 = new Point(destx, desty);
            this.globalToLocal(pt2);
            double dx = pt2.getX() - pt1.getX();
            double dy = pt2.getY() - pt1.getY();
            PAffineTransform at = new PAffineTransform(this.getTransformReference(true));
            at.translate(dx, dy);
            this.animateToTransform(at, millis);
        }
    }

    public PAffineTransform getTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        return (PAffineTransform)this.transform.clone();
    }

    public PAffineTransform getTransformReference(boolean createNewTransformIfNull) {
        if (this.transform == null && createNewTransformIfNull) {
            this.transform = new PAffineTransform();
        }
        return this.transform;
    }

    public PAffineTransform getInverseTransform() {
        if (this.transform == null) {
            return new PAffineTransform();
        }
        try {
            return new PAffineTransform(this.transform.createInverse());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setTransform(Transform newTransform) {
        if (newTransform == null) {
            this.transform = null;
        } else {
            this.getTransformReference(true).setTransform(newTransform);
        }
        this.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(8, PROPERTY_TRANSFORM, null, this.transform);
    }

    public boolean getPaintInvalid() {
        return this.paintInvalid;
    }

    public void setPaintInvalid(boolean paintInvalid) {
        this.paintInvalid = paintInvalid;
    }

    public boolean getChildPaintInvalid() {
        return this.childPaintInvalid;
    }

    public void setChildPaintInvalid(boolean childPaintInvalid) {
        this.childPaintInvalid = childPaintInvalid;
    }

    public void invalidatePaint() {
        this.setPaintInvalid(true);
        PNode n = this.parent;
        while (n != null && !n.getChildPaintInvalid()) {
            n.setChildPaintInvalid(true);
            n = n.parent;
        }
        if (SCENE_GRAPH_DELEGATE != null) {
            SCENE_GRAPH_DELEGATE.nodePaintInvalidated(this);
        }
    }

    public void validateFullPaint() {
        if (this.getPaintInvalid()) {
            this.repaint();
            this.setPaintInvalid(false);
        }
        if (this.getChildPaintInvalid()) {
            int count = this.getChildrenCount();
            int i = 0;
            while (i < count) {
                PNode each = (PNode)this.children.get(i);
                each.validateFullPaint();
                ++i;
            }
            this.setChildPaintInvalid(false);
        }
    }

    public void repaint() {
        TEMP_REPAINT_BOUNDS.setRect(this.getFullBoundsReference());
        this.repaintFrom(TEMP_REPAINT_BOUNDS, this);
    }

    public void repaintFrom(PBounds localBounds, PNode childOrThis) {
        if (this.parent != null) {
            if (childOrThis != this) {
                this.localToParent(localBounds);
            } else if (!this.getVisible()) {
                return;
            }
            this.parent.repaintFrom(localBounds, this);
        }
    }

    public boolean isOpaque(Rectangle boundary) {
        return false;
    }

    public boolean getOccluded() {
        return this.occluded;
    }

    public void setOccluded(boolean isOccluded) {
        this.occluded = isOccluded;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setVisible(boolean isVisible) {
        if (this.getVisible() != isVisible) {
            if (!isVisible) {
                this.repaint();
            }
            this.visible = isVisible;
            this.firePropertyChange(16, PROPERTY_VISIBLE, null, null);
            this.invalidatePaint();
        }
    }

    public Color getPaint() {
        return this.paint;
    }

    public void setPaint(Color newPaint) {
        if (this.paint == newPaint) {
            return;
        }
        Color old = this.paint;
        this.paint = newPaint;
        this.invalidatePaint();
        this.firePropertyChange(32, PROPERTY_PAINT, old, this.paint);
    }

    public float getTransparency() {
        return this.transparency;
    }

    public void setTransparency(float zeroToOne) {
        if (this.transparency == zeroToOne) {
            return;
        }
        this.transparency = zeroToOne;
        this.invalidatePaint();
        this.firePropertyChange(64, PROPERTY_TRANSPARENCY, null, null);
    }

    protected void paint(PPaintContext paintContext) {
        if (this.paint != null) {
            GC g2 = paintContext.getGraphics();
            g2.setBackground(this.paint);
            PBounds rect = this.getBoundsReference();
            g2.fillRectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
        }
    }

    public void fullPaint(PPaintContext paintContext) {
        if (this.getVisible() && this.fullIntersects(paintContext.getLocalClip())) {
            paintContext.pushTransform(this.transform);
            paintContext.pushTransparency(this.transparency);
            if (!this.getOccluded()) {
                this.paint(paintContext);
            }
            int count = this.getChildrenCount();
            int i = 0;
            while (i < count) {
                PNode each = (PNode)this.children.get(i);
                each.fullPaint(paintContext);
                ++i;
            }
            this.paintAfterChildren(paintContext);
            paintContext.popTransparency(this.transparency);
            paintContext.popTransform(this.transform);
        }
    }

    protected void paintAfterChildren(PPaintContext paintContext) {
    }

    public void print() {
    }

    public boolean getPickable() {
        return this.pickable;
    }

    public void setPickable(boolean isPickable) {
        if (this.getPickable() != isPickable) {
            this.pickable = isPickable;
            this.firePropertyChange(128, PROPERTY_PICKABLE, null, null);
        }
    }

    public boolean getChildrenPickable() {
        return this.childrenPickable;
    }

    public void setChildrenPickable(boolean areChildrenPickable) {
        if (this.getChildrenPickable() != areChildrenPickable) {
            this.childrenPickable = areChildrenPickable;
            this.firePropertyChange(256, PROPERTY_CHILDREN_PICKABLE, null, null);
        }
    }

    protected boolean pick(PPickPath pickPath) {
        return false;
    }

    public boolean fullPick(PPickPath pickPath) {
        if ((this.getPickable() || this.getChildrenPickable()) && this.fullIntersects(pickPath.getPickBounds())) {
            boolean thisPickable;
            pickPath.pushNode(this);
            pickPath.pushTransform(this.transform);
            boolean bl = thisPickable = this.getPickable() && pickPath.acceptsNode(this);
            if (thisPickable && this.pick(pickPath)) {
                return true;
            }
            if (this.getChildrenPickable()) {
                int count = this.getChildrenCount();
                int i = count - 1;
                while (i >= 0) {
                    PNode each = (PNode)this.children.get(i);
                    if (each.fullPick(pickPath)) {
                        return true;
                    }
                    --i;
                }
            }
            if (thisPickable && this.pickAfterChildren(pickPath)) {
                return true;
            }
            pickPath.popTransform(this.transform);
            pickPath.popNode(this);
        }
        return false;
    }

    public void findIntersectingNodes(Rectangle fullBounds, ArrayList results) {
        if (this.fullIntersects(fullBounds)) {
            Rectangle localBounds = this.parentToLocal((Rectangle)fullBounds.clone());
            if (this.intersects(localBounds)) {
                results.add(this);
            }
            int count = this.getChildrenCount();
            int i = count - 1;
            while (i >= 0) {
                PNode each = (PNode)this.children.get(i);
                each.findIntersectingNodes(localBounds, results);
                --i;
            }
        }
    }

    protected boolean pickAfterChildren(PPickPath pickPath) {
        return this.intersects(pickPath.getPickBounds());
    }

    public void addChild(PNode child) {
        int insertIndex = this.getChildrenCount();
        if (child.parent == this) {
            --insertIndex;
        }
        this.addChild(insertIndex, child);
    }

    public void addChild(int index, PNode child) {
        PNode oldParent = child.getParent();
        if (oldParent != null) {
            oldParent.removeChild(child);
        }
        child.setParent(this);
        this.getChildrenReference().add(index, child);
        child.invalidatePaint();
        this.invalidateFullBounds();
        this.firePropertyChange(512, PROPERTY_CHILDREN, null, this.children);
    }

    public void addChildren(Collection nodes) {
        for (PNode each : nodes) {
            this.addChild(each);
        }
    }

    public boolean isAncestorOf(PNode node) {
        PNode p = node.parent;
        while (p != null) {
            if (p == this) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isDescendentOf(PNode node) {
        PNode p = this.parent;
        while (p != null) {
            if (p == node) {
                return true;
            }
            p = p.parent;
        }
        return false;
    }

    public boolean isDescendentOfRoot() {
        return this.getRoot() != null;
    }

    public void moveToBack() {
        PNode p = this.parent;
        if (p != null) {
            p.removeChild(this);
            p.addChild(0, this);
        }
    }

    public void moveInBackOf(PNode sibling) {
        PNode p = this.parent;
        if (p != null && p == sibling.getParent()) {
            p.removeChild(this);
            int index = p.indexOfChild(sibling);
            p.addChild(index, this);
        }
    }

    public void moveToFront() {
        PNode p = this.parent;
        if (p != null) {
            p.removeChild(this);
            p.addChild(this);
        }
    }

    public void moveInFrontOf(PNode sibling) {
        PNode p = this.parent;
        if (p != null && p == sibling.getParent()) {
            p.removeChild(this);
            int index = p.indexOfChild(sibling);
            p.addChild(index + 1, this);
        }
    }

    public PNode getParent() {
        return this.parent;
    }

    public void setParent(PNode newParent) {
        PNode old = this.parent;
        this.parent = newParent;
        this.firePropertyChange(1024, PROPERTY_PARENT, old, this.parent);
    }

    public int indexOfChild(PNode child) {
        if (this.children == null) {
            return -1;
        }
        return this.children.indexOf(child);
    }

    public PNode removeChild(PNode child) {
        return this.removeChild(this.indexOfChild(child));
    }

    public PNode removeChild(int index) {
        PNode child = (PNode)this.children.remove(index);
        if (this.children.size() == 0) {
            this.children = null;
        }
        child.repaint();
        child.setParent(null);
        this.invalidateFullBounds();
        this.firePropertyChange(512, PROPERTY_CHILDREN, null, this.children);
        return child;
    }

    public void removeChildren(Collection childrenNodes) {
        for (PNode each : childrenNodes) {
            this.removeChild(each);
        }
    }

    public void removeAllChildren() {
        if (this.children != null) {
            int count = this.children.size();
            int i = 0;
            while (i < count) {
                PNode each = (PNode)this.children.get(i);
                each.setParent(null);
                ++i;
            }
            this.children = null;
            this.invalidatePaint();
            this.invalidateFullBounds();
            this.firePropertyChange(512, PROPERTY_CHILDREN, null, this.children);
        }
    }

    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.removeChild(this);
        }
    }

    public void reparent(PNode newParent) {
        PAffineTransform originalTransform = this.getLocalToGlobalTransform(null);
        PAffineTransform newTransform = newParent.getGlobalToLocalTransform(null);
        newTransform.concatenate(originalTransform);
        this.removeFromParent();
        this.setTransform(newTransform);
        newParent.addChild(this);
        this.computeFullBounds(this.fullBoundsCache);
    }

    public void replaceWith(PNode replacementNode) {
        if (this.parent != null) {
            PNode p = this.parent;
            int index = p.getChildrenReference().indexOf(this);
            p.removeChild(this);
            p.addChild(index, replacementNode);
        }
    }

    public int getChildrenCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public PNode getChild(int index) {
        return (PNode)this.children.get(index);
    }

    public List getChildrenReference() {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        return this.children;
    }

    public ListIterator getChildrenIterator() {
        if (this.children == null) {
            return Collections.EMPTY_LIST.listIterator();
        }
        return Collections.unmodifiableList(this.children).listIterator();
    }

    public PRoot getRoot() {
        if (this.parent != null) {
            return this.parent.getRoot();
        }
        return null;
    }

    public Collection getAllNodes() {
        return this.getAllNodes(null, null);
    }

    public Collection getAllNodes(PNodeFilter filter, Collection results) {
        if (results == null) {
            results = new ArrayList<PNode>();
        }
        if (filter == null || filter.accept(this)) {
            results.add(this);
        }
        if (filter == null || filter.acceptChildrenOf(this)) {
            int count = this.getChildrenCount();
            int i = 0;
            while (i < count) {
                PNode each = (PNode)this.children.get(i);
                each.getAllNodes(filter, results);
                ++i;
            }
        }
        return results;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        ((PObjectOutputStream)out).writeConditionalObject(this.parent);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.parent = (PNode)in.readObject();
    }

    public String toString() {
        String result = super.toString().replaceAll(".*\\.", "");
        return String.valueOf(result) + "[" + this.paramString() + "]";
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("bounds=" + (this.bounds == null ? "null" : this.bounds.toString()));
        result.append(",fullBounds=" + (this.fullBoundsCache == null ? "null" : this.fullBoundsCache.toString()));
        result.append(",transform=" + (this.transform == null ? "null" : this.transform.toString()));
        result.append(",paint=" + (this.paint == null ? "null" : this.paint.toString()));
        result.append(",transparency=" + this.transparency);
        result.append(",childrenCount=" + this.getChildrenCount());
        if (this.fullBoundsInvalid) {
            result.append(",fullBoundsInvalid");
        }
        if (this.pickable) {
            result.append(",pickable");
        }
        if (this.childrenPickable) {
            result.append(",childrenPickable");
        }
        if (this.visible) {
            result.append(",visible");
        }
        return result.toString();
    }

    public void dispose() {
    }

    public Display getDisplay() {
        PRoot root = this.getRoot();
        return root != null ? root.getDisplay() : Display.getCurrent();
    }

    protected Color createColor(int systemColor) {
        return this.getDisplay().getSystemColor(systemColor);
    }

    protected Color createColor(RGB rgb) {
        return new Color((Device)this.getDisplay(), rgb);
    }

    public static interface PSceneGraphDelegate {
        public void nodePaintInvalidated(PNode var1);

        public void nodeFullBoundsInvalidated(PNode var1);
    }
}

