/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.editor.dnd;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.e4.xwt.tools.ui.designer.editor.dnd.EntryCreateRequest;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.e4.xwt.tools.ui.imagecapture.swt.ImageCapture;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.tools.CreationTool;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EntryCreationTool
extends CreationTool {
    static int shadow = 2;
    private Shell shell;
    private Dimension initSize;

    public EntryCreationTool() {
        this.setUnloadWhenFinished(true);
    }

    public EntryCreationTool(CreationFactory aFactory) {
        super(aFactory);
        this.setUnloadWhenFinished(true);
    }

    public void activate() {
        super.activate();
    }

    private Image getImageFrom(XamlElement node) {
        Object widget;
        if (this.shell == null || this.shell.isDisposed()) {
            this.shell = new Shell();
            this.shell.setLayout((Layout)new RowLayout());
        }
        XWTProxy proxy = new XWTProxy(null);
        try {
            widget = proxy.createWidget(this.shell, node);
            if (widget == null || !(widget instanceof Control)) {
                return null;
            }
        }
        catch (Exception exception) {
            return null;
        }
        this.shell.layout();
        this.shell.pack();
        Image image = null;
        Control control = (Control)widget;
        Rectangle bounds = control.getBounds();
        this.initSize = new Dimension(bounds.width + shadow * 2, bounds.height + shadow * 2);
        if (control instanceof Shell) {
            image = ImageCapture.getInstance().capture(control);
        } else {
            image = new Image((Device)control.getDisplay(), this.initSize.width, this.initSize.height);
            GC gc = new GC((Drawable)image);
            control.print(gc);
            gc.copyArea(0, 0, bounds.width, bounds.height, shadow, shadow);
            int width = this.initSize.width - 1;
            int height = this.initSize.height - 1;
            gc.setForeground(Display.getDefault().getSystemColor(15));
            int i = 0;
            while (i < shadow) {
                gc.drawLine(i, i, width, i);
                gc.drawLine(width, i, width, height);
                gc.drawLine(width, height, i, height);
                gc.drawLine(i, height, i, i);
                --width;
                --height;
                ++i;
            }
            gc.dispose();
        }
        return image;
    }

    public void deactivate() {
        super.deactivate();
    }

    protected Request getTargetRequest() {
        Request req = super.getTargetRequest();
        if (req instanceof EntryCreateRequest && this.initSize != null) {
            ((EntryCreateRequest)req).setInitSize(this.initSize);
        }
        return req;
    }

    protected Request createTargetRequest() {
        EntryCreateRequest request = new EntryCreateRequest();
        request.setFactory(this.getFactory());
        return request;
    }

    protected void setTargetEditPart(EditPart editpart) {
        Class<?> type;
        if (editpart != null && !CompositeEditPart.class.isAssignableFrom(type = editpart.getClass()) && ControlEditPart.class.isAssignableFrom(type)) {
            editpart = editpart.getParent();
        }
        super.setTargetEditPart(editpart);
    }
}

