/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.utils;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.e4.xwt.XWTMaps;
import org.eclipse.e4.xwt.internal.utils.ObjectUtil;
import org.eclipse.e4.xwt.utils.NamedColorsUtil;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ResourceManager {
    public static ResourceManager resources = new ResourceManager();
    private Map<String, Color> key2Colors = new HashMap<String, Color>();
    private Map<String, Font> key2Fonts = new HashMap<String, Font>();
    private Map<String, Image> key2Images = new HashMap<String, Image>();

    private ResourceManager() {
    }

    public Color getColor(String colorStr) {
        Color color = this.key2Colors.get(colorStr);
        if (color == null || color.isDisposed()) {
            color = ColorTool.getColor(colorStr);
            this.key2Colors.put(colorStr, color);
        }
        return color;
    }

    public Font getFont(String fontStr) {
        Font font = this.key2Fonts.get(fontStr);
        if (font == null || font.isDisposed()) {
            font = FontTool.getFont(fontStr);
            this.key2Fonts.put(fontStr, font);
        }
        return font;
    }

    public Image getImage(String imagePath) {
        if (imagePath == null) {
            return null;
        }
        try {
            return this.getImage(new URL(imagePath));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Image getImage(URL file) {
        String key = file.toString();
        Image image = this.key2Images.get(key);
        if (image == null || image.isDisposed()) {
            image = ImageTool.getImage(file);
            this.key2Images.put(key, image);
        }
        return image;
    }

    public synchronized void dispose() {
        Collection<Color> colors = this.key2Colors.values();
        for (Color color : colors) {
            if (color == null) continue;
            color.dispose();
        }
        this.key2Colors.clear();
        Collection<Font> fonts = this.key2Fonts.values();
        for (Font font : fonts) {
            if (font == null) continue;
            font.dispose();
        }
        this.key2Colors.clear();
        Collection<Image> images = this.key2Images.values();
        for (Image image : images) {
            if (image == null) continue;
            image.dispose();
        }
    }

    static class ColorTool {
        ColorTool() {
        }

        static Color getColor(String colorStr) {
            if (NamedColorsUtil.hasColor(colorStr)) {
                return NamedColorsUtil.getColor(colorStr);
            }
            if (colorStr.toLowerCase().startsWith("swt.")) {
                return ColorTool.getSWTColor(colorStr);
            }
            if (colorStr.startsWith("#")) {
                try {
                    int rgb = Integer.parseInt(colorStr.substring(1), 16);
                    return ColorTool.getColor(rgb);
                }
                catch (NumberFormatException numberFormatException) {
                    return null;
                }
            }
            if (colorStr.indexOf(",") != -1) {
                ArrayList<String> rgbs = new ArrayList<String>();
                StringTokenizer stk = new StringTokenizer(colorStr, ",");
                while (stk.hasMoreTokens()) {
                    rgbs.add(stk.nextToken());
                }
                if (rgbs.size() == 3) {
                    try {
                        int r = Integer.parseInt(((String)rgbs.get(0)).trim());
                        int g = Integer.parseInt(((String)rgbs.get(1)).trim());
                        int b = Integer.parseInt(((String)rgbs.get(2)).trim());
                        return ColorTool.getColor(r, g, b);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return null;
                    }
                }
            }
            return ColorTool.getSWTColor(colorStr);
        }

        static Color getColor(int red, int green, int blue) {
            if (red > 255 || green > 255 || blue > 255 || red < 0 || green < 0 || blue < 0) {
                return null;
            }
            return new Color((Device)Display.getCurrent(), red, green, blue);
        }

        static Color getColor(int rgb) {
            int value = 0xFF000000 | rgb;
            int red = value >> 16 & 0xFF;
            int green = value >> 8 & 0xFF;
            int blue = value >> 0 & 0xFF;
            return ColorTool.getColor(red, green, blue);
        }

        static Color getSWTColor(String colorStr) {
            if (!colorStr.toLowerCase().startsWith("swt.")) {
                if (!colorStr.toLowerCase().startsWith("color_")) {
                    colorStr = "COLOR_" + colorStr;
                }
                colorStr = "SWT." + colorStr;
            }
            int swtColor = XWTMaps.getColor(colorStr);
            return ColorTool.getSWTColor(swtColor);
        }

        static Color getSWTColor(int swtValue) {
            return Display.getCurrent().getSystemColor(swtValue);
        }
    }

    static class FontTool {
        FontTool() {
        }

        static Font getFont(String fontStr) {
            if (fontStr.indexOf(",") != -1) {
                StringTokenizer stk = new StringTokenizer(fontStr, ",");
                String name = null;
                int height = 0;
                int style = 0;
                while (stk.hasMoreTokens()) {
                    String token = stk.nextToken().trim();
                    if (token.equalsIgnoreCase("normal") || token.equalsIgnoreCase("bold") || token.equalsIgnoreCase("italic") || token.contains("|")) {
                        style = (Integer)ObjectUtil.resolveValue(token, Integer.class, style);
                        continue;
                    }
                    if (FontTool.isInt(token)) {
                        height = Integer.parseInt(token);
                        continue;
                    }
                    name = token;
                }
                return FontTool.getFont(name, height, style);
            }
            return FontTool.getFont(fontStr, 12, 0);
        }

        static boolean isInt(String value) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
            return true;
        }

        static Font getFont(String name, int height, int style) {
            if (name == null) {
                return null;
            }
            return new Font((Device)Display.getCurrent(), name, height, style);
        }

        static Font getSWTFont() {
            return Display.getCurrent().getSystemFont();
        }
    }

    static class ImageTool {
        ImageTool() {
        }

        static Image getImage(String resource) {
            return ImageTool.getImage(ResourceManager.class.getResource(resource));
        }

        static Image getImage(URL url) {
            Image image;
            if (url == null) {
                return null;
            }
            InputStream stream = url.openStream();
            try {
                image = new Image((Device)Display.getCurrent(), stream);
            }
            catch (Throwable throwable) {
                try {
                    stream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            stream.close();
            return image;
        }
    }
}

