/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.compatibility.internal.contributors.impl;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.platform.discovery.compatibility.internal.contributors.IDynamicRegistryContributor;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.DynamicRegistryContributor;
import org.eclipse.platform.discovery.compatibility.internal.contributors.impl.IdCalculator;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageDescription;
import org.eclipse.platform.discovery.compatibility.internal.readers.ISearchPageParser;
import org.w3c.dom.Element;

public class DynamicObjectTypeContributor
extends DynamicRegistryContributor<ISearchPageDescription>
implements IDynamicRegistryContributor {
    private final IdCalculator calculator = new IdCalculator();

    public DynamicObjectTypeContributor(ISearchPageParser parser) {
        super(parser, "org.eclipse.platform.discovery.runtime.objecttype", "objecttype");
    }

    @Override
    protected void configureTargetElement(Element element, ISearchPageDescription data) {
        element.setAttribute("id", this.calculator.calculateObjectTypeId(data));
        element.setAttribute("displayname", data.getDisplayName());
    }

    @Override
    protected String getContributionDescription(ISearchPageDescription data) {
        return MessageFormat.format("Dynamic ObjectType for search page: {0}", data.toString());
    }

    @Override
    protected String getFailureMessage(Collection<ISearchPageDescription> failedContributors) {
        return "Dynamic object type contribution failed for the following search pages:" + failedContributors;
    }
}

