/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources.semantic.examples.providers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.SyncDirection;
import org.eclipse.core.resources.semantic.examples.providers.Messages;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFile;
import org.eclipse.core.resources.semantic.examples.remote.RemoteFolder;
import org.eclipse.core.resources.semantic.examples.remote.RemoteItem;
import org.eclipse.core.resources.semantic.examples.remote.RemoteStore;
import org.eclipse.core.resources.semantic.examples.remote.SemanticResourcesPluginExamplesCore;
import org.eclipse.core.resources.semantic.spi.CachingContentProvider;
import org.eclipse.core.resources.semantic.spi.FileCacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ICacheService;
import org.eclipse.core.resources.semantic.spi.ICacheServiceFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderRemote;
import org.eclipse.core.resources.semantic.spi.ISemanticFileHistoryProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.resources.semantic.spi.ISemanticResourceRuleFactory;
import org.eclipse.core.resources.semantic.spi.ISemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.ISemanticTreeDeepFirstVisitor;
import org.eclipse.core.resources.semantic.spi.SemanticRevisionStorage;
import org.eclipse.core.resources.semantic.spi.SemanticSpiResourceInfo;
import org.eclipse.core.resources.semantic.spi.SemanticTreeWalker;
import org.eclipse.core.resources.semantic.spi.Util;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;

public class RemoteStoreContentProvider
extends CachingContentProvider
implements ISemanticContentProviderRemote {
    private static final IStatus OKSTATUS = new Status(0, SemanticResourcesPluginExamplesCore.PLUGIN_ID, "");
    private static final QualifiedName ATTR_READONLY = new QualifiedName(SemanticResourcesPluginExamplesCore.PLUGIN_ID, "ReadOnly");

    public Object getAdapter(Class adapter) {
        if (adapter == ISemanticFileHistoryProvider.class) {
            return new ISemanticFileHistoryProvider(){

                public IFileRevision getWorkspaceFileRevision(ISemanticFileStore store) throws CoreException {
                    RemoteItem item = RemoteStoreContentProvider.this.getRemoteItem(RemoteStoreContentProvider.this.getStore(), store.getPath());
                    if (item instanceof RemoteFile) {
                        return ((RemoteFile)item).getCurrentRevision(store);
                    }
                    return null;
                }

                public IFileHistory getHistoryFor(ISemanticFileStore store, int options, IProgressMonitor monitor) throws CoreException {
                    RemoteItem item = RemoteStoreContentProvider.this.getRemoteItem(RemoteStoreContentProvider.this.getStore(), store.getPath());
                    if (item instanceof RemoteFile) {
                        return ((RemoteFile)item).getHistory(store);
                    }
                    return null;
                }

                public IFileRevision[] getResourceVariants(final ISemanticFileStore semanticFileStore, IProgressMonitor monitor) {
                    RemoteItem item = RemoteStoreContentProvider.this.getStore().getItemByPath(semanticFileStore.getPath().removeFirstSegments(2));
                    if (!(item instanceof RemoteFile)) {
                        return null;
                    }
                    final RemoteFile file = (RemoteFile)item;
                    FileRevision remote = new FileRevision(){

                        public IFileRevision withAllProperties(IProgressMonitor actmonitor) throws CoreException {
                            return this;
                        }

                        public boolean isPropertyMissing() {
                            return false;
                        }

                        public URI getURI() {
                            try {
                                return new URI(file.getPath().toString());
                            }
                            catch (URISyntaxException uRISyntaxException) {
                                throw new RuntimeException(Messages.RemoteStoreContentProvider_URIError_XMSG);
                            }
                        }

                        public long getTimestamp() {
                            return file.getTimestamp();
                        }

                        public IStorage getStorage(IProgressMonitor actmonitor) throws CoreException {
                            SemanticRevisionStorage storage = new SemanticRevisionStorage(semanticFileStore);
                            storage.setContents((InputStream)new ByteArrayInputStream(file.getContent()), actmonitor);
                            return storage;
                        }

                        public String getName() {
                            return file.getName();
                        }

                        public String getContentIdentifier() {
                            return Long.toString(file.getTimestamp());
                        }

                        public String getComment() {
                            return null;
                        }

                        public String getAuthor() {
                            return null;
                        }

                        public boolean exists() {
                            return true;
                        }
                    };
                    IFileRevision[] iFileRevisionArray = new IFileRevision[2];
                    iFileRevisionArray[1] = remote;
                    return iFileRevisionArray;
                }
            };
        }
        return super.getAdapter(adapter);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void synchronizeContentWithRemote(ISemanticFileStore semanticFileStore, SyncDirection direction, IProgressMonitor monitor, MultiStatus status) {
        RemoteItem item;
        RemoteStore store;
        monitor.setTaskName(NLS.bind((String)Messages.RemoteStoreContentProvider_Syncing_XMSG, (Object)semanticFileStore.getPath().toString()));
        try {
            store = this.getStore();
            item = this.getRemoteItem(store, semanticFileStore.getPath());
            if (item == null) {
                throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, semanticFileStore.getPath(), Messages.RemoteStoreContentProvider_RemoteItemNotFound_XMSG);
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
            return;
        }
        if (item.getType() == RemoteItem.Type.FOLDER) {
            RemoteFolder folder = (RemoteFolder)item;
            try {
                String[] childNames;
                String[] stringArray = childNames = semanticFileStore.childNames(0, monitor);
                int n = childNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String name = stringArray[n2];
                    if (!folder.hasChild(name)) {
                        ((ISemanticFileStore)semanticFileStore.getChild(name)).remove(monitor);
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                status.add(e.getStatus());
                return;
            }
            for (RemoteItem childItem : folder.getChildren()) {
                ISemanticFileStore fileStore = (ISemanticFileStore)semanticFileStore.getChild(childItem.getName());
                if (!fileStore.fetchInfo().exists()) {
                    try {
                        if (childItem.getType() == RemoteItem.Type.FOLDER) {
                            semanticFileStore.addChildFolder(childItem.getName());
                        } else if (childItem.getType() == RemoteItem.Type.FILE) {
                            semanticFileStore.addChildFile(childItem.getName());
                            this.setReadOnly((ISemanticFileStore)semanticFileStore.getChild(childItem.getName()), true, monitor);
                        }
                    }
                    catch (CoreException e) {
                        status.add(e.getStatus());
                        return;
                    }
                }
                try {
                    store.serialize(monitor);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
                this.synchronizeContentWithRemote(fileStore, direction, monitor, status);
            }
            return;
        }
        if (item.getType() != RemoteItem.Type.FILE) return;
        try {
            RemoteFile file = (RemoteFile)item;
            long remoteTime = file.getTimestamp();
            long localTime = this.getResourceTimestamp(semanticFileStore, monitor);
            ICacheService srv = this.getCacheService();
            if (direction == SyncDirection.OUTGOING || localTime > remoteTime) {
                ByteArrayOutputStream os = file.getOutputStream(false);
                Util.transferStreams((InputStream)srv.getContent(semanticFileStore.getPath()), (OutputStream)os, (IProgressMonitor)monitor);
                file.setTimestamp(localTime);
                store.serialize(monitor);
                return;
            }
            if (direction != SyncDirection.INCOMING && remoteTime <= localTime) return;
            srv.addContent(semanticFileStore.getPath(), (InputStream)new ByteArrayInputStream(file.getContent()), 0, monitor);
            this.setResourceTimestamp(semanticFileStore, remoteTime, monitor);
            return;
        }
        catch (CoreException e) {
            status.add(e.getStatus());
        }
    }

    public void addResource(ISemanticFileStore parentStore, String name, ISemanticFileStore.ResourceType resourceType, IProgressMonitor monitor) throws CoreException {
        switch (resourceType) {
            case UNKNOWN_TYPE: {
                this.addResourceFromRemote(parentStore, name, monitor);
                break;
            }
            case FILE_TYPE: {
                this.addFileFromRemote(parentStore, name, monitor);
                break;
            }
            case FOLDER_TYPE: {
                this.addFolderFromRemote(parentStore, name, monitor);
                break;
            }
            case PROJECT_TYPE: {
                throw new CoreException((IStatus)new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, Messages.RemoteStoreContentProvider_CannotCreateProject_XMSG));
            }
        }
    }

    private void addFileFromRemote(ISemanticFileStore parentStore, String name, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getRemoteItem(this.getStore(), parentStore.getPath().append(name));
        if (item == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, parentStore.getPath(), Messages.RemoteStoreContentProvider_RemoteItemNotFound_XMSG);
        }
        if (item.getType() != RemoteItem.Type.FILE) {
            Status error = new Status(4, SemanticResourcesPluginExamplesCore.PLUGIN_ID, Messages.RemoteStoreContentProvider_RemoteNotFile_XMSG);
            throw new CoreException((IStatus)error);
        }
        parentStore.addChildFile(name);
        ISemanticFileStore newChild = (ISemanticFileStore)parentStore.getChild(name);
        this.setReadOnly(newChild, true, monitor);
    }

    private void addFolderFromRemote(ISemanticFileStore parentStore, String name, IProgressMonitor monitor) throws CoreException {
        parentStore.addChildFolder(name);
    }

    private void addResourceFromRemote(ISemanticFileStore parentStore, String name, IProgressMonitor monitor) throws CoreException {
        RemoteItem item = this.getRemoteItem(this.getStore(), parentStore.getPath().append(name));
        if (item == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, parentStore.getPath(), Messages.RemoteStoreContentProvider_RemoteNotFound_XMSG);
        }
        if (item.getType() == RemoteItem.Type.FOLDER) {
            this.addFolderFromRemote(parentStore, name, monitor);
        } else {
            this.addFileFromRemote(parentStore, name, monitor);
        }
    }

    public void createResourceRemotely(ISemanticFileStore parentStore, String name, Object context, IProgressMonitor monitor) throws CoreException {
        RemoteStore store = this.getStore();
        RemoteItem item = this.getRemoteItem(store, parentStore.getPath());
        if (item.getType() == RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentStore.getPath(), Messages.RemoteStoreContentProvider_ParentIsFile_XMSG);
        }
        ((RemoteFolder)item).addFolder(name);
        store.serialize(monitor);
        this.addFolderFromRemote(parentStore, name, monitor);
    }

    public void deleteRemotely(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        RemoteStore store = this.getStore();
        RemoteItem item = this.getRemoteItem(store, semanticFileStore.getPath());
        item.getParent().deleteChild(item.getName());
        store.serialize(monitor);
        this.removeResource(semanticFileStore, monitor);
    }

    public void revertChanges(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        RemoteStore store = this.getStore();
        RemoteItem item = this.getRemoteItem(store, semanticFileStore.getPath());
        if (item.getType() != RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, semanticFileStore.getPath(), Messages.RemoteStoreContentProvider_FoldersNoRevert_XMSG);
        }
        RemoteFile file = (RemoteFile)item;
        this.getCacheService().addContent(semanticFileStore.getPath(), (InputStream)new ByteArrayInputStream(file.getContent()), 0, monitor);
        this.setResourceTimestamp(semanticFileStore, file.getTimestamp(), monitor);
        this.setReadOnly(semanticFileStore, true, monitor);
    }

    public IStatus validateRemoteCreate(ISemanticFileStore parentStore, String childName, Object shell) {
        return OKSTATUS;
    }

    public IStatus validateRemoteDelete(ISemanticFileStore semanticFileStore, Object shell) {
        return OKSTATUS;
    }

    public IStatus validateEdit(ISemanticFileStore[] stores, Object shell) {
        if (shell != null) {
            MultiStatus multi = new MultiStatus(SemanticResourcesPluginExamplesCore.PLUGIN_ID, 0, Messages.RemoteStoreContentProvider_ValidateEdit_XGRP, null);
            ISemanticFileStore[] iSemanticFileStoreArray = stores;
            int n = stores.length;
            int n2 = 0;
            while (n2 < n) {
                ISemanticFileStore store = iSemanticFileStoreArray[n2];
                try {
                    this.setReadOnly(store, false, null);
                }
                catch (CoreException e) {
                    SemanticResourcesPluginExamplesCore.getDefault().getLog().log(e.getStatus());
                    multi.add(e.getStatus());
                }
                ++n2;
            }
            return multi;
        }
        ISemanticFileStore[] iSemanticFileStoreArray = stores;
        int n = stores.length;
        int n3 = 0;
        while (n3 < n) {
            ISemanticFileStore store = iSemanticFileStoreArray[n3];
            try {
                this.setReadOnly(store, false, null);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
            ++n3;
        }
        return OKSTATUS;
    }

    RemoteItem getRemoteItem(RemoteStore remoteStore, IPath path) {
        if (remoteStore == null) {
            return null;
        }
        IPath relPath = path.removeFirstSegments(this.getRootStore().getPath().segmentCount());
        return remoteStore.getItemByPath(relPath);
    }

    RemoteStore getStore() {
        IProject ownProject = ResourcesPlugin.getWorkspace().getRoot().findMember(this.getRootStore().getPath()).getProject();
        RemoteStore store = (RemoteStore)ownProject.getAdapter(RemoteStore.class);
        return store;
    }

    public ICacheServiceFactory getCacheServiceFactory() throws CoreException {
        return new FileCacheServiceFactory();
    }

    public InputStream openInputStreamInternal(ISemanticFileStore store, IProgressMonitor monitor, CachingContentProvider.ICacheTimestampSetter timeStampSetter) throws CoreException {
        RemoteFile file = (RemoteFile)this.getRemoteItem(this.getStore(), store.getPath());
        if (file == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.REMOTE_RESOURCE_NOT_FOUND, store.getPath(), Messages.RemoteStoreContentProvider_RemoteItemNotFound_XMSG);
        }
        timeStampSetter.setTimestamp(file.getTimestamp());
        return new ByteArrayInputStream(file.getContent());
    }

    public void createFileRemotely(ISemanticFileStore parentStore, String name, InputStream source, Object context, IProgressMonitor monitor) throws CoreException {
        RemoteStore store = this.getStore();
        RemoteItem item = this.getRemoteItem(store, parentStore.getPath());
        if (item.getType() == RemoteItem.Type.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, parentStore.getPath(), Messages.RemoteStoreContentProvider_CannotCreateFileChild_XMSG);
        }
        RemoteFile file = ((RemoteFolder)item).addFile(name, new byte[0], System.currentTimeMillis());
        if (source != null) {
            Util.transferStreams((InputStream)source, (OutputStream)file.getOutputStream(false), (IProgressMonitor)monitor);
        }
        store.serialize(monitor);
        this.addFileFromRemote(parentStore, name, monitor);
    }

    public ISemanticSpiResourceInfo fetchResourceInfo(ISemanticFileStore semanticFileStore, int options, IProgressMonitor monitor) throws CoreException {
        String uriString = null;
        boolean readOnly = SemanticSpiResourceInfo.isOptionRequested((int)16, (int)options) ? this.isReadOnly(semanticFileStore) : false;
        boolean existsRemotely = false;
        if (SemanticSpiResourceInfo.isOptionRequested((int)32, (int)options)) {
            existsRemotely = this.getRemoteItem(this.getStore(), semanticFileStore.getPath()) != null;
        }
        return new SemanticSpiResourceInfo(options, false, false, readOnly, existsRemotely, uriString, null);
    }

    private boolean isReadOnly(ISemanticFileStore semanticFileStore) throws CoreException {
        return semanticFileStore.getPersistentProperty(ATTR_READONLY) != null;
    }

    public void removeResource(ISemanticFileStore semanticFileStore, IProgressMonitor monitor) throws CoreException {
        ISemanticTreeDeepFirstVisitor visitor = new ISemanticTreeDeepFirstVisitor(){

            public void visit(ISemanticFileStore store, IProgressMonitor actMonitor) throws CoreException {
                if (store.getContentProviderID() == null || store.getPath().equals((Object)RemoteStoreContentProvider.this.getRootStore().getPath())) {
                    try {
                        RemoteStoreContentProvider.this.deleteCache(store, actMonitor);
                    }
                    catch (CoreException coreException) {}
                    store.remove(actMonitor);
                } else {
                    store.getEffectiveContentProvider().removeResource(store, actMonitor);
                }
            }

            public boolean shouldVisitChildren(ISemanticFileStore store, IProgressMonitor actMonitor) throws CoreException {
                return store.getContentProviderID() == null;
            }
        };
        SemanticTreeWalker.accept((ISemanticFileStore)semanticFileStore, (ISemanticTreeDeepFirstVisitor)visitor, (IProgressMonitor)monitor);
    }

    public void setReadOnly(ISemanticFileStore semanticFileStore, boolean readonly, IProgressMonitor monitor) throws CoreException {
        semanticFileStore.setPersistentProperty(ATTR_READONLY, readonly ? "" : null);
    }

    public IStatus validateSave(ISemanticFileStore semanticFileStore) {
        return this.validateEdit(new ISemanticFileStore[]{semanticFileStore}, null);
    }

    public ISemanticResourceRuleFactory getRuleFactory() {
        return new ISemanticResourceRuleFactory(){

            public ISemanticFileStore validateEditRule(ISemanticFileStore[] stores) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore refreshRule(ISemanticFileStore store) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore moveRule(ISemanticFileStore source, ISemanticFileStore destination) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore modifyRule(ISemanticFileStore store) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore deleteRule(ISemanticFileStore store) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore createRule(ISemanticFileStore store) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore copyRule(ISemanticFileStore source, ISemanticFileStore destination) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }

            public ISemanticFileStore charsetRule(ISemanticFileStore store) {
                return (ISemanticFileStore)RemoteStoreContentProvider.this.getRootStore().getParent();
            }
        };
    }
}

