/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.core.impl.dom.DocumentCSSImpl;
import org.eclipse.e4.ui.css.core.impl.dom.ViewCSSImpl;
import org.eclipse.e4.ui.css.swt.engine.CSSSWTEngineImpl;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.eclipse.e4.ui.tests.css.core.util.TestElement;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.css.ViewCSS;
import org.w3c.dom.stylesheets.StyleSheet;

public class CascadeTest
extends TestCase {
    private Display display;
    private CSSSWTEngineImpl engine;

    protected void setUp() throws Exception {
        this.display = Display.getDefault();
        this.engine = new CSSSWTEngineImpl(this.display);
    }

    public void testPosition() throws Exception {
        String css = "Button { color: blue; font-weight: bold; }\nButton { color: black }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"black", (String)style.getPropertyCSSValue("color").getCssText());
        CascadeTest.assertEquals((String)"bold", (String)style.getPropertyCSSValue("font-weight").getCssText());
    }

    public void testSpecificity() throws Exception {
        String css = "Label, Button.special { color: black; }\nButton { color: blue; font-weight: bold; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"blue", (String)style.getPropertyCSSValue("color").getCssText());
        button.setClass("special");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"black", (String)style.getPropertyCSSValue("color").getCssText());
        CascadeTest.assertEquals((String)"bold", (String)style.getPropertyCSSValue("font-weight").getCssText());
    }

    public void testSpecificities() throws Exception {
        String css = "* { color: black; }\nButton { color: blue; }\nButton[BORDER] { color: gray; }\nButton.special { color: green; }\nButton#myid { color: red; }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement label = new TestElement("Label", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)label), null);
        CascadeTest.assertEquals((String)"black", (String)style.getPropertyCSSValue("color").getCssText());
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"blue", (String)style.getPropertyCSSValue("color").getCssText());
        button.setAttribute("BORDER", "true");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"gray", (String)style.getPropertyCSSValue("color").getCssText());
        button.setClass("special");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"green", (String)style.getPropertyCSSValue("color").getCssText());
        button.setId("myid");
        style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"red", (String)style.getPropertyCSSValue("color").getCssText());
    }

    private static ViewCSS createViewCss(String css) throws IOException {
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        DocumentCSSImpl docCss = new DocumentCSSImpl();
        docCss.addStyleSheet((StyleSheet)styleSheet);
        return new ViewCSSImpl((DocumentCSS)docCss);
    }

    public void testBug261081() throws Exception {
        String css = "Button, Label { color: blue; font-weight: bold; }\nButton { color: black }\n";
        ViewCSS viewCSS = CascadeTest.createViewCss(css);
        TestElement button = new TestElement("Button", (CSSEngine)this.engine);
        CSSStyleDeclaration style = viewCSS.getComputedStyle((Element)((Object)button), null);
        CascadeTest.assertEquals((String)"black", (String)style.getPropertyCSSValue("color").getCssText());
        CascadeTest.assertEquals((String)"bold", (String)style.getPropertyCSSValue("font-weight").getCssText());
    }
}

