/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import org.eclipse.platform.discovery.ui.internal.view.impl.TextControl;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.InShellPageObject;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.results.StringResult;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotText;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class TextControlPageObject
extends InShellPageObject {
    private static final String LABEL_TEXT = "The Label";
    private TextControl textControl;

    @Override
    protected void createContent(Shell parent, FormToolkit formToolkit) {
        Label label = formToolkit.createLabel((Composite)parent, LABEL_TEXT, 0);
        Text text = formToolkit.createText((Composite)parent, "", 0);
        this.textControl = new TextControl(text, label);
    }

    public void enterText(String text) {
        this.swtBotText().typeText(text);
    }

    public String get() {
        return (String)UIThreadRunnable.syncExec((Result)new StringResult(){

            public String run() {
                return TextControlPageObject.this.textControl.get();
            }
        });
    }

    public String getDisplayedText() {
        return this.swtBotText().getText();
    }

    public void setEnabled(final boolean enabled) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                TextControlPageObject.this.textControl.setEnabled(enabled);
            }
        });
    }

    public void setMessage(final String message) {
        UIThreadRunnable.syncExec((VoidResult)new VoidResult(){

            public void run() {
                TextControlPageObject.this.textControl.setMessage(message);
            }
        });
    }

    private SWTBotText swtBotText() {
        return this.bot().text();
    }

    public String getMessage() {
        return (String)UIThreadRunnable.syncExec((Result)new StringResult(){

            public String run() {
                return TextControlPageObject.this.textControl.getControl().getMessage();
            }
        });
    }

    public void focus() {
        this.swtBotText().setFocus();
    }
}

