/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.core.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTCodeGenUtil {
    public static String generate(Class<?> aBean) {
        return XWTCodeGenUtil.generate(aBean, false);
    }

    public static String generate(Class<?> aBean, boolean root) {
        if (aBean == null) {
            return null;
        }
        try {
            PropertyDescriptor[] propertyDescriptors;
            StringBuffer result = new StringBuffer();
            if (root) {
                String packageName;
                result.append("<Composite xmlns=\"http://www.eclipse.org/xwt/presentation\"");
                result.append("\t xmlns:x=\"http://www.eclipse.org/xwt\"");
                String string = packageName = aBean.getPackage() == null ? null : aBean.getPackage().getName();
                if (packageName != null) {
                    result.append("\t xmlns:c=\"clr-namespace:" + packageName + "\"");
                }
                result.append("\t xmlns:j=\"clr-namespace:java.lang\"");
                result.append("\t x:Class=\"" + aBean.getName() + "\">");
            } else {
                result.append("<Composite>");
            }
            result.append("\t <Composite.layout>");
            result.append("\t\t <GridLayout  numColumns=\"4\" />");
            result.append("\t </Composite.layout>");
            BeanInfo beanInfo = Introspector.getBeanInfo(aBean);
            PropertyDescriptor[] propertyDescriptorArray = propertyDescriptors = beanInfo.getPropertyDescriptors();
            int n = propertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                String name = pd.getName();
                if (name != null && !"class".equals(name)) {
                    Class<?> propertyType = pd.getPropertyType();
                    if (propertyType.isPrimitive() || propertyType == String.class || propertyType == URL.class) {
                        result.append("\t <Label text=\"" + pd.getDisplayName() + "\"/>");
                        result.append("\t <Text x:Style=\"Border\" text=\"{Binding path=" + pd.getName() + "}\">");
                        result.append("\t\t <Text.layoutData>");
                        result.append("\t\t\t <GridData grabExcessHorizontalSpace=\"true\"");
                        result.append("\t\t\t\t horizontalAlignment=\"GridData.FILL\" widthHint=\"100\"/>");
                        result.append("\t\t </Text.layoutData>");
                        result.append("\t </Text>");
                    } else if (propertyType.isEnum()) {
                        result.append("\t <Label text=\"" + pd.getDisplayName() + "\"/>");
                        result.append("\t <Combo text=\"{Binding path=" + pd.getName() + "}\">");
                        result.append("\t\t <Combo.layoutData>");
                        result.append("\t\t\t <GridData grabExcessHorizontalSpace=\"true\"");
                        result.append("\t\t\t\t horizontalAlignment=\"GridData.FILL\" widthHint=\"100\"/>");
                        result.append("\t\t </Combo.layoutData>");
                        result.append("\t\t <Combo.items>");
                        ?[] objArray = propertyType.getEnumConstants();
                        int n3 = objArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Object object = objArray[n4];
                            result.append("\t\t\t <j:String>" + object.toString() + "</j:String>");
                            ++n4;
                        }
                        result.append("\t\t </Combo.items>");
                        result.append("\t </Combo>");
                    } else {
                        result.append("\t <Group text=\"" + pd.getDisplayName() + "\">");
                        result.append("\t\t <Group.layout>");
                        result.append("\t\t\t <FillLayout/>");
                        result.append("\t\t </Group.layout>");
                        String elementType = propertyType.getSimpleName();
                        result.append("\t\t <c:" + elementType + " DataContext=\"{Binding path=" + pd.getName() + "}\"/>");
                        result.append("\t\t <Group.layoutData>");
                        result.append("\t\t\t <GridData grabExcessHorizontalSpace=\"true\" horizontalSpan=\"4\"");
                        result.append("\t\t\t\t horizontalAlignment=\"GridData.FILL\" widthHint=\"200\"/>");
                        result.append("\t\t </Group.layoutData>");
                        result.append("\t </Group>");
                    }
                }
                ++n2;
            }
            result.append("</Composite>");
            return result.toString();
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
    }
}

