/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.utils;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlNode;
import org.eclipse.gef.ui.parts.TreeViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TableViewer;

public class XWTModelUtil {
    public static XamlAttribute getAdaptableAttribute(XamlNode parent, String[] adapters, String attrName, String namespace) {
        XamlAttribute attribute = null;
        if (adapters == null || adapters.length == 0) {
            return null;
        }
        ArrayList<String> copyAdapters = new ArrayList<String>(Arrays.asList(adapters));
        if (copyAdapters.remove(attrName)) {
            for (String other : copyAdapters) {
                attribute = parent.getAttribute(other, namespace);
                if (attribute != null) break;
            }
        }
        return attribute;
    }

    public static XamlAttribute getAdaptableAttribute(XamlNode parent, String attrName, String namespace) {
        if (parent == null || attrName == null) {
            return null;
        }
        XamlAttribute attribute = parent.getAttribute(attrName, namespace);
        if (attribute == null) {
            IMetaclass metaclass = XWTUtility.getMetaclass(parent);
            if (metaclass == null) {
                return null;
            }
            Class type = metaclass.getType();
            if (TableViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getAdaptableAttribute(parent, new String[]{"table", "control"}, attrName, namespace);
            } else if (ListViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getAdaptableAttribute(parent, new String[]{"list", "control"}, attrName, namespace);
            } else if (TreeViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getAdaptableAttribute(parent, new String[]{"tree", "control"}, attrName, namespace);
            } else if (ComboViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getAdaptableAttribute(parent, new String[]{"combo", "control"}, attrName, namespace);
            }
        }
        return attribute;
    }

    public static XamlAttribute getChildAttribute(XamlNode parent, String attrName, String namespace) {
        if (parent == null || attrName == null) {
            return null;
        }
        XamlAttribute attribute = parent.getAttribute(attrName, namespace);
        if (attribute == null) {
            IMetaclass metaclass = XWTUtility.getMetaclass(parent);
            if (metaclass == null) {
                return null;
            }
            Class type = metaclass.getType();
            if (TableViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getChildAttribute(parent, new String[]{"table", "control"}, attrName, namespace);
            } else if (ListViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getChildAttribute(parent, new String[]{"list", "control"}, attrName, namespace);
            } else if (TreeViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getChildAttribute(parent, new String[]{"tree", "control"}, attrName, namespace);
            } else if (ComboViewer.class.isAssignableFrom(type)) {
                attribute = XWTModelUtil.getChildAttribute(parent, new String[]{"combo", "control"}, attrName, namespace);
            }
        }
        return attribute;
    }

    public static XamlAttribute getChildAttribute(XamlNode parent, String[] adapters, String attrName, String namespace) {
        XamlAttribute attribute = null;
        if (adapters == null || adapters.length == 0) {
            return null;
        }
        ArrayList<String> copyAdapters = new ArrayList<String>(Arrays.asList(adapters));
        for (String other : copyAdapters) {
            XamlAttribute adapter = parent.getAttribute(other, namespace);
            if (adapter != null && (attribute = adapter.getAttribute(attrName, namespace)) != null) break;
        }
        return attribute;
    }
}

