/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts.debug.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.extensions.EventUtils;
import org.eclipse.e4.core.internal.contexts.EclipseContext;
import org.eclipse.e4.core.internal.contexts.debug.ui.WeakContextRef;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.osgi.service.event.EventAdmin;

public class FindTargetAction {
    private static final String OWNING_ME = "modelElement";
    @Inject
    public EventAdmin eventAdmin;
    private Cursor targetCursor;
    private Cursor displayCursor;

    @Inject
    public FindTargetAction(Display display) {
        this.targetCursor = new Cursor((Device)display, 2);
    }

    @PreDestroy
    public void dispose() {
        if (this.targetCursor != null) {
            this.targetCursor.dispose();
            this.targetCursor = null;
        }
    }

    @Execute
    public void doFindTarget(MWindow win) {
        final Control windowWidget = (Control)win.getWidget();
        final Display display = windowWidget.getDisplay();
        this.displayCursor = windowWidget.getCursor();
        windowWidget.setCursor(this.targetCursor);
        windowWidget.setCapture(true);
        final LinkedList<1> filters = new LinkedList<1>();
        filters.add(new Listener(){

            public void handleEvent(Event event) {
                Control control = display.getCursorControl();
                IEclipseContext targetContext = null;
                while (control != null) {
                    Object data = control.getData(FindTargetAction.OWNING_ME);
                    if (data instanceof MContext && (targetContext = ((MContext)data).getContext()) != null) break;
                    control = control.getParent();
                }
                if (targetContext != null) {
                    ArrayList<WeakContextRef> contexts = new ArrayList<WeakContextRef>();
                    while (targetContext != null) {
                        contexts.add(new WeakContextRef((EclipseContext)targetContext));
                        targetContext = targetContext.getParent();
                    }
                    Collections.reverse(contexts);
                    TreePath path = new TreePath(contexts.toArray());
                    EventUtils.send((EventAdmin)FindTargetAction.this.eventAdmin, (String)"e4/contexts/debug/selectContext", (Object)path);
                }
                windowWidget.setCapture(false);
                windowWidget.setCursor(FindTargetAction.this.displayCursor);
                for (Listener f : filters) {
                    display.removeFilter(3, f);
                }
                filters.clear();
            }
        });
        for (Listener listener : filters) {
            display.addFilter(3, listener);
        }
    }
}

