/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tm.builder;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.e4.tm.builder.AbstractBuilder;
import org.eclipse.e4.tm.builder.IBinder;
import org.eclipse.e4.tm.builder.IBinderContext;
import org.eclipse.e4.tm.builder.swt.SwtBuilder;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBinder
extends AdapterImpl
implements IBinder {
    public static final String ANNOTATION_URI = SwtBuilder.getAnnotationUri();
    protected IBinderContext context = null;
    protected Object UNDEFINED = new Object();

    @Override
    public Object update(EObject eObject, Object object, IBinderContext context) {
        this.context = context;
        try {
            if (object == null) {
                object = this.create(eObject);
                context.putObject(eObject, object);
                context.fireObjectHandled(1, eObject, object);
                if (object != null) {
                    EList adapters = eObject.eAdapters();
                    if (adapters.contains((Object)this)) {
                        System.err.println("Duplicate adapter for " + eObject);
                    }
                    adapters.add((Object)this);
                    if (eObject != object) {
                        this.updateFeatures(eObject, object);
                    } else {
                        for (EObject child : eObject.eContents()) {
                            context.update(child);
                        }
                    }
                }
            } else {
                context.fireObjectHandled(2, eObject, object);
            }
        }
        finally {
            context = null;
        }
        return object;
    }

    @Override
    public void dispose(EObject eObject, Object object, IBinderContext context) {
        eObject.eAdapters().remove((Object)this);
        context.putObject(eObject, null);
        for (EObject child : eObject.eContents()) {
            context.dispose(child);
        }
        if (object != null) {
            AbstractBuilder.dispose(object);
        }
    }

    @Override
    public <T> T adapt(Object value, Class<T> c) {
        return (T)(c.isInstance(value) ? value : null);
    }

    protected <T> T getParent(EObject eObject, Class<T> c) {
        EObject parent = eObject.eContainer();
        if (parent == null) {
            return this.context.getRootObject(c);
        }
        return this.context.getObject(parent, c);
    }

    protected void updateFeatures(EObject eObject, Object object) {
        EList features = eObject.eClass().getEAllStructuralFeatures();
        for (EStructuralFeature feature : features) {
            if (!this.shouldHandleFeature(feature) || this.shouldntHandleFeature(feature)) continue;
            this.update(eObject, feature, object, true);
        }
    }

    protected void update(EObject control, EStructuralFeature feature, Object object, boolean isInit) {
        if (feature instanceof EAttribute) {
            this.copyFeatureValue2Property(control, control.eGet(feature), feature, object, isInit);
        } else if (feature.isMany()) {
            EList values = (EList)control.eGet(feature);
            for (EObject value : values) {
                if (value == null) continue;
                this.context.update(value);
            }
        } else {
            EObject featureValue = (EObject)control.eGet(feature);
            if (featureValue != null) {
                Object value = this.context.update(featureValue);
                this.copyFeatureValue2Property(control, value, feature, object, isInit);
            }
        }
    }

    protected Object convertValue(EStructuralFeature feature, Object value) {
        return value;
    }

    protected Exception copyFeatureValue2Property(EObject eObject, Object value, EStructuralFeature feature, Object object, boolean isInit) {
        int pos;
        String access = this.getAccessMethod(feature, eObject.eClass());
        String name = this.getRealName(feature);
        value = this.convertValue(feature, value);
        boolean equals = this.featureEqualsProperty(feature, eObject.eClass(), value, object);
        Exception ex = null;
        if ("field".equals(access)) {
            if (!equals) {
                ex = this.context.setFieldProperty(object, name, value);
            }
        } else if ("property".equals(access)) {
            if (!equals) {
                ex = this.context.setSetterProperty(object, name, value);
            }
        } else if ("event".equals(access)) {
            if (isInit && feature != null) {
                this.handleEventFeature(eObject, feature, object);
            }
        } else if (!"binder".equals(access) && access != null && access.length() > 0 && !equals && (pos = access.indexOf(32)) >= 0) {
            String setter = access.substring(pos + 1).trim();
            ex = this.context.setMethodProperty(object, setter, new Object[]{value});
        }
        if (ex != null) {
            System.err.println("Couldn't set " + name + " " + access + " of " + object + ": " + ex);
            Throwable cause = ex.getCause();
            if (cause != null && cause != ex) {
                System.err.println("Cause: " + cause);
            }
        }
        return ex;
    }

    protected String getAccessMethod(EStructuralFeature feature, EClass realClass) {
        return AbstractBuilder.getFeatureAnnotation(feature, realClass, ANNOTATION_URI, "access", null);
    }

    protected boolean featureEqualsProperty(EStructuralFeature feature, EClass realClass, Object value, Object object) {
        return !feature.isMany() && this.equals(value, this.getPropertyValue(feature, realClass, object, this.UNDEFINED));
    }

    protected boolean equals(Object value, Object oldValue) {
        return oldValue == value || oldValue != null && oldValue.equals(value);
    }

    protected boolean shouldHandleFeature(EStructuralFeature feature) {
        return true;
    }

    protected boolean shouldntHandleFeature(EStructuralFeature feature) {
        return feature instanceof EReference && ((EReference)feature).isContainer();
    }

    protected void handleEventFeature(EObject control, EStructuralFeature feature, Object object) {
    }

    protected String getRealName(EStructuralFeature feature) {
        return AbstractBuilder.getAnnotation((EModelElement)feature, ANNOTATION_URI, "realName", feature.getName());
    }

    protected String getClassAnnotation(EObject control) {
        return AbstractBuilder.getClassAnnotation(control.eClass(), ANNOTATION_URI, "style", null);
    }

    protected Class<?> getToolkitClass(EObject eObject, boolean warn) {
        String packageName;
        String eClassName = eObject.eClass().getName();
        String className = AbstractBuilder.getClassAnnotation(eObject.eClass(), ANNOTATION_URI, "realName", null);
        if (className == null) {
            className = AbstractBuilder.getClassAnnotation(eObject.eClass(), ANNOTATION_URI, "javaClass", eClassName);
        }
        if ((packageName = AbstractBuilder.getClassAnnotation(eObject.eClass(), ANNOTATION_URI, "javaPackage", null)) == null) {
            packageName = AbstractBuilder.getAnnotation((EModelElement)eObject.eClass().getEPackage(), ANNOTATION_URI, "javaPackage", null);
        }
        className = String.valueOf(packageName != null ? String.valueOf(packageName) + "." : "") + (className.indexOf(46) < 0 ? String.valueOf(Character.toUpperCase(className.charAt(0))) + className.substring(1) : className);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (warn) {
                System.err.println("Exception when getting toolkit class for " + this + ": " + e);
            }
            return null;
        }
    }

    protected Object create(EObject control) {
        boolean genericBinder = this.getClass() == AbstractBinder.class;
        Class<?> toolkitClass = this.getToolkitClass(control, !genericBinder);
        if (toolkitClass == null && genericBinder) {
            return control;
        }
        try {
            return this.createForClass(toolkitClass);
        }
        catch (Exception e) {
            System.err.println("Exception when creating toolkit object of " + toolkitClass + ": " + e);
            return null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected Object createForClass(Class<?> swtClass) throws Exception {
        e = null;
        try {
            return swtClass.newInstance();
        }
        catch (InstantiationException ie1) {
            e = ie1;
            constructors = swtClass.getConstructors();
            i = 0;
            ** while (i < constructors.length)
        }
lbl-1000:
        // 1 sources

        {
            try {
                return this.createWithConstructor(constructors[i]);
            }
            catch (InstantiationException ie2) {
                e = ie2;
                ++i;
            }
            continue;
        }
lbl15:
        // 1 sources

        throw e;
    }

    protected Object createWithConstructor(Constructor<?> constructor) throws Exception {
        Class<?>[] types = constructor.getParameterTypes();
        Object[] arguments = new Object[types.length];
        int i = 0;
        while (i < types.length) {
            arguments[i] = this.getDefaultFor(types[i]);
            ++i;
        }
        return constructor.newInstance(arguments);
    }

    protected Object getDefaultFor(Class<?> c) {
        if (Number.class.isAssignableFrom(c)) {
            return 0;
        }
        if (c == Integer.TYPE || c == Short.TYPE || c == Byte.TYPE) {
            return 0;
        }
        if (c == Double.TYPE || c == Float.TYPE) {
            return 0.0;
        }
        if (c == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        if (c == Boolean.TYPE) {
            return false;
        }
        return null;
    }

    protected void invalidateFeature(EObject eObject, EStructuralFeature feature, Object object, boolean isEvent) {
        if (isEvent) {
            Object value = this.getPropertyValue(feature, eObject.eClass(), object, this.UNDEFINED);
            if (value != this.UNDEFINED) {
                this.setFeatureValue(eObject, feature, value);
            }
        } else {
            this.updateInvalidFeature(eObject, feature, object);
        }
    }

    protected void updateInvalidFeature(EObject eObject, EStructuralFeature feature, Object object) {
        this.update(eObject, feature, object, false);
    }

    protected Object getPropertyValue(EStructuralFeature feature, EClass realClass, Object object, Object def) {
        String access = this.getAccessMethod(feature, realClass);
        Object value = def;
        if (access != null) {
            String name = this.getRealName(feature);
            try {
                int pos;
                if ("field".equals(access)) {
                    value = this.context.getFieldProperty(object, name);
                } else if ("property".equals(access)) {
                    value = this.context.getGetterProperty(object, name);
                } else if (!"binder".equals(access) && access != null && (pos = access.indexOf(32)) >= 0) {
                    String getter = access.substring(0, pos).trim();
                    value = this.context.getMethodProperty(object, getter, null);
                }
            }
            catch (Exception exception) {}
        }
        return value;
    }

    protected void setFeatureValue(EObject eObject, EStructuralFeature feature, Object value) {
        Class type = feature.getEType().getInstanceClass();
        if (feature.isMany()) {
            ArrayList values = Collections.EMPTY_LIST;
            if (value instanceof List) {
                values = (List)value;
            } else if (value instanceof Collection) {
                values = new ArrayList((Collection)value);
            } else if (value.getClass().isArray()) {
                values = new ArrayList();
                int length = Array.getLength(value);
                int i = 0;
                while (i < length) {
                    Object o = Array.get(value, i);
                    Object o2 = this.context.adapt(o, type);
                    values.add(o2);
                    ++i;
                }
            }
            EList eList = (EList)eObject.eGet(feature);
            ECollections.setEList((EList)eList, values);
        } else {
            Object value2 = this.context.adapt(value, type);
            eObject.eSet(feature, value2);
        }
    }

    protected void notifyChanged(EObject eObject, EStructuralFeature feature, Notification notification) {
        Object object = this.context.getObject(eObject, Object.class);
        boolean isEvent = "event".equals(this.getAccessMethod(feature, eObject.eClass()));
        this.invalidateFeature(eObject, feature, object, isEvent);
        String invalidates = AbstractBuilder.getFeatureAnnotation(feature, null, ANNOTATION_URI, "invalidates", null);
        StringTokenizer tokens = SwtBuilder.getSeparatedTokens(invalidates);
        while (tokens.hasMoreTokens()) {
            String featureName = tokens.nextToken();
            if (Character.isUpperCase(featureName.charAt(0))) {
                this.context.invalidateFeature(eObject, featureName);
                continue;
            }
            EStructuralFeature invalidatedFeature = eObject.eClass().getEStructuralFeature(featureName);
            if (invalidatedFeature == null) continue;
            this.invalidateFeature(eObject, invalidatedFeature, object, isEvent);
        }
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNotifier() instanceof EObject && notification.getFeature() instanceof EStructuralFeature) {
            this.notifyChanged((EObject)notification.getNotifier(), (EStructuralFeature)notification.getFeature(), notification);
        }
    }

    @Override
    public boolean validateFeature(EObject eObject, Object object, String featureName, IBinderContext context) {
        if ("Object".equals(featureName)) {
            context.dispose(eObject);
            context.update(eObject);
            return true;
        }
        return false;
    }

    @Override
    public void updateStyle(EObject eObject, Object object, IBinderContext context) {
    }
}

