/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PInterpolatingActivity;
import org.eclipse.swt.graphics.Color;

public class PColorActivity
extends PInterpolatingActivity {
    private Color source;
    private Color destination;
    private Target target;

    public PColorActivity(long duration, long stepRate, Target aTarget) {
        this(duration, stepRate, aTarget, null);
    }

    public PColorActivity(long duration, long stepRate, Target aTarget, Color aDestination) {
        this(duration, stepRate, 1, 1, aTarget, aDestination);
    }

    public PColorActivity(long duration, long stepRate, int loopCount, int mode, Target aTarget, Color aDestination) {
        super(duration, stepRate, loopCount, mode);
        this.target = aTarget;
        this.destination = aDestination;
    }

    protected boolean isAnimation() {
        return true;
    }

    public Color getDestinationColor() {
        return this.destination;
    }

    public void setDestinationColor(Color newDestination) {
        this.destination = newDestination;
    }

    protected void activityStarted() {
        if (this.getFirstLoop()) {
            this.source = this.target.getColor();
        }
        super.activityStarted();
    }

    public void setRelativeTargetValue(float zeroToOne) {
        super.setRelativeTargetValue(zeroToOne);
        float red = (float)this.source.getRed() + zeroToOne * (float)(this.destination.getRed() - this.source.getRed());
        float green = (float)this.source.getGreen() + zeroToOne * (float)(this.destination.getGreen() - this.source.getGreen());
        float blue = (float)this.source.getBlue() + zeroToOne * (float)(this.destination.getBlue() - this.source.getBlue());
        this.target.setColor(new Color(this.source.getDevice(), (int)red / 255, (int)green / 255, (int)blue / 255));
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("source=" + (this.source == null ? "null" : this.source.toString()));
        result.append(",destination=" + (this.destination == null ? "null" : this.destination.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }

    public static interface Target {
        public void setColor(Color var1);

        public Color getColor();
    }
}

