/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.internal.gadgets.opensocial.browserfunctions;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.widgets.Display;

public final class MakeXmlHttpRequest
extends BrowserFunction {
    public MakeXmlHttpRequest(Browser browser) {
        super(browser, "e4_makeXmlHttpRequest");
    }

    public Object function(Object[] arguments) {
        try {
            String url = (String)arguments[0];
            String callback = (String)arguments[1];
            String method = (String)arguments[2];
            String contentType = (String)arguments[3];
            String headers = (String)arguments[4];
            String postData = (String)arguments[5];
            HttpClient httpClient = new HttpClient();
            HttpMethod httpMethod = this.createMethod(url, method);
            if (!"".equals(headers)) {
                this.addHeaders(httpMethod, headers);
            }
            if (postData != null) {
                ((PostMethod)httpMethod).setRequestEntity((RequestEntity)new StringRequestEntity(postData, "text/xml", "utf-8"));
            }
            int status = httpClient.executeMethod(httpMethod);
            String responseBodyAsString = this.retrieveResponseBody(httpMethod);
            responseBodyAsString = responseBodyAsString.replaceAll("'", " ");
            String responseScript = "\n";
            responseScript = String.valueOf(responseScript) + "var response = new Object();\n";
            responseScript = String.valueOf(responseScript) + "response.rc=" + status + ";\n";
            responseScript = String.valueOf(responseScript) + "response.text='" + responseBodyAsString + "';\n";
            if ("DOM".equals(contentType)) {
                responseScript = this.createDOMResponseData(responseScript);
            } else if ("JSON".equals(contentType)) {
                responseScript = this.createJSONResponseData(responseBodyAsString, responseScript);
            } else if ("TEXT".equals(contentType)) {
                responseScript = this.createTEXTReponseData(responseScript);
            } else if ("FEED".equals(contentType)) {
                responseScript = this.createFEEDResponseData(responseScript);
            }
            final String script = responseScript = String.valueOf(responseScript) + "var callback = " + callback + ";\n" + "callback(response);\n";
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    MakeXmlHttpRequest.this.getBrowser().execute(script);
                }
            });
            return status;
        }
        catch (HttpException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return 500;
    }

    protected String createFEEDResponseData(String responseScript) {
        responseScript = String.valueOf(responseScript) + "response.data='Not implemented';";
        return responseScript;
    }

    protected String createTEXTReponseData(String responseScript) {
        responseScript = String.valueOf(responseScript) + "response.data=response.text;";
        return responseScript;
    }

    protected String createJSONResponseData(String responseBodyAsString, String responseScript) {
        responseScript = String.valueOf(responseScript) + "response.data=eval('(" + responseBodyAsString + ")')\n";
        return responseScript;
    }

    protected String createDOMResponseData(String responseScript) {
        responseScript = String.valueOf(responseScript) + "var xmlDoc;\n";
        responseScript = String.valueOf(responseScript) + "if (window.DOMParser){\nparser=new DOMParser();\nxmlDoc=parser.parseFromString(response.text,'text/xml');\n} else {\n// Internet Explorer\nxmlDoc=new ActiveXObject('Microsoft.XMLDOM');\nxmlDoc.async='false';\nxmlDoc.loadXML(response.text);\n}\n";
        responseScript = String.valueOf(responseScript) + "response.data=xmlDoc;\n";
        return responseScript;
    }

    protected String retrieveResponseBody(HttpMethod httpMethod) throws IOException, UnsupportedEncodingException {
        String responseBodyAsString = "";
        InputStream bodyAsStream = httpMethod.getResponseBodyAsStream();
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(bodyAsStream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        finally {
            bodyAsStream.close();
        }
        responseBodyAsString = sb.toString();
        return responseBodyAsString;
    }

    private void addHeaders(HttpMethod httpMethod, String headers) {
        String[] splittedHeader;
        String[] stringArray = splittedHeader = headers.split("\n");
        int n = splittedHeader.length;
        int n2 = 0;
        while (n2 < n) {
            String header = stringArray[n2];
            String[] headerNameAndValue = header.split("#");
            String name = headerNameAndValue[0];
            String value = headerNameAndValue[1];
            if (!"undefined".equals(value)) {
                httpMethod.addRequestHeader(name, value);
            }
            ++n2;
        }
    }

    protected HttpMethod createMethod(String url, String method) {
        if ("GET".equals(method)) {
            return new GetMethod(url);
        }
        return new PostMethod(url);
    }
}

