/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.SelectorList;

public class SelectorTest
extends TestCase {
    private CSSEngine engine;

    protected void setUp() throws Exception {
        this.engine = ParserTestUtil.createEngine();
    }

    public void testSimpleSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors("Type1");
        SelectorTest.assertNotNull((Object)list);
        SelectorTest.assertEquals((int)1, (int)list.getLength());
        SelectorTest.assertEquals((String)"Type1", (String)list.item(0).toString());
    }

    public void testMultipleSelectors() throws Exception {
        SelectorList list = this.engine.parseSelectors("Type1, Type2");
        SelectorTest.assertNotNull((Object)list);
        SelectorTest.assertEquals((int)2, (int)list.getLength());
        SelectorTest.assertEquals((String)"Type1", (String)list.item(0).toString());
        SelectorTest.assertEquals((String)"Type2", (String)list.item(1).toString());
    }

    public void testClassSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors(".Class1");
        SelectorTest.assertNotNull((Object)list);
        SelectorTest.assertEquals((int)1, (int)list.getLength());
        SelectorTest.assertEquals((String)"*[class=\"Class1\"]", (String)list.item(0).toString());
    }

    public void testAttributeSelector() throws Exception {
        SelectorList list = this.engine.parseSelectors("*[class='Class1']");
        SelectorTest.assertNotNull((Object)list);
        SelectorTest.assertEquals((int)1, (int)list.getLength());
        SelectorTest.assertEquals((String)"*[class=\"Class1\"]", (String)list.item(0).toString());
    }

    public void testErrorAttributeSelector() throws IOException {
        try {
            this.engine.parseSelectors("*[class='Class1'");
            SelectorTest.fail((String)"Parser should have errored on missing bracket");
        }
        catch (CSSParseException cSSParseException) {}
    }
}

