/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.tests.css.core.parser;

import junit.framework.TestCase;
import org.eclipse.e4.ui.tests.css.core.util.ParserTestUtil;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.RGBColor;

public class StyleRuleTest
extends TestCase {
    public void testSimpleStyleRule() throws Exception {
        String css = "Label { color: #FF0000 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        StyleRuleTest.assertNotNull((Object)styleSheet);
        CSSRuleList rules = styleSheet.getCssRules();
        StyleRuleTest.assertEquals((int)1, (int)rules.getLength());
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
    }

    public void testHexColor() throws Exception {
        String css = "Label { color: #FF0220 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("color");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        RGBColor colorValue = ((CSSPrimitiveValue)value).getRGBColorValue();
        StyleRuleTest.assertEquals((float)255.0f, (float)colorValue.getRed().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)2.0f, (float)colorValue.getGreen().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)32.0f, (float)colorValue.getBlue().getFloatValue((short)1), (float)0.0f);
    }

    public void testNamedColor() throws Exception {
        String css = "Label { color: green }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("color");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        StyleRuleTest.assertEquals((String)"green", (String)colorString);
    }

    public void testFont() throws Exception {
        String css = "Label { font: Verdana }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        StyleRuleTest.assertEquals((String)"Verdana", (String)colorString);
    }

    public void testTestFontItalic() throws Exception {
        String css = "Label { font: Arial 12px; font-style: italic }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font-style");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        StyleRuleTest.assertEquals((String)"italic", (String)colorString);
    }

    public void testTestFontBold() throws Exception {
        String css = "Label { font: Arial 12px; font-style: bold }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("font-style");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        StyleRuleTest.assertEquals((String)"bold", (String)colorString);
    }

    public void testBackgroundNameColor() throws Exception {
        String css = "Label { background-color: green }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("background-color");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        String colorString = ((CSSPrimitiveValue)value).getStringValue();
        StyleRuleTest.assertEquals((String)"green", (String)colorString);
    }

    public void testBackgroundHexColor() throws Exception {
        String css = "Label { background-color: #FF0220 }";
        CSSStyleSheet styleSheet = ParserTestUtil.parseCss(css);
        CSSRuleList rules = styleSheet.getCssRules();
        CSSRule rule = rules.item(0);
        StyleRuleTest.assertEquals((short)1, (short)rule.getType());
        CSSStyleDeclaration style = ((CSSStyleRule)rule).getStyle();
        CSSValue value = style.getPropertyCSSValue("background-color");
        StyleRuleTest.assertTrue((boolean)(value instanceof CSSPrimitiveValue));
        RGBColor colorValue = ((CSSPrimitiveValue)value).getRGBColorValue();
        StyleRuleTest.assertEquals((float)255.0f, (float)colorValue.getRed().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)2.0f, (float)colorValue.getGreen().getFloatValue((short)1), (float)0.0f);
        StyleRuleTest.assertEquals((float)32.0f, (float)colorValue.getBlue().getFloatValue((short)1), (float)0.0f);
    }
}

