/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.policies.layout.form;

import java.util.ArrayList;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.Draw2dTools;
import org.eclipse.e4.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.e4.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.parts.ShellEditPart;
import org.eclipse.e4.xwt.tools.ui.designer.policies.layout.form.FormLayoutData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Widget;

public class FormLayoutHelper {
    private CompositeEditPart compositeEp;

    public FormLayoutHelper(CompositeEditPart compositeEditPart) {
        this.compositeEp = compositeEditPart;
    }

    public org.eclipse.draw2d.geometry.Rectangle getClientArea() {
        if (this.compositeEp instanceof ShellEditPart) {
            return ((ShellEditPart)this.compositeEp).getFigure().getBounds();
        }
        if (this.compositeEp != null && this.compositeEp.getVisualInfo() != null) {
            return this.compositeEp.getVisualInfo().getClientArea();
        }
        return new org.eclipse.draw2d.geometry.Rectangle();
    }

    private Composite getParent() {
        if (this.compositeEp != null) {
            return (Composite)this.compositeEp.getWidget();
        }
        return null;
    }

    public FormLayoutData computeData(org.eclipse.draw2d.geometry.Rectangle bounds, Control control) {
        if (bounds.isEmpty()) {
            return null;
        }
        Composite parent = this.getParent();
        if (parent == null) {
            return null;
        }
        org.eclipse.draw2d.geometry.Rectangle clientArea = this.getClientArea();
        if (!clientArea.intersects(bounds)) {
            return null;
        }
        FormData formData = new FormData();
        if (!clientArea.isEmpty()) {
            this.computeVerticalAttachment(formData, clientArea, bounds, control);
            this.computeHorizontalAttachment(formData, clientArea, bounds, control);
        }
        return new FormLayoutData(formData, bounds);
    }

    private void computeHorizontalAttachment(FormData formData, org.eclipse.draw2d.geometry.Rectangle clientArea, org.eclipse.draw2d.geometry.Rectangle bounds, Control control) {
        int marginLeft = bounds.x;
        int marginRight = clientArea.width - bounds.right();
        Composite parent = this.getParent();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                int offset;
                org.eclipse.draw2d.geometry.Rectangle r;
                Control child;
                block23: {
                    block22: {
                        child = controlArray[n2];
                        r = this.getBounds(child);
                        if (r.equals((Object)bounds) || child == control) break block21;
                        if (r.y != bounds.y) break block22;
                        formData.top = new FormAttachment(child, 0, 128);
                        formData.bottom = null;
                        break block23;
                    }
                    if (r.bottom() != bounds.bottom()) break block21;
                    formData.bottom = new FormAttachment(child, 0, 1024);
                    formData.top = null;
                }
                if (bounds.right() > r.right()) {
                    offset = bounds.right() - r.right() - bounds.width;
                    if (offset < marginRight) {
                        formData.left = new FormAttachment(child, offset);
                    } else {
                        formData.right = new FormAttachment(100, -marginRight);
                    }
                } else {
                    offset = r.right() + bounds.width - bounds.right();
                    if (offset < marginLeft) {
                        formData.right = new FormAttachment(child, offset);
                    } else {
                        formData.left = new FormAttachment(0, marginLeft);
                    }
                }
            }
            ++n2;
        }
        if (formData.left != null || formData.right != null) {
            return;
        }
        Control nearest = this.getHorizontalNearest(clientArea, bounds, control);
        if (nearest != null) {
            int distance;
            org.eclipse.draw2d.geometry.Rectangle r = this.getBounds(nearest);
            if (bounds.right() > r.right()) {
                distance = bounds.right() - r.right() - bounds.width;
                if (distance < marginRight) {
                    formData.left = new FormAttachment(nearest, distance);
                } else {
                    formData.right = new FormAttachment(100, -marginRight);
                }
            } else {
                distance = r.right() - bounds.right() - r.width;
                if (distance < marginLeft) {
                    formData.right = new FormAttachment(nearest, distance);
                } else {
                    formData.left = new FormAttachment(0, marginLeft);
                }
            }
        } else if (marginLeft < marginRight) {
            formData.left = new FormAttachment(0, marginLeft);
        } else {
            formData.right = new FormAttachment(100, -marginRight);
        }
    }

    private void computeVerticalAttachment(FormData formData, org.eclipse.draw2d.geometry.Rectangle clientArea, org.eclipse.draw2d.geometry.Rectangle bounds, Control control) {
        int marginTop = bounds.y;
        int marginBottom = clientArea.height - bounds.bottom();
        Composite parent = this.getParent();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            block21: {
                org.eclipse.draw2d.geometry.Rectangle r;
                Control child;
                block23: {
                    block22: {
                        child = controlArray[n2];
                        r = this.getBounds(child);
                        if (r.equals((Object)bounds) || child == control) break block21;
                        if (r.x != bounds.x) break block22;
                        formData.left = new FormAttachment(child, 0, 16384);
                        formData.right = null;
                        break block23;
                    }
                    if (r.right() != bounds.right()) break block21;
                    formData.right = new FormAttachment(child, 0, 131072);
                    formData.left = null;
                }
                if (bounds.bottom() > r.bottom()) {
                    int topOffset = bounds.bottom() - r.bottom() - bounds.height;
                    if (topOffset < marginBottom) {
                        formData.top = new FormAttachment(child, topOffset);
                    } else {
                        formData.bottom = new FormAttachment(100, -marginBottom);
                    }
                } else {
                    int bottomOffset = bounds.bottom() - r.bottom() + r.height;
                    if (bottomOffset < marginTop) {
                        formData.bottom = new FormAttachment(child, bottomOffset);
                    } else {
                        formData.top = new FormAttachment(0, marginTop);
                    }
                }
                return;
            }
            ++n2;
        }
        if (formData.top != null || formData.bottom != null) {
            return;
        }
        Control nearest = this.getVerticalNearest(clientArea, bounds, control);
        if (nearest != null) {
            int distance;
            org.eclipse.draw2d.geometry.Rectangle r = this.getBounds(nearest);
            if (bounds.bottom() > r.bottom()) {
                distance = bounds.bottom() - r.bottom() - bounds.height;
                if (distance < marginBottom) {
                    formData.top = new FormAttachment(nearest, distance);
                } else {
                    formData.bottom = new FormAttachment(100, -marginBottom);
                }
            } else {
                distance = r.bottom() - bounds.bottom() - r.height;
                if (distance < marginTop) {
                    formData.bottom = new FormAttachment(nearest, distance);
                } else {
                    formData.top = new FormAttachment(0, marginTop);
                }
            }
        } else if (marginTop < marginBottom) {
            formData.top = new FormAttachment(0, marginTop);
        } else {
            formData.bottom = new FormAttachment(100, -marginBottom);
        }
    }

    public Control getVerticalNearest(org.eclipse.draw2d.geometry.Rectangle clientArea, org.eclipse.draw2d.geometry.Rectangle bounds, Control control) {
        Control nearest = null;
        int distance = 0;
        Composite parent = this.getParent();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            org.eclipse.draw2d.geometry.Rectangle r = this.getBounds(child);
            if (bounds.y >= r.bottom() && !r.equals((Object)bounds) && child != control && bounds.right() >= r.x && bounds.x <= r.right()) {
                int dis = 0;
                dis = bounds.bottom() > r.bottom() ? bounds.bottom() - r.bottom() - bounds.height : r.bottom() - bounds.bottom() - r.height;
                if (nearest == null) {
                    nearest = child;
                    distance = dis;
                } else if (dis < distance) {
                    nearest = child;
                    distance = dis;
                }
            }
            ++n2;
        }
        return nearest;
    }

    public Control getHorizontalNearest(org.eclipse.draw2d.geometry.Rectangle clientArea, org.eclipse.draw2d.geometry.Rectangle bounds, Control control) {
        Control nearest = null;
        int distance = 0;
        Composite parent = this.getParent();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            org.eclipse.draw2d.geometry.Rectangle r = this.getBounds(child);
            if (bounds.x >= r.right() && !r.equals((Object)bounds) && child != control && bounds.bottom() >= r.y && bounds.y <= r.bottom()) {
                int dis = 0;
                dis = bounds.right() > r.right() ? bounds.right() - r.right() - bounds.width : r.right() - bounds.right() - r.width;
                if (nearest == null) {
                    nearest = child;
                    distance = dis;
                } else if (dis < distance) {
                    nearest = child;
                    distance = dis;
                }
            }
            ++n2;
        }
        return nearest;
    }

    public org.eclipse.draw2d.geometry.Rectangle getBounds(Control control) {
        org.eclipse.draw2d.geometry.Rectangle r = Draw2dTools.toDraw2d((Rectangle)SWTTools.getBounds((Widget)control));
        Point offset = SWTTools.getOffset((Scrollable)this.getParent());
        return r.translate(-offset.x, -offset.y);
    }

    public static Control[] getDependencies(Control control) {
        if (control == null || control.isDisposed()) {
            return new Control[0];
        }
        ArrayList<Control> dependencies = new ArrayList<Control>();
        Composite parent = control.getParent();
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object layoutData;
            Control child = controlArray[n2];
            if (child != control && child.getLayoutData() != null && (layoutData = child.getLayoutData()) != null && layoutData instanceof FormData && FormLayoutHelper.isDepend((FormData)layoutData, control)) {
                dependencies.add(child);
            }
            ++n2;
        }
        return dependencies.toArray(new Control[dependencies.size()]);
    }

    private static boolean isDepend(FormData formData, Control control) {
        if (formData == null || control == null) {
            return false;
        }
        if (formData.left != null && control == formData.left.control) {
            return true;
        }
        if (formData.top != null && control == formData.top.control) {
            return true;
        }
        if (formData.right != null && control == formData.right.control) {
            return true;
        }
        return formData.bottom != null && control == formData.bottom.control;
    }
}

