/*******************************************************************************
 * Copyright (c) 2010 SAP AG, Walldorf.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAP AG - initial API and implementation
 *******************************************************************************/
package org.eclipse.platform.discovery.runtime.internal;

import org.eclipse.platform.discovery.runtime.internal.impl.SearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.impl.XpParsersFactory;
import org.eclipse.platform.discovery.runtime.internal.search.activation.SearchProviderActivationConfigDummy;

public class SearchProviderConfigurationFactory
{
	private static ISearchProviderConfiguration config;

	public static ISearchProviderConfiguration getDefault()
	{
		if (config == null)
		{
			config = createConfig();
		}

		return config;
	}

	private static ISearchProviderConfiguration createConfig()
	{
		final XpParsersFactory parsersFactory = new XpParsersFactory();
		return new SearchProviderConfiguration(parsersFactory, new SearchProviderActivationConfigDummy(parsersFactory.createSearchProviderParser()), new SubdestinationsActivationConfig(parsersFactory
										.createSubdestinationsParser()));
	}
}
