/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils;

import java.awt.AWTException;
import java.awt.Robot;
import org.eclipse.jface.util.Geometry;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.utils.LocationUtils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.results.VoidResult;
import org.eclipse.swtbot.swt.finder.utils.SWTUtils;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;

public class DndUtil {
    private static final int DRAG_THRESHOLD = "gtk".equals(SWT.getPlatform()) ? 16 : 10;
    private static final int DRAG_DELAY = 400;
    private Display display;

    public DndUtil(Display display) {
        this.display = display;
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target) {
        this.dragAndDrop(source, DndUtil.on(target));
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, AbstractSWTBot<? extends Widget> target, Point locationOnTarget) {
        Rectangle targetRectangle = DndUtil.absoluteLocation(target);
        Point dropTarget = new Point(targetRectangle.x + locationOnTarget.x, targetRectangle.y + locationOnTarget.y);
        this.dragAndDrop(source, dropTarget);
    }

    public void dragAndDrop(AbstractSWTBot<? extends Widget> source, Point target) {
        Rectangle sourceLocation = DndUtil.absoluteLocation(source);
        Point slightOffset = Geometry.add((Point)Geometry.getLocation((Rectangle)sourceLocation), (Point)new Point(DRAG_THRESHOLD, DRAG_THRESHOLD));
        this.doDragAndDrop(Geometry.min((Point)Geometry.centerPoint((Rectangle)sourceLocation), (Point)slightOffset), target);
    }

    protected void dragAndDrop(Point source, AbstractSWTBot<? extends Widget> target) {
        this.doDragAndDrop(source, DndUtil.on(target));
    }

    private void doDragAndDrop(final Point source, final Point dest) {
        try {
            final Robot awtRobot = new Robot();
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(source.x, source.y);
                    awtRobot.mousePress(16);
                    awtRobot.mouseMove(source.x + DRAG_THRESHOLD, source.y);
                }
            });
            SWTUtils.sleep((long)400L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseMove(dest.x + DRAG_THRESHOLD, dest.y);
                    awtRobot.mouseMove(dest.x, dest.y);
                }
            });
            SWTUtils.sleep((long)400L);
            this.syncExec(new VoidResult(){

                public void run() {
                    awtRobot.mouseRelease(16);
                }
            });
            SWTUtils.sleep((long)400L);
        }
        catch (AWTException e) {
            throw new RuntimeException(e);
        }
    }

    private void syncExec(VoidResult toExecute) {
        UIThreadRunnable.syncExec((Display)this.display, (VoidResult)toExecute);
    }

    public static <T extends Widget> Point before(AbstractSWTBot<T> targetItem) {
        return DndUtil.pointOnUpperBorder(DndUtil.absoluteLocation(targetItem));
    }

    public static <T extends Widget> Point on(AbstractSWTBot<T> targetItem) {
        return Geometry.centerPoint((Rectangle)DndUtil.absoluteLocation(targetItem));
    }

    public static <T extends Widget> Point after(AbstractSWTBot<T> targetItem) {
        return DndUtil.pointOnLowerBorder(DndUtil.absoluteLocation(targetItem));
    }

    private static Point pointOnLowerBorder(Rectangle rect) {
        return new Point(Geometry.centerPoint((Rectangle)rect).x, rect.y + rect.height - 1);
    }

    private static Point pointOnUpperBorder(Rectangle rect) {
        return new Point(Geometry.centerPoint((Rectangle)rect).x, rect.y + 1);
    }

    private static <T extends Widget> Rectangle absoluteLocation(AbstractSWTBot<T> item) {
        return LocationUtils.absoluteLocation(item);
    }
}

