/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.platform.discovery.core.api.ISearchContext;
import org.eclipse.platform.discovery.core.api.SearchEvent;
import org.eclipse.platform.discovery.core.internal.ISearchConsoleView;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleController;
import org.eclipse.platform.discovery.core.internal.console.ISearchConsoleControllerOutputView;
import org.eclipse.platform.discovery.runtime.api.GroupingHierarchy;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.api.ISearchParameters;
import org.eclipse.platform.discovery.runtime.api.ISearchSubdestination;
import org.eclipse.platform.discovery.runtime.api.SearchFailedException;
import org.eclipse.platform.discovery.runtime.api.SearchFailedForKnownReasonException;
import org.eclipse.platform.discovery.runtime.internal.DestinationCategoryNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.ProviderNotFoundException;
import org.eclipse.platform.discovery.runtime.internal.SearchProviderConfigurationFactory;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.ISearchProviderDescription;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;
import org.eclipse.platform.discovery.ui.api.IMasterDiscoveryView;
import org.eclipse.platform.discovery.ui.api.ISearchConsoleCustomization;
import org.eclipse.platform.discovery.ui.api.ISearchParametersUI;
import org.eclipse.platform.discovery.ui.api.IViewUiContext;
import org.eclipse.platform.discovery.ui.api.impl.DefaultSessionIds;
import org.eclipse.platform.discovery.ui.internal.SearchParametersUI;
import org.eclipse.platform.discovery.ui.internal.SlidingComposite;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.AdvancedSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.search.advancedparams.IAdvancedSearchParamsDisplayer;
import org.eclipse.platform.discovery.ui.internal.util.ControlBackgroundImageManager;
import org.eclipse.platform.discovery.ui.internal.view.ICustomizableView;
import org.eclipse.platform.discovery.ui.internal.view.ISearchProviderSelector;
import org.eclipse.platform.discovery.ui.internal.view.SearchProviderSelector;
import org.eclipse.platform.discovery.ui.internal.view.impl.AbstractDiscoveryView;
import org.eclipse.platform.discovery.ui.internal.view.impl.ITabbedSessionDisplayer;
import org.eclipse.platform.discovery.ui.internal.view.impl.SearchParameters;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.ContributedUIFactory;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.TabbedSessionDisplayer;
import org.eclipse.platform.discovery.util.internal.logging.ILogger;
import org.eclipse.platform.discovery.util.internal.logging.Logger;
import org.eclipse.platform.discovery.util.internal.property.IPropertyAttributeListener;
import org.eclipse.platform.discovery.util.internal.property.Property;
import org.eclipse.platform.discovery.util.internal.property.PropertyAttributeChangedEvent;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class SearchConsoleView
extends AbstractDiscoveryView<ISearchConsoleControllerOutputView, ISearchConsoleController>
implements ISearchConsoleView,
ICustomizableView,
IMasterDiscoveryView,
ISearchConsoleControllerOutputView {
    public static final int UI_IN_CONTROL_SPACING = 5;
    private ISearchProviderSelector searchProviderSelector;
    private IAdvancedSearchParamsDisplayer advancedSearchParamsDisplayer;
    private ITabbedSessionDisplayer<ISearchContext> sdm;
    private IProgressMonitor viewProgressMonitor;
    private String defaultSessionId;
    private ISearchParametersUI searchParametersUI;
    private Button searchButton;
    private Hyperlink manageConfigurationHyperlink;
    private SlidingComposite slidingComposite;
    private Composite fixedSearchParamComposite;
    private Composite advancedSearchParamsComposite;
    private Composite bottomComposite;
    private Composite upperComposite;
    private final Cursor hyperlinkCursor;
    private final Property<Point> upperCompositeSizeProperty = new Property();
    private final Property<SlidingComposite.ORIENTATION> currentOrientation;
    private ControlBackgroundImageManager upperCompositeGradientManager;
    private ISearchConsoleController controller;

    public SearchConsoleView() {
        this.upperCompositeSizeProperty.set((Object)new Point(0, 0));
        this.hyperlinkCursor = new Cursor((Device)PlatformUI.getWorkbench().getDisplay(), 21);
        this.currentOrientation = new Property();
        this.currentOrientation.set((Object)SlidingComposite.ORIENTATION.VERTICAL);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.slidingComposite = new SlidingComposite(parent, this.formToolkit){

            @Override
            protected void configureUpperComposite(Composite upperComposite) {
                SearchConsoleView.this.configureUpperComposite(upperComposite, this.getFormToolkit());
            }

            @Override
            protected void configureBottomComposite(Composite bottomComposite) {
                SearchConsoleView.this.bottomComposite = bottomComposite;
                SearchConsoleView.this.sdm = SearchConsoleView.this.createSessionsDisplayer();
                bottomComposite.setLayout((Layout)new FillLayout());
            }

            @Override
            protected void onOrientationChange(SlidingComposite.ORIENTATION newOrientation) {
                SearchConsoleView.this.currentOrientation.set((Object)newOrientation);
            }
        };
        this.viewProgressMonitor = this.slidingComposite.getProgressMonitor();
        this.getProgressMonitor().beginTask(DiscoveryUIMessages.INITIALIZATION_IN_PROGRESS_TASK, -1);
        this.upperCompositeSizeProperty.registerValueListener((IPropertyAttributeListener)new IPropertyAttributeListener<Point>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Point> event) {
                SearchConsoleView.this.slidingComposite.upperCompositeSizeChanged(event);
            }
        }, false);
        this.fixedSearchParamComposite.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (SearchConsoleView.this.searchButton.isEnabled() && e.detail == 4) {
                    SearchConsoleView.this.search();
                }
            }
        });
        this.advancedSearchParamsDisplayer.registerSizePropertyChangeListener(new IPropertyAttributeListener<Point>(){

            public void attributeChanged(PropertyAttributeChangedEvent<Point> event) {
                Point newSize = SearchConsoleView.this.computeUpperCompositeSize(SearchConsoleView.this.fixedSearchParamComposite.getSize(), (Point)event.getNewAttribute(), SearchConsoleView.this.searchButton.getSize(), (SlidingComposite.ORIENTATION)((Object)SearchConsoleView.this.currentOrientation.get()));
                SearchConsoleView.this.upperCompositeSizeProperty.set((Object)newSize);
            }
        }, false);
        this.currentOrientation.registerValueListener((IPropertyAttributeListener)new OrientationChangedListener(), true);
        parent.layout(true, true);
        this.upperCompositeSizeProperty.set((Object)this.upperComposite.computeSize(-1, -1));
    }

    protected ITabbedSessionDisplayer<ISearchContext> createSessionsDisplayer() {
        TabbedSessionDisplayer<ISearchContext> sd = new TabbedSessionDisplayer<ISearchContext>(this.bottomComposite, new ContributedUIFactory(this), 0x800002);
        sd.getControl().setSelectionBackground(new Color[]{this.getGradientStart(), this.getGradientEnd()}, new int[]{80}, true);
        return sd;
    }

    protected ISearchProviderConfiguration getSearchProviderConfiguration() {
        return SearchProviderConfigurationFactory.getDefault();
    }

    public void setFocus() {
        if (this.bottomComposite != null) {
            this.bottomComposite.setFocus();
        }
    }

    public void showDestinationsCategories(List<IDestinationCategoryDescription> categories) {
        this.searchProviderSelector.setDestinations(categories);
    }

    public void showObjectTypes(List<IObjectTypeDescription> objectTypes) {
        this.searchProviderSelector.setObjectTypes(objectTypes);
    }

    public void showResult(ISearchContext searchContext) {
        String sessionId = searchContext.session().getId();
        if (searchContext.session().getId().equals(this.defaultSessionId)) {
            this.sdm.setSessionUnclosable(sessionId);
        }
        this.sdm.display((ISession<ISearchContext>)searchContext.session());
        this.slidingComposite.notifyBottomCompositeContentChanged(DiscoveryUIMessages.SearchConsoleView_SearchFinished, DiscoveryUIMessages.SearchConsoleView_SearchResultsAvailable);
    }

    @Override
    public void registerViewCustomization(IGenericViewCustomization customization) {
        if (!(customization instanceof ISearchConsoleCustomization)) {
            throw new IllegalArgumentException("The view customization must be instance of ISearchConsoleCustomization");
        }
        super.registerViewCustomization(customization);
    }

    private void createHyperLink(final Composite parent, FormToolkit formToolkit) {
        this.manageConfigurationHyperlink = new Hyperlink(parent, 0);
        this.manageConfigurationHyperlink.setText(DiscoveryUIMessages.SearchConsoleView_MANAGED_CONFIGS_LINK);
        this.manageConfigurationHyperlink.setForeground(formToolkit.getHyperlinkGroup().getActiveForeground());
        this.manageConfigurationHyperlink.setUnderlined(true);
        this.manageConfigurationHyperlink.setCursor(this.hyperlinkCursor);
        final LinkedList<String> prefPageIDs = new LinkedList<String>();
        for (IDestinationsProviderDescription provider : this.getSearchProviderConfiguration().getAvailableDestinationProviders()) {
            if (provider.getPreferencePageId() == null) continue;
            prefPageIDs.add(provider.getPreferencePageId());
        }
        this.manageConfigurationHyperlink.addHyperlinkListener(new IHyperlinkListener(){

            public void linkActivated(HyperlinkEvent e) {
                PreferenceDialog pageDialog = PreferencesUtil.createPreferenceDialogOn((Shell)parent.getShell(), null, (String[])prefPageIDs.toArray(new String[prefPageIDs.size()]), null);
                pageDialog.getTreeViewer().expandAll();
                pageDialog.open();
            }

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }
        });
        FormData linkFormData = new FormData();
        linkFormData.top = new FormAttachment(this.searchProviderSelector.getControl(), 5);
        linkFormData.right = new FormAttachment(100, -5);
        this.manageConfigurationHyperlink.setLayoutData((Object)linkFormData);
    }

    private void configureUpperComposite(Composite upComposite, FormToolkit formToolkit) {
        this.upperComposite = upComposite;
        this.upperComposite.setBackgroundMode(1);
        this.upperCompositeGradientManager = this.createGradient((Control)this.upperComposite);
        final int leftLabelsSize = this.getLongestLabelSize(this.getLeftSideLabels());
        this.fixedSearchParamComposite = new Composite(this.upperComposite, 0);
        this.fixedSearchParamComposite.setLayout((Layout)new FormLayout());
        this.fixedSearchParamComposite.setLayoutData((Object)this.createFixedParamsFormData((SlidingComposite.ORIENTATION)((Object)this.currentOrientation.get())));
        ISearchProviderSelector.IConsoleContext selectorContext = new ISearchProviderSelector.IConsoleContext(){

            @Override
            public int secondColumnLeftOffset() {
                return leftLabelsSize;
            }

            @Override
            public ISearchProviderConfiguration searchProviderConfiguration() {
                return SearchConsoleView.this.getSearchProviderConfiguration();
            }

            @Override
            public void notifyComplete(boolean complete) {
                ISearchProviderDescription selectedProvider = SearchConsoleView.this.searchProviderSelector.getSelectedSearchProvider();
                ISearchDestination selectedDestination = SearchConsoleView.this.searchProviderSelector.getSelectedDestination();
                SearchConsoleView.this.searchParametersUI.searchProviderSelected(selectedProvider);
                SearchConsoleView.this.advancedSearchParamsDisplayer.update(SearchConsoleView.this.getSelectedObjectType(), selectedDestination, SearchConsoleView.this.getEnvironment(), SearchConsoleView.this.uiContext());
                SearchConsoleView.this.advancedSearchParamsComposite.setLayoutData((Object)SearchConsoleView.this.createAdvancedOptionsFormData(SearchConsoleView.this.fixedSearchParamComposite, (SlidingComposite.ORIENTATION)((Object)SearchConsoleView.this.currentOrientation.get()), SearchConsoleView.this.advancedSearchParamsDisplayer.isEnabled()));
                if (selectedDestination == null || SearchConsoleView.this.getSelectedActiveSearchProviderDescription() == null) {
                    SearchConsoleView.this.controller.searchDestinationSelected(SearchConsoleView.this.searchProviderSelector.getSelectedObjectType(), null);
                } else {
                    SearchConsoleView.this.controller.searchDestinationSelected(SearchConsoleView.this.searchProviderSelector.getSelectedObjectType(), selectedDestination);
                }
                SearchConsoleView.this.upperComposite.layout(true, true);
            }
        };
        this.searchProviderSelector = new SearchProviderSelector(this.fixedSearchParamComposite, formToolkit, selectorContext);
        ((Composite)this.searchProviderSelector.getControl()).setLayoutData((Object)this.createSearchProviderSelectorLayoutData());
        this.createHyperLink(this.fixedSearchParamComposite, formToolkit);
        this.createSearchParametersUI(this.fixedSearchParamComposite, formToolkit);
        this.advancedSearchParamsComposite = new Composite(this.upperComposite, 0);
        this.adaptAdvancedSearchParamsComposite(this.advancedSearchParamsComposite, this.fixedSearchParamComposite, false);
        this.advancedSearchParamsDisplayer = this.createAdvancedSearchParamsDisplayer(this.advancedSearchParamsComposite, formToolkit);
        this.searchButton = new Button(this.upperComposite, 0x800008);
        this.searchButton.setText(DiscoveryUIMessages.SEARCH_BUTTON_LABEL);
        FormData buttonData = this.createSearchButtonCompositeFormData((SlidingComposite.ORIENTATION)((Object)this.currentOrientation.get()));
        this.searchButton.setLayoutData((Object)buttonData);
        this.searchButton.setEnabled(false);
        this.installSearchButtonListener();
        this.upperComposite.layout();
    }

    private FormData createSearchProviderSelectorLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private void createSearchParametersUI(Composite parent, FormToolkit toolkit) {
        Composite searchParametersUIComposite = new Composite(parent, 0);
        searchParametersUIComposite.setLayoutData((Object)this.createSearchParametersLayoutData());
        this.searchParametersUI = new SearchParametersUI();
        ISearchParametersUI.IConsoleContext context = new ISearchParametersUI.IConsoleContext(){

            @Override
            public IObjectTypeDescription selectedObjectType() {
                return SearchConsoleView.this.getSelectedObjectType();
            }

            @Override
            public ISearchProviderConfiguration searchProviderConfiguration() {
                return SearchConsoleView.this.getSearchProviderConfiguration();
            }

            @Override
            public ISearchProviderDescription searchProvider() {
                return SearchConsoleView.this.getSelectedActiveSearchProviderDescription();
            }

            @Override
            public ISearchDestination searchDestination() {
                return SearchConsoleView.this.getSelectedDestination();
            }

            @Override
            public void notifySubdestinationActivationChange(ISearchSubdestination subDestination, boolean newActivationState) {
                SearchConsoleView.this.getSearchProviderConfiguration().activateSubdestination(SearchConsoleView.this.getSelectedObjectType(), SearchConsoleView.this.getSelectedDestinationCategory(), SearchConsoleView.this.getSelectedActiveSearchProviderDescription(), subDestination, newActivationState);
            }

            @Override
            public void notifyComplete(boolean complete) {
                SearchConsoleView.this.searchButton.setEnabled(complete);
            }

            @Override
            public IDestinationCategoryDescription destinationCategory() {
                return SearchConsoleView.this.getSelectedDestinationCategory();
            }

            @Override
            public int secondColumnLeftOffset() {
                return SearchConsoleView.this.getLongestLabelSize(SearchConsoleView.this.getLeftSideLabels());
            }
        };
        this.searchParametersUI.createUI(searchParametersUIComposite, toolkit, context);
    }

    private FormData createSearchParametersLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.manageConfigurationHyperlink, 5);
        return data;
    }

    private void adjustUpperCompositeLayoutData(SlidingComposite.ORIENTATION orientation) {
        this.fixedSearchParamComposite.setLayoutData((Object)this.createFixedParamsFormData(orientation));
        this.searchButton.setLayoutData((Object)this.createSearchButtonCompositeFormData(orientation));
        this.advancedSearchParamsComposite.setLayoutData((Object)this.createAdvancedOptionsFormData(this.fixedSearchParamComposite, orientation, this.advancedSearchParamsDisplayer.isEnabled()));
    }

    private FormData createFixedParamsFormData(SlidingComposite.ORIENTATION orientation) {
        FormData fixedData = new FormData();
        fixedData.left = new FormAttachment(0, 0);
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            fixedData.right = new FormAttachment(100, 0);
        } else {
            fixedData.width = this.fixedSearchParamComposite.computeSize((int)-1, (int)-1).x;
        }
        return fixedData;
    }

    private FormData createSearchButtonCompositeFormData(SlidingComposite.ORIENTATION orientation) {
        FormData buttonData = new FormData();
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            buttonData.top = new FormAttachment((Control)this.advancedSearchParamsComposite, 5);
            buttonData.right = new FormAttachment(100, -5);
        } else {
            buttonData.top = new FormAttachment((Control)this.fixedSearchParamComposite, 5);
            buttonData.right = new FormAttachment(0, this.fixedSearchParamComposite.computeSize((int)-1, (int)-1).x);
        }
        return buttonData;
    }

    private FormData createAdvancedOptionsFormData(Composite fixedSearchParamComposite, SlidingComposite.ORIENTATION orientation, boolean enabled) {
        FormData fd = new FormData();
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            fd.top = new FormAttachment((Control)fixedSearchParamComposite);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            fd.height = enabled ? -1 : 0;
            fd.width = -1;
        } else {
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment((Control)fixedSearchParamComposite, 5);
            fd.right = new FormAttachment(100, 0);
            fd.width = enabled ? -1 : 0;
            fd.height = -1;
        }
        return fd;
    }

    private Composite adaptAdvancedSearchParamsComposite(Composite advancedSearchParamsComposite, Composite fixedSearchParamComposite, boolean enabled) {
        advancedSearchParamsComposite.setLayout((Layout)new FormLayout());
        FormData fd = this.createAdvancedOptionsFormData(fixedSearchParamComposite, (SlidingComposite.ORIENTATION)((Object)this.currentOrientation.get()), enabled);
        advancedSearchParamsComposite.setLayoutData((Object)fd);
        return advancedSearchParamsComposite;
    }

    private void search() {
        try {
            SearchParameters params = new SearchParameters(this.getSelectedObjectType().getId(), this.getSelectedDestination(), this.searchParametersUI.getKeyword(), this.searchParametersUI.getGroupingHierarchy(), this.activeSubdestinations());
            this.advancedSearchParamsDisplayer.setParams(params);
            SearchEvent searchEvent = new SearchEvent((ISearchParameters)params, DefaultSessionIds.mainSearchSessionId, DiscoveryUIMessages.SEARCH_RESULT_TAB, null);
            this.controller.search(searchEvent);
        }
        catch (ProviderNotFoundException e1) {
            throw new IllegalStateException(e1);
        }
        catch (SearchFailedForKnownReasonException exc) {
            this.getEnvironment().errorHandler().showError(null, exc.getLocalizedMessage());
            this.logger().logDebug(exc.getMessage(), (Throwable)exc);
        }
        catch (SearchFailedException exc) {
            this.getEnvironment().errorHandler().handleException((Exception)((Object)exc));
        }
    }

    private ILogger logger() {
        return Logger.instance();
    }

    private Set<ISearchSubdestination> activeSubdestinations() throws ProviderNotFoundException {
        HashSet<ISearchSubdestination> result = new HashSet<ISearchSubdestination>();
        IObjectTypeDescription objectType = this.getSelectedObjectType();
        IDestinationCategoryDescription category = this.getDestinationCategory(this.getSelectedDestination());
        ISearchProviderDescription searchProvider = this.getSearchProviderConfiguration().getActiveSearchProvider(objectType, category);
        if (searchProvider == null) {
            return Collections.emptySet();
        }
        for (ISearchSubdestination subd : this.getSearchProviderConfiguration().getAvailableSearchSubdestinations(objectType, category, searchProvider)) {
            if (!this.getSearchProviderConfiguration().isSubdestinationActive(subd, objectType, category, searchProvider)) continue;
            result.add(subd);
        }
        return result;
    }

    private ControlBackgroundImageManager createGradient(Control control) {
        final ControlBackgroundImageManager bgImageManager = new ControlBackgroundImageManager(control);
        bgImageManager.setBackgroundGradient(this.getGradientStart(), this.getGradientEnd(), true);
        control.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                bgImageManager.setBackgroundGradient(SearchConsoleView.this.getGradientStart(), SearchConsoleView.this.getGradientEnd(), true);
            }
        });
        return bgImageManager;
    }

    private void installSearchButtonListener() {
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchConsoleView.this.search();
            }
        });
    }

    private IDestinationCategoryDescription getSelectedDestinationCategory() {
        try {
            ISearchDestination selectedDestination = this.getSelectedDestination();
            if (selectedDestination != null) {
                return (IDestinationCategoryDescription)this.getSearchProviderConfiguration().getDestinationCategoriesForDestination(selectedDestination).iterator().next();
            }
            return null;
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    private IObjectTypeDescription getSelectedObjectType() {
        return this.searchProviderSelector.getSelectedObjectType();
    }

    private ISearchDestination getSelectedDestination() {
        return this.searchProviderSelector.getSelectedDestination();
    }

    private ISearchProviderDescription getSelectedActiveSearchProviderDescription() {
        try {
            return this.getSearchProviderConfiguration().getActiveSearchProvider(this.getSelectedObjectType(), this.getSelectedDestinationCategory());
        }
        catch (ProviderNotFoundException providerNotFoundException) {
            return null;
        }
    }

    public void updateDestinationsSelector() {
        this.searchProviderSelector.updateDestinationsUI();
    }

    private int getLongestLabelSize(List<String> labels) {
        int result = 0;
        GC gc = new GC((Drawable)PlatformUI.getWorkbench().getDisplay());
        try {
            for (String l : labels) {
                int extent = gc.textExtent((String)l).x;
                int n = result = extent > result ? extent : result;
            }
        }
        finally {
            gc.dispose();
        }
        return result;
    }

    private List<String> getLeftSideLabels() {
        return Arrays.asList(DiscoveryUIMessages.SEARCH_FOR_LIST_VIEWER_LABEL, DiscoveryUIMessages.SEARCH_IN_LIST_VIEWER_LABEL, DiscoveryUIMessages.SEARCH_KEYWORD_LABEL, DiscoveryUIMessages.GROUP_BY_LABEL);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.hyperlinkCursor.dispose();
        this.upperCompositeGradientManager.disposeResources();
    }

    protected IAdvancedSearchParamsDisplayer createAdvancedSearchParamsDisplayer(Composite parent, FormToolkit formToolkit) {
        AdvancedSearchParamsDisplayer displayer = new AdvancedSearchParamsDisplayer(parent, formToolkit){

            @Override
            protected ISearchProviderConfiguration searchProviderConfiguration() {
                return SearchConsoleView.this.getSearchProviderConfiguration();
            }
        };
        return displayer;
    }

    private IDestinationCategoryDescription getDestinationCategory(ISearchDestination destination) {
        if (destination == null) {
            return null;
        }
        try {
            return (IDestinationCategoryDescription)this.getSearchProviderConfiguration().getDestinationCategoriesForDestination(destination).iterator().next();
        }
        catch (DestinationCategoryNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public void showGroupingHierarchies(List<GroupingHierarchy> groupingHierarchies) {
        this.searchParametersUI.showGroupingHierarchies(groupingHierarchies);
    }

    public IProgressMonitor getProgressMonitor() {
        return this.viewProgressMonitor;
    }

    public Composite getResultComposite() {
        return this.bottomComposite;
    }

    public FormToolkit getFormToolkit() {
        return this.formToolkit;
    }

    public void setDefaultSessionId(String sessionId) {
        this.defaultSessionId = sessionId;
    }

    @Override
    public void setStatusMessage(String message) {
        this.slidingComposite.setMessage(message);
    }

    private Point computeUpperCompositeSize(Point fixedParamsCompositeSize, Point customParamsCompositeSize, Point searchButtonSize, SlidingComposite.ORIENTATION orientation) {
        Point size = new Point(fixedParamsCompositeSize.x, fixedParamsCompositeSize.y);
        size.y += 5;
        size.y += searchButtonSize.y;
        if (orientation == SlidingComposite.ORIENTATION.VERTICAL) {
            size.y += customParamsCompositeSize.y + 5;
        } else {
            size.x += customParamsCompositeSize.x + 5;
            size.y = Math.max(size.y, customParamsCompositeSize.y);
            size.y += 5;
        }
        return size;
    }

    @Override
    public void setUiContext(IViewUiContext uiContext) {
        super.setUiContext(uiContext);
        this.uiContext().setSecondColumnPosition(this.getLongestLabelSize(this.getLeftSideLabels()));
    }

    public void registerController(ISearchConsoleController controller) {
        this.controller = controller;
        this.searchProviderSelector.setController(controller);
    }

    public ISearchConsoleControllerOutputView getControllerView() {
        return this;
    }

    private class OrientationChangedListener
    implements IPropertyAttributeListener<SlidingComposite.ORIENTATION> {
        private OrientationChangedListener() {
        }

        public void attributeChanged(PropertyAttributeChangedEvent<SlidingComposite.ORIENTATION> event) {
            SearchConsoleView.this.adjustUpperCompositeLayoutData((SlidingComposite.ORIENTATION)((Object)event.getNewAttribute()));
            SearchConsoleView.this.upperComposite.layout(true, true);
        }
    }
}

