/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.platform.discovery.runtime.api.IDestinationChangeHandler;
import org.eclipse.platform.discovery.runtime.api.IDestinationsProvider;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.ISearchProviderConfiguration;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationCategoryDescription;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IDestinationsProviderDescription;
import org.eclipse.platform.discovery.ui.internal.selector.SearchDestinationsSelector;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;

public abstract class SearchConsoleDestinationsSelector
extends SearchDestinationsSelector {
    private IDestinationChangeHandler destinationsChangeHandler;
    private final ISearchProviderConfiguration searchProviderConfig;
    final Map<IDestinationCategoryDescription, Set<IDestinationsProvider>> currentDestinationProviders;

    public SearchConsoleDestinationsSelector(Composite parent, FormToolkit formToolkit, int secondColumnPosition, Control topNeighbourControl, ISearchProviderConfiguration searchProviderConfig) {
        super(parent, formToolkit, secondColumnPosition, topNeighbourControl);
        this.searchProviderConfig = searchProviderConfig;
        this.currentDestinationProviders = new HashMap<IDestinationCategoryDescription, Set<IDestinationsProvider>>();
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SearchConsoleDestinationsSelector.this.disposeSelector();
            }
        });
    }

    public void registerDestinationsChangeHandler(IDestinationChangeHandler handler) {
        this.destinationsChangeHandler = handler;
    }

    private void disposeSelector() {
        this.unregisterCurrentDestinationsChangeHandler();
        this.destinationsChangeHandler = null;
    }

    @Override
    protected Set<IDestinationsProvider> getDestinationProvidersForCategory(IDestinationCategoryDescription category) {
        Set<IDestinationsProvider> result = this.currentDestinationProviders.get(category);
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    protected List<ISearchDestination> getSearchDestinations(IDestinationCategoryDescription category, IDestinationsProvider destinationsProvider) {
        return this.searchProviderConfig.getSearchDestinations(category, destinationsProvider);
    }

    @Override
    public void setInput(List<IDestinationCategoryDescription> input) {
        if (this.destinationsChangeHandler == null) {
            return;
        }
        this.unregisterCurrentDestinationsChangeHandler();
        for (IDestinationCategoryDescription cat : input) {
            if (this.currentDestinationProviders.get(cat) == null) {
                this.currentDestinationProviders.put(cat, new HashSet());
            }
            for (IDestinationsProviderDescription providerDescription : this.searchProviderConfig.getDestinationProvidersForCategory(cat)) {
                IDestinationsProvider provider = providerDescription.createProvider();
                provider.registerDestinationsChangeHandler(this.destinationsChangeHandler);
                this.currentDestinationProviders.get(cat).add(provider);
            }
        }
        super.setInput(input);
    }

    private void unregisterCurrentDestinationsChangeHandler() {
        if (this.destinationsChangeHandler == null) {
            return;
        }
        for (Set<IDestinationsProvider> providersList : this.currentDestinationProviders.values()) {
            for (IDestinationsProvider p : providersList) {
                p.unregisterDestinationsChangeHandler(this.destinationsChangeHandler);
            }
        }
        this.currentDestinationProviders.clear();
    }
}

