/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.impl;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;

public class SearchConsoleSelectionProvider
implements ISelectionProvider {
    private ISelection selection = new StructuredSelection();
    private final Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private final IViewCustomizationsObtainer customizationsObtainer;

    public SearchConsoleSelectionProvider(IViewCustomizationsObtainer customizationsObtainer) {
        this.customizationsObtainer = customizationsObtainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.add(listener);
        }
    }

    public ISelection getSelection() {
        return this.selection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        Set<ISelectionChangedListener> set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        assert (selection != null);
        this.selection = selection;
        for (IGenericViewCustomization customization : this.customizationsObtainer.viewCustomizations()) {
            customization.selectionChanged(selection);
        }
        Iterator<ISelectionChangedListener> i = this.cloneListeners().iterator();
        while (i.hasNext()) {
            i.next().selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.getSelection()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ISelectionChangedListener> cloneListeners() {
        HashSet<ISelectionChangedListener> clonings = new HashSet<ISelectionChangedListener>();
        Set<ISelectionChangedListener> set = this.selectionListeners;
        synchronized (set) {
            clonings.addAll(this.selectionListeners);
        }
        return clonings;
    }

    public static interface IViewCustomizationsObtainer {
        public List<IGenericViewCustomization> viewCustomizations();
    }
}

