/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.util.api.xml.IXmlRepresentable;
import org.eclipse.platform.discovery.util.internal.xml.CollectionTransformer;
import org.eclipse.platform.discovery.util.internal.xml.ICollectionTransformer;
import org.eclipse.platform.discovery.util.xml.CollectionTransformerAbstractTest;
import org.jmock.core.Constraint;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;
import org.w3c.dom.Element;

public abstract class CollectionTransformerTest
extends CollectionTransformerAbstractTest {
    private static final String testNamespace = "http://test.namespace.eclipse.org";
    private static final String testItemTag = "test-item";
    private static final String testCollecitonTag = "test-collection";
    protected Mock<IAdapterManager> mgrMock;

    public static Test suite() {
        TestSuite s = new TestSuite();
        s.addTestSuite(WithNonAdaptableObjects.class);
        s.addTestSuite(WithAdaptableObjects.class);
        s.addTestSuite(WithInstanceOfXmlRepresentable.class);
        return s;
    }

    @Override
    protected String testCollecitonTag() {
        return testCollecitonTag;
    }

    @Override
    protected String testItemTag() {
        return testItemTag;
    }

    @Override
    protected String testNamespace() {
        return testNamespace;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.mgrMock = this.mock(IAdapterManager.class);
        this.lorMock.expects(this.once()).method("run").withAnyArguments().will(this.invokePassedOperation());
        this.pmMock.stubs().method("beginTask").withAnyArguments();
        this.pmMock.stubs().method("done").withAnyArguments();
    }

    @Override
    protected ICollectionTransformer createCollectionTransformer() {
        CollectionTransformer ct = new CollectionTransformer(){

            protected IAdapterManager getAdapterManager() {
                return (IAdapterManager)CollectionTransformerTest.this.mgrMock.proxy();
            }
        };
        ct.setCollectionTag(this.testCollecitonTag());
        ct.setItemTag(this.testItemTag());
        ct.setNamespace(this.testNamespace());
        return ct;
    }

    public static class WithAdaptableObjects
    extends CollectionTransformerTest {
        @Override
        public void setUp() {
            super.setUp();
            this.mgrMock.stubs().method("getAdapter").with((Constraint)this.isA(String.class), (Constraint)this.same(IXmlRepresentable.class)).will(new Stub(){

                public Object invoke(Invocation arg0) throws Throwable {
                    return new XmlRepresentableObject((String)arg0.parameterValues.get(0));
                }

                public StringBuffer describeTo(StringBuffer arg0) {
                    arg0.append("Return adapter from String to IXmlRepresentable");
                    return arg0;
                }
            });
        }

        @Override
        protected Collection<?> createTestList() {
            ArrayList<String> collection = new ArrayList<String>(3);
            collection.add("item1");
            collection.add("item2");
            collection.add("item3");
            return collection;
        }

        @Override
        protected void assertExpectedElement(int i, Element item) {
            Iterator it = this.testCollection.iterator();
            String ithToString = null;
            int j = 0;
            while (j < i + 1) {
                ithToString = it.next().toString();
                ++j;
            }
            j = 0;
            while (j < i + 1) {
                WithAdaptableObjects.assertNotNull((Object)item.getElementsByTagNameNS(this.testNamespace(), ithToString).item(0));
                ++j;
            }
        }
    }

    public static class WithInstanceOfXmlRepresentable
    extends WithAdaptableObjects {
        @Override
        protected Collection<?> createTestList() {
            ArrayList<XmlRepresentableObject> collection = new ArrayList<XmlRepresentableObject>(3);
            collection.add(new XmlRepresentableObject("item1"));
            collection.add(new XmlRepresentableObject("item2"));
            collection.add(new XmlRepresentableObject("item3"));
            return collection;
        }
    }

    public static class WithNonAdaptableObjects
    extends CollectionTransformerTest {
        @Override
        public void setUp() {
            super.setUp();
            this.mgrMock.stubs().method("getAdapter").with((Constraint)this.isA(String.class), (Constraint)this.same(IXmlRepresentable.class)).will(this.returnValue(null));
            this.mgrMock.stubs().method("loadAdapter").with((Constraint)this.isA(String.class), (Constraint)this.eq(IXmlRepresentable.class.getName())).will(this.returnValue(null));
        }

        @Override
        protected Collection<?> createTestList() {
            ArrayList<String> collection = new ArrayList<String>(3);
            collection.add("item1");
            collection.add("item2");
            collection.add("item3");
            return collection;
        }

        @Override
        protected void assertExpectedElement(int i, Element item) {
            Iterator it = this.testCollection.iterator();
            String ithToString = null;
            int j = 0;
            while (j < i + 1) {
                ithToString = it.next().toString();
                ++j;
            }
            WithNonAdaptableObjects.assertEquals((String)ithToString, (String)item.getTextContent().trim());
        }
    }

    private static class XmlRepresentableObject
    implements IXmlRepresentable {
        final String s;

        public XmlRepresentableObject(String s) {
            this.s = s;
        }

        public String toString() {
            return this.s;
        }

        public String toStringXml(IProgressMonitor pm) {
            return "<" + this.s + "/>";
        }
    }
}

