/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.core.test.unit.internal;

import java.io.IOException;
import org.eclipse.platform.discovery.core.test.unit.internal.SearchFavoritesControllerTestFixture;
import org.eclipse.platform.discovery.runtime.api.ISearchDestination;
import org.eclipse.platform.discovery.runtime.internal.persistence.MementoContentManagerException;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.ui.WorkbenchException;
import org.jmock.core.Constraint;

public abstract class AbstractSearchFavoritesControllerImportTest
extends MockObjectTestCase {
    protected SearchFavoritesControllerTestFixture fixture;
    protected Mock<ISearchDestination> searchDestination;

    public void setUp() {
        this.searchDestination = this.mock(ISearchDestination.class);
        this.fixture = new SearchFavoritesControllerTestFixture(this);
        this.fixture.favoritesView.expects(this.once()).method("showFavorites").with(this.collectionWithElements(1, new Object[]{this.fixture.expectedObjectToShowInView}));
    }

    private void testImportWithExceptionFromPersistenceUtil(Exception exc) {
        this.fixture.persistenceUtil.expects(this.once()).method("addItems").withAnyArguments().will(this.throwException(exc));
        this.fixture.errorHandler.expects(this.once()).method("handleException").with((Constraint)this.eq(exc));
        this.abstractDoImport();
    }

    public abstract void testImportToFavorites();

    protected abstract void abstractDoImport();

    public final void testAddItemsWithWbException() {
        WorkbenchException e = new WorkbenchException("");
        this.testImportWithExceptionFromPersistenceUtil((Exception)e);
    }

    public final void testAddItemsWithIOException() {
        IOException e = new IOException();
        this.testImportWithExceptionFromPersistenceUtil(e);
    }

    public final void testAddItemsWithMementoException() {
        MementoContentManagerException e = new MementoContentManagerException();
        this.testImportWithExceptionFromPersistenceUtil((Exception)e);
    }
}

