/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.databinding.beans;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.IBeanSetProperty;
import org.eclipse.core.databinding.property.set.DelegatingSetProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousBeanSetProperty<S, E>
extends DelegatingSetProperty<S, E> {
    private final String propertyName;
    private Map<Class<? extends S>, ISetProperty<S, E>> delegates;

    public AnonymousBeanSetProperty(String propertyName, Class<E> elementType) {
        super(elementType);
        this.propertyName = propertyName;
        this.delegates = new HashMap<Class<? extends S>, ISetProperty<S, E>>();
    }

    protected ISetProperty<S, E> doGetDelegate(S source) {
        IBeanSetProperty delegate;
        Class<S> beanClass = Util.getClass(source);
        if (this.delegates.containsKey(beanClass)) {
            return this.delegates.get(beanClass);
        }
        try {
            delegate = BeanProperties.set(beanClass, this.propertyName, this.getElementClass());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            delegate = null;
        }
        this.delegates.put(beanClass, delegate);
        return delegate;
    }

    public String toString() {
        String s = "?." + this.propertyName + "{}";
        Class elementType = this.getElementClass();
        if (elementType != null) {
            s = String.valueOf(s) + "<" + BeanPropertyHelper.shortClassName(elementType) + ">";
        }
        return s;
    }
}

