/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import org.eclipse.core.databinding.UpdateStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateListStrategy<S, D>
extends UpdateStrategy {
    public static int POLICY_NEVER = UpdateListStrategy.notInlined(1);
    public static int POLICY_ON_REQUEST = UpdateListStrategy.notInlined(2);
    public static int POLICY_UPDATE = UpdateListStrategy.notInlined(8);
    protected IConverter<S, D> converter;
    private int updatePolicy;
    protected boolean provideDefaults;

    private static int notInlined(int i) {
        return i;
    }

    public UpdateListStrategy() {
        this(true, POLICY_UPDATE);
    }

    public UpdateListStrategy(int updatePolicy) {
        this(true, updatePolicy);
    }

    public UpdateListStrategy(boolean provideDefaults, int updatePolicy) {
        this.provideDefaults = provideDefaults;
        this.updatePolicy = updatePolicy;
    }

    public D convert(S element) {
        return (D)(this.converter == null ? element : this.converter.convert(element));
    }

    protected void fillDefaults(IObservableList<S> source, IObservableList<D> destination) {
        Object sourceType = source.getElementType();
        Object destinationType = destination.getElementType();
        if (this.provideDefaults && sourceType != null && destinationType != null && this.converter == null) {
            this.setConverter(this.createConverter(sourceType, destinationType));
        }
        if (this.converter != null) {
            if (sourceType != null) {
                this.checkAssignable(this.converter.getFromType(), sourceType, "converter does not convert from type " + sourceType);
            }
            if (destinationType != null) {
                this.checkAssignable(destinationType, this.converter.getToType(), "converter does not convert to type " + destinationType);
            }
        }
    }

    public int getUpdatePolicy() {
        return this.updatePolicy;
    }

    public UpdateListStrategy<S, D> setConverter(IConverter<S, D> converter) {
        this.converter = converter;
        return this;
    }

    protected IStatus doAdd(IObservableList<D> observableList, D element, int index) {
        try {
            observableList.add(index, element);
        }
        catch (Exception ex) {
            return ValidationStatus.error(BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"), ex);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doRemove(IObservableList<D> observableList, int index) {
        try {
            observableList.remove(index);
        }
        catch (Exception ex) {
            return ValidationStatus.error(BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"), ex);
        }
        return Status.OK_STATUS;
    }

    protected boolean useMoveAndReplace() {
        return this.getClass() == UpdateListStrategy.class;
    }

    protected IStatus doMove(IObservableList<D> observableList, int oldIndex, int newIndex) {
        try {
            observableList.move(oldIndex, newIndex);
        }
        catch (Exception ex) {
            return ValidationStatus.error(BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"), ex);
        }
        return Status.OK_STATUS;
    }

    protected IStatus doReplace(IObservableList<D> observableList, int index, D element) {
        try {
            observableList.set(index, element);
        }
        catch (Exception ex) {
            return ValidationStatus.error(BindingMessages.getString("ValueBinding_ErrorWhileSettingValue"), ex);
        }
        return Status.OK_STATUS;
    }
}

