/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.languages.javascript.test;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.e4.internal.languages.javascript.JSFrameworkImpl;
import org.eclipse.e4.internal.languages.javascript.RhinoClassLoader;
import org.eclipse.e4.languages.javascript.JSBundle;
import org.eclipse.e4.languages.javascript.JSBundleException;
import org.eclipse.e4.languages.javascript.JSONUtil;
import org.eclipse.e4.languages.javascript.test.Activator;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JSFrameworkTest
extends TestCase {
    public static String TEST = "test";
    static /* synthetic */ Class class$0;

    private static void writeToFile(String string, File file) throws FileNotFoundException, IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        try {
            writer.write(string);
        }
        catch (Throwable throwable) {
            try {
                ((Writer)writer).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((Writer)writer).close();
        }
        catch (IOException iOException) {}
    }

    public JSFrameworkTest(String name) {
        super(name);
    }

    public void testZeroBundles() {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        JSFrameworkTest.assertEquals((int)0, (int)framework.getBundles().length);
    }

    public void testInstallResolveBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
    }

    public void testInstallResolveBundleFromLocation() throws JSBundleException, IOException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        String result = JSONUtil.write(headers);
        File temp = File.createTempFile("temp", "js");
        try {
            JSFrameworkTest.writeToFile(result, temp);
            framework.installBundle(temp.toURI().toString(), headers);
            JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
            JSBundle jsBundle = framework.getBundles()[0];
            JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
            framework.resolve();
            JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        }
        finally {
            temp.delete();
        }
    }

    public void testStartStopBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        jsBundle.start();
        JSFrameworkTest.assertEquals((int)32, (int)jsBundle.getState());
        jsBundle.stop();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
    }

    public void testInstallUnresolveableBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Import-Package", "some.test");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
    }

    public void testSingletonInstallResolveBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test; singleton:=true");
        headers.put("Bundle-Version", "1.8");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        HashMap<String, String> headers2 = new HashMap<String, String>();
        headers2.put("Bundle-SymbolicName", "test; singleton:=true");
        headers2.put("Bundle-Version", "1.9");
        headers2.put("Export-Package", "test");
        headers2.put("Bundle-Script", "var test=\"test\";");
        framework.installBundle("testloc2", headers2);
        JSBundle jsBundle2 = framework.getBundles()[1];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle2.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle2.getState());
    }

    public void testScopedVariableBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Bundle-Script", "var test=\"test\";");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("test", scope);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
        JSFrameworkTest.assertEquals((Object)"test", (Object)obj);
    }

    public void testScopedVariableBundleWithExtraPath() throws JSBundleException, IOException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Bundle-Script", "var test=\"test\";");
        File temp1 = File.createTempFile("temp1", "js");
        File temp2 = File.createTempFile("temp2", "js");
        try {
            headers.put("Bundle-ScriptPath", "., " + temp2.getName());
            JSFrameworkTest.writeToFile(JSONUtil.write(headers), temp1);
            JSFrameworkTest.writeToFile("var test2=test +'x';", temp2);
            framework.installBundle(temp1.toURI().toString());
            JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
            JSBundle jsBundle = framework.getBundles()[0];
            JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
            framework.resolve();
            JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
            Scriptable scope = jsBundle.getScope();
            Object obj = scope.get("test", scope);
            JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
            JSFrameworkTest.assertEquals((Object)"test", (Object)obj);
            Object obj2 = scope.get("test2", scope);
            JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj2);
            JSFrameworkTest.assertEquals((Object)"testx", (Object)obj2);
        }
        finally {
            temp1.delete();
            temp2.delete();
        }
    }

    public void testStartStopActivatorBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        String script = "";
        script = String.valueOf(script) + "var x = 1;";
        script = String.valueOf(script) + "var Activator = function() {";
        script = String.valueOf(script) + "this.start = function() {x = x + 1;}\n";
        script = String.valueOf(script) + "this.stop = function() {x = x + 2;}\n";
        script = String.valueOf(script) + "}";
        headers.put("Bundle-Script", script);
        headers.put("Bundle-Activator", "Activator");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"1.0", (String)obj.toString());
        jsBundle.start();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"2.0", (String)obj.toString());
        jsBundle.stop();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"4.0", (String)obj.toString());
        jsBundle.start();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"5.0", (String)obj.toString());
        jsBundle.stop();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"7.0", (String)obj.toString());
    }

    public void testStartStopScopedActivatorBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        String script = "";
        script = String.valueOf(script) + "var x = 1;";
        script = String.valueOf(script) + "var z = {};";
        script = String.valueOf(script) + "z.Activator = function() {";
        script = String.valueOf(script) + "this.start = function() {x = x + 1;}\n";
        script = String.valueOf(script) + "this.stop = function() {x = x + 2;}\n";
        script = String.valueOf(script) + "}";
        headers.put("Bundle-Script", script);
        headers.put("Bundle-Activator", "z.Activator");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"1.0", (String)obj.toString());
        jsBundle.start();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"2.0", (String)obj.toString());
        jsBundle.stop();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"4.0", (String)obj.toString());
        jsBundle.start();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"5.0", (String)obj.toString());
        jsBundle.stop();
        obj = scope.get("x", scope);
        JSFrameworkTest.assertEquals((String)"7.0", (String)obj.toString());
    }

    public void testImportsBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Import-Package", "test");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        HashMap<String, String> headers2 = new HashMap<String, String>();
        headers2.put("Bundle-SymbolicName", "test2");
        headers2.put("Bundle-Version", "1.8");
        headers2.put("Export-Package", "test");
        headers2.put("Bundle-Script", "var test=\"test\";");
        framework.installBundle("testloc2", headers2);
        JSBundle jsBundle2 = framework.getBundles()[1];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle2.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle2.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("test", scope);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
        JSFrameworkTest.assertEquals((Object)"test", (Object)obj);
    }

    public void testRequiresBundle() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Require-Bundle", "test2");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        HashMap<String, String> headers2 = new HashMap<String, String>();
        headers2.put("Bundle-SymbolicName", "test2");
        headers2.put("Bundle-Version", "1.8");
        headers2.put("Export-Package", "a.test");
        headers2.put("Bundle-Script", "var a = {}; a.test=\"test\";");
        framework.installBundle("testloc2", headers2);
        JSBundle jsBundle2 = framework.getBundles()[1];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle2.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle2.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("a", scope);
        JSFrameworkTest.assertTrue((boolean)(obj instanceof Scriptable));
        scope = (Scriptable)obj;
        obj = scope.get("test", scope);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
        JSFrameworkTest.assertEquals((Object)"test", (Object)obj);
    }

    public void testCallFromJava() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Bundle-Script", "var test=function() { return \"test\";}");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("test", scope);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
        JSFrameworkTest.assertTrue((boolean)(obj instanceof Callable));
        Callable test = (Callable)obj;
        Context.enter();
        try {
            JSFrameworkTest.assertEquals((Object)"test", (Object)test.call(Context.getCurrentContext(), scope, scope, null));
        }
        finally {
            Context.exit();
        }
    }

    public void testCallJavaFromJSCreateString() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        headers.put("Bundle-Script", "var test=function() { return new java.lang.String(\"test\");}");
        framework.installBundle("testloc", headers);
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("test", scope);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
        JSFrameworkTest.assertTrue((boolean)(obj instanceof Callable));
        Callable test = (Callable)obj;
        Context.enter();
        try {
            Object result = test.call(Context.getCurrentContext(), scope, scope, null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object javaResult = Context.jsToJava((Object)result, (Class)clazz);
            JSFrameworkTest.assertEquals((Object)"test", (Object)javaResult);
        }
        finally {
            Context.exit();
        }
    }

    public void testCallJavaFromJSGetBundleStatic() throws JSBundleException {
        JSFrameworkImpl framework = new JSFrameworkImpl();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Bundle-SymbolicName", "test");
        headers.put("Bundle-Version", "1.8");
        String script = "";
        script = String.valueOf(script) + "var test=function() {";
        script = String.valueOf(script) + "var clazz = Packages.org.eclipse.e4.languages.javascript.test.JSFrameworkTest;";
        script = String.valueOf(script) + "return clazz.TEST;";
        script = String.valueOf(script) + "}";
        headers.put("Bundle-Script", script);
        framework.installBundle("testloc", headers, new RhinoClassLoader(Activator.getBundleContext().getBundle()));
        JSFrameworkTest.assertEquals((int)1, (int)framework.getBundles().length);
        JSBundle jsBundle = framework.getBundles()[0];
        JSFrameworkTest.assertEquals((int)2, (int)jsBundle.getState());
        framework.resolve();
        JSFrameworkTest.assertEquals((int)4, (int)jsBundle.getState());
        Scriptable scope = jsBundle.getScope();
        Object obj = scope.get("test", scope);
        JSFrameworkTest.assertNotSame((Object)Scriptable.NOT_FOUND, (Object)obj);
        JSFrameworkTest.assertTrue((boolean)(obj instanceof Callable));
        Callable test = (Callable)obj;
        Context.enter();
        try {
            Object result = test.call(Context.getCurrentContext(), scope, scope, null);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Object javaResult = Context.jsToJava((Object)result, (Class)clazz);
            JSFrameworkTest.assertEquals((Object)"test", (Object)javaResult);
        }
        finally {
            Context.exit();
        }
    }
}

