/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.runtime.test.unit.internal;

import java.util.List;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.platform.discovery.runtime.internal.model.descriptions.IObjectTypeDescription;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.AbstractExtensionPointParser;
import org.eclipse.platform.discovery.runtime.internal.xp.impl.ObjectTypeExtensionParser;
import org.eclipse.platform.discovery.testutils.utils.registry.ExtensionRegistryBuilder;
import org.eclipse.platform.discovery.testutils.utils.testcases.AbstractExtensionPointParserTest;
import org.junit.Assert;

public class ObjectTypeExtensionParserTest
extends AbstractExtensionPointParserTest<IObjectTypeDescription> {
    private static final String OBJECT_ID = "myobject";
    private static final String OBJECT_NAME = "My Object";

    protected AbstractExtensionPointParser<IObjectTypeDescription> createParser(IExtensionRegistry registry) {
        return new ObjectTypeExtensionParser(registry);
    }

    protected void setupRegistry(ExtensionRegistryBuilder registryBuilder) {
        registryBuilder.addObjectType(OBJECT_ID, OBJECT_NAME);
    }

    protected void verifyContributions(List<IObjectTypeDescription> contributions) {
        Assert.assertEquals((String)"Unexpected number of object types", (long)1L, (long)contributions.size());
        IObjectTypeDescription objectType = contributions.get(0);
        Assert.assertEquals((String)"Unexpected id", (Object)OBJECT_ID, (Object)objectType.getId());
        Assert.assertEquals((String)"Unexpected name", (Object)OBJECT_NAME, (Object)objectType.getDisplayName());
    }
}

