/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.platform.discovery.testutils.utils.pageobjects.InShellPageObject;
import org.eclipse.platform.discovery.ui.internal.plugin.DiscoveryUIMessages;
import org.eclipse.platform.discovery.ui.internal.view.result.impl.TabbedSessionDisplayer;
import org.eclipse.platform.discovery.ui.test.comp.internal.pageobjects.swtbot.workarounds.MyBot;
import org.eclipse.platform.discovery.util.internal.session.HistoryTrack;
import org.eclipse.platform.discovery.util.internal.session.IHistoryTrack;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotCTabItem;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotToolbarButton;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.mockito.Mockito;

public class TabbedSessionDisplayerPageObject {
    private long SWT_TIMEOUT = SWTBotPreferences.TIMEOUT;
    private long OUR_TIMEOUT = 1000L;
    private TabbedSessionDisplayer<String> sessionDisplayer;
    private Map<String, ISession<String>> idsToSessions = new HashMap<String, ISession<String>>();
    private Map<String, String> itemsToIds = new HashMap<String, String>();
    private InShellPageObject inShellPageObject;

    public void addUnnavigableSession(String id, String item) {
        this.addSession(id, item);
    }

    public void addSession(String id, String ... items) {
        IHistoryTrack<String> track = this.createHistoryTrack(items);
        this.mapItemsToSessionId(items, id);
        ISession session = (ISession)Mockito.mock(ISession.class);
        Mockito.when((Object)session.getId()).thenReturn((Object)id);
        Mockito.when((Object)session.historyTrack()).thenReturn(track);
        this.idsToSessions.put(id, (ISession<String>)session);
    }

    private void mapItemsToSessionId(String[] items, String id) {
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.itemsToIds.put(item, id);
            ++n2;
        }
    }

    private IHistoryTrack<String> createHistoryTrack(String ... items) {
        HistoryTrack track = new HistoryTrack(items.length);
        String[] stringArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            track.track((Object)item);
            ++n2;
        }
        this.rewindTrack((IHistoryTrack<String>)track);
        return track;
    }

    private void rewindTrack(IHistoryTrack<String> track) {
        while (track.hasPrevious()) {
            track.previous();
        }
    }

    public void displaySessions(final String[] ids, final boolean[] closeable) {
        if (ids.length != closeable.length) {
            throw new IllegalArgumentException("ids and closeable must be of equal length");
        }
        this.inShellPageObject = new InShellPageObject(){

            protected void createContent(Shell parent, final FormToolkit formToolkit) {
                MyUiFactory uiFactory = new MyUiFactory(){

                    public FormToolkit getFormTookit() {
                        return formToolkit;
                    }
                };
                TabbedSessionDisplayerPageObject.this.sessionDisplayer = new TabbedSessionDisplayer((Composite)parent, (TabbedSessionDisplayer.UIFactory)uiFactory, 0);
                int i = 0;
                while (i < ids.length) {
                    String sessionId = ids[i];
                    if (!closeable[i]) {
                        TabbedSessionDisplayerPageObject.this.sessionDisplayer.setSessionUnclosable(sessionId);
                    }
                    TabbedSessionDisplayerPageObject.this.sessionDisplayer.display((ISession)TabbedSessionDisplayerPageObject.this.idsToSessions.get(sessionId));
                    ++i;
                }
            }

            abstract class MyUiFactory
            implements TabbedSessionDisplayer.UIFactory<String> {
                MyUiFactory() {
                }

                public TabbedSessionDisplayer.UI create(String sc, Composite parent) {
                    TabbedSessionDisplayer.UI result = (TabbedSessionDisplayer.UI)Mockito.mock(TabbedSessionDisplayer.UI.class);
                    Mockito.when((Object)result.parent()).thenReturn((Object)parent);
                    String sessionId = (String)TabbedSessionDisplayerPageObject.this.itemsToIds.get(sc);
                    Mockito.when((Object)result.title()).thenReturn((Object)sessionId);
                    return result;
                }
            }
        };
        this.inShellPageObject.open();
        SWTBotPreferences.TIMEOUT = this.OUR_TIMEOUT;
    }

    public void tearDown() {
        try {
            this.inShellPageObject.close();
            this.idsToSessions.clear();
            this.itemsToIds.clear();
            this.sessionDisplayer = null;
        }
        finally {
            SWTBotPreferences.TIMEOUT = this.SWT_TIMEOUT;
        }
    }

    public boolean isNavigateToNextAvailable() {
        try {
            this.getNextButton();
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    public boolean isNavigateToPreviousAvailable() {
        try {
            this.getPreviousButton();
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    private SWTBotToolbarButton getPreviousButton() {
        return this.getButtonWithTooltip(DiscoveryUIMessages.AbstractSearchResultTab_GoToPrevious);
    }

    private SWTBotToolbarButton getNextButton() {
        return this.getButtonWithTooltip(DiscoveryUIMessages.AbstractSearchResultTab_GoToNext);
    }

    private SWTBotToolbarButton getButtonWithTooltip(String tooltip) {
        return this.shellBot().toolbarButtonWithTooltip(tooltip);
    }

    private SWTBot shellBot() {
        return new MyBot((Widget)this.inShellPageObject.getShell());
    }

    public void closeSession(String sessionId) {
        this.tabItem(sessionId).close();
    }

    private SWTBotCTabItem tabItem(String sessionId) {
        return this.shellBot().cTabItem(sessionId);
    }

    public boolean isSessionOpen(String sessionId) {
        try {
            this.tabItem(sessionId);
            return true;
        }
        catch (WidgetNotFoundException widgetNotFoundException) {
            return false;
        }
    }

    public void selectSession(String sessionId) {
        this.tabItem(sessionId).activate();
    }

    public boolean isNavigateToPreviousEnabled() {
        return this.getPreviousButton().isEnabled();
    }

    public boolean isNavigateToNextEnabled() {
        return this.getNextButton().isEnabled();
    }

    public void navigateToPrevious() {
        this.getPreviousButton().click();
    }

    public void navigateToNext() {
        this.getNextButton().click();
    }
}

