/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.property;

import java.util.ListIterator;
import org.eclipse.platform.discovery.testutils.utils.jmock.Mock;
import org.eclipse.platform.discovery.testutils.utils.jmock.MockObjectTestCase;
import org.eclipse.platform.discovery.util.internal.property.Access;
import org.eclipse.platform.discovery.util.internal.property.AccessCheckingListIterator;
import org.eclipse.platform.discovery.util.internal.property.IListProperty;
import org.jmock.core.Constraint;

public class AccessCheckingListIteratorTests
extends MockObjectTestCase {
    private AccessCheckingListIterator<Object> targetIterator;
    private Mock<IListProperty<Object>> mockProperty;
    private Mock<ListIterator<Object>> mockDelegateIter;
    private Object readWriteObj = new Object();

    public void setUp() {
        this.mockDelegateIter = this.mock(ListIterator.class);
        this.mockProperty = this.mock(IListProperty.class);
        this.targetIterator = new AccessCheckingListIterator((IListProperty)this.mockProperty.proxy(), (ListIterator)this.mockDelegateIter.proxy());
    }

    public void testIteratorAddAccessReadOnly() {
        this.mockProperty.expects(this.exactly(2)).method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.targetIterator.add(new Object());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testIteratorAddAccessNotDenied() {
        this.mockDelegateIter.expects(this.once()).method("add").with((Constraint)this.same(this.readWriteObj));
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.targetIterator.add(this.readWriteObj);
    }

    public void testIteratorHasNextReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("hasNext").withNoArguments().will(this.returnValue(true));
        AccessCheckingListIteratorTests.assertTrue((boolean)this.targetIterator.hasNext());
    }

    public void testIteratorHasPreviousReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("hasPrevious").withNoArguments().will(this.returnValue(true));
        AccessCheckingListIteratorTests.assertTrue((boolean)this.targetIterator.hasPrevious());
    }

    public void testIteratorHasPreviousReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        this.mockDelegateIter.expects(this.once()).method("hasPrevious").withNoArguments().will(this.returnValue(true));
        AccessCheckingListIteratorTests.assertTrue((boolean)this.targetIterator.hasPrevious());
    }

    public void testIteratorNextReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("next").withNoArguments().will(this.returnValue(this.readWriteObj));
        AccessCheckingListIteratorTests.assertSame((Object)this.readWriteObj, (Object)this.targetIterator.next());
    }

    public void testNextReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        this.mockDelegateIter.expects(this.once()).method("next").withNoArguments().will(this.returnValue(this.readWriteObj));
        AccessCheckingListIteratorTests.assertSame((Object)this.readWriteObj, (Object)this.targetIterator.next());
    }

    public void testNextIndexReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("nextIndex").withNoArguments().will(this.returnValue(26));
        AccessCheckingListIteratorTests.assertEquals((int)26, (int)this.targetIterator.nextIndex());
    }

    public void testNextIndexReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        this.mockDelegateIter.expects(this.once()).method("nextIndex").withNoArguments().will(this.returnValue(26));
        AccessCheckingListIteratorTests.assertEquals((int)26, (int)this.targetIterator.nextIndex());
    }

    public void testPreviousReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("previous").withNoArguments().will(this.returnValue(this.readWriteObj));
        AccessCheckingListIteratorTests.assertSame((Object)this.readWriteObj, (Object)this.targetIterator.previous());
    }

    public void testPreviousReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        this.mockDelegateIter.expects(this.once()).method("previous").withNoArguments().will(this.returnValue(this.readWriteObj));
        AccessCheckingListIteratorTests.assertSame((Object)this.readWriteObj, (Object)this.targetIterator.previous());
    }

    public void testPreviousIndexReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("previousIndex").withNoArguments().will(this.returnValue(26));
        AccessCheckingListIteratorTests.assertEquals((int)26, (int)this.targetIterator.previousIndex());
    }

    public void testPreviousIndexReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        this.mockDelegateIter.expects(this.once()).method("previousIndex").withNoArguments().will(this.returnValue(26));
        AccessCheckingListIteratorTests.assertEquals((int)26, (int)this.targetIterator.previousIndex());
    }

    public void testRemoveReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.targetIterator.remove();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testRemoveReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("remove").withNoArguments();
        this.targetIterator.remove();
    }

    public void testSetReadOnly() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_ONLY));
        try {
            this.targetIterator.set(this.readWriteObj);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
    }

    public void testSetReadWrite() {
        this.mockProperty.stubs().method("getListAccess").withNoArguments().will(this.returnValue(Access.READ_WRITE));
        this.mockDelegateIter.expects(this.once()).method("set").with((Constraint)this.same(this.readWriteObj));
        this.targetIterator.set(this.readWriteObj);
    }
}

