/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.DecoratingObservable;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableObservableList<E>
extends DecoratingObservable
implements IObservableList<E> {
    private IObservableList<? extends E> decorated;
    private IListChangeListener<E> listChangeListener;
    private Class<E> elementType;

    public UnmodifiableObservableList(IObservableList<E> decorated) {
        super(decorated, false);
        this.decorated = decorated;
        this.elementType = decorated.getElementClass();
    }

    public UnmodifiableObservableList(IObservableList<? extends E> decorated, Class<E> elementType) {
        super(decorated, false);
        this.decorated = decorated;
        this.elementType = elementType;
    }

    @Override
    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        return this.decorated.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.getterCalled();
        return this.decorated.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.decorated.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        final Iterator<? extends E> decoratedIterator = this.decorated.iterator();
        return new Iterator<E>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                UnmodifiableObservableList.this.getterCalled();
                return decoratedIterator.hasNext();
            }

            @Override
            public E next() {
                UnmodifiableObservableList.this.getterCalled();
                return decoratedIterator.next();
            }
        };
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.decorated.size();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        return this.decorated.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.getterCalled();
        return this.decorated.toArray(a);
    }

    @Override
    public Object getElementType() {
        return this.decorated.getElementType();
    }

    @Override
    public Class<E> getElementClass() {
        return this.elementType;
    }

    @Override
    public boolean equals(Object obj) {
        this.getterCalled();
        if (this == obj) {
            return true;
        }
        return this.decorated.equals(obj);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.decorated.hashCode();
    }

    public String toString() {
        this.getterCalled();
        return this.decorated.toString();
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener<? super E> listener) {
        this.addListener(ListChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeListChangeListener(IListChangeListener<? super E> listener) {
        this.removeListener(ListChangeEvent.TYPE, listener);
    }

    protected void fireListChange(ListDiff<E> diff) {
        super.fireChange();
        this.fireEvent(new ListChangeEvent<E>(this, diff));
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.listChangeListener == null) {
            this.listChangeListener = new IListChangeListener<E>(){

                @Override
                public void handleListChange(ListChangeEvent<E> event) {
                    UnmodifiableObservableList.this.handleListChange(event);
                }
            };
        }
        this.decorated.addListChangeListener(this.listChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.listChangeListener != null) {
            this.decorated.removeListChangeListener(this.listChangeListener);
            this.listChangeListener = null;
        }
    }

    protected void handleListChange(ListChangeEvent<E> event) {
        this.fireListChange(event.diff);
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        return this.decorated.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        return this.decorated.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.decorated.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        final ListIterator<? extends E> iterator = this.decorated.listIterator(index);
        return new ListIterator<E>(){

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.hasPrevious();
            }

            @Override
            public E next() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.next();
            }

            @Override
            public int nextIndex() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.nextIndex();
            }

            @Override
            public E previous() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.previous();
            }

            @Override
            public int previousIndex() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return Collections.unmodifiableList(this.decorated.subList(fromIndex, toIndex));
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.listChangeListener != null) {
            this.decorated.removeListChangeListener(this.listChangeListener);
        }
        this.decorated = null;
        this.listChangeListener = null;
        super.dispose();
    }
}

