/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.internal.languages.javascript;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.URIUtil;

public class JSBundleData {
    private final int bundleId;
    private final String location;
    private final Map headers;
    private final ClassLoader contextClassLoader;
    private URL base;
    private String relativepath = null;

    public JSBundleData(int bundleId, String location, Map headers, ClassLoader contextClassLoader) {
        this.bundleId = bundleId;
        this.location = location;
        this.headers = Collections.unmodifiableMap(new HashMap(headers));
        this.contextClassLoader = contextClassLoader;
    }

    private synchronized void initBase() throws MalformedURLException {
        if (this.base != null) {
            return;
        }
        this.base = new URL(this.location);
    }

    public int getBundleId() {
        return this.bundleId;
    }

    public String getLocation() {
        return this.location;
    }

    public Map getHeaders() {
        return this.headers;
    }

    public String getRelativePath() {
        if (this.relativepath == null) {
            if (this.location == null) {
                return this.location;
            }
            try {
                URI uri = URIUtil.fromString((String)this.location);
                IPath path = new Path(uri.getPath()).removeLastSegments(1);
                this.relativepath = path.toString();
            }
            catch (URISyntaxException uRISyntaxException) {
                return this.location;
            }
        }
        return this.relativepath;
    }

    public URL getEntry(String path) {
        try {
            this.initBase();
            return new URL(this.base, path);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public ClassLoader getContextClassLoader() {
        return this.contextClassLoader;
    }
}

