/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy.internal.core;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.tools.event.spy.internal.core.CapturedEventFilterMatcher;
import org.eclipse.e4.tools.event.spy.internal.model.CapturedEvent;
import org.eclipse.e4.tools.event.spy.internal.model.CapturedEventFilter;
import org.eclipse.e4.ui.internal.workbench.UIEventPublisher;
import org.eclipse.e4.ui.services.internal.events.EventBroker;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventMonitor {
    private static Set<Integer> EVENT_HELPER_CLASSES = new HashSet<Integer>(){
        {
            this.add(UIEvents.class.getName().hashCode());
            this.add(UIEventPublisher.class.getName().hashCode());
        }
    };
    private Collection<CapturedEventFilter> filters;
    private final IEventBroker eventBroker;
    private NewEventListener listener;
    private CapturedEventFilterMatcher eventFilterMatcher;
    private final EventHandler eventHandler = new EventHandler(){

        public void handleEvent(Event event) {
            if (EventMonitor.this.listener == null) {
                return;
            }
            CapturedEvent capturedEvent = new CapturedEvent();
            capturedEvent.setTopic(event.getTopic());
            capturedEvent.setPublisherClassName(EventMonitor.this.getPublisherClassName());
            String[] stringArray = event.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String propertyName = stringArray[n2];
                Object value = event.getProperty(propertyName);
                capturedEvent.addParameter(propertyName, value);
                if (value != null && "ChangedElement".equals(propertyName)) {
                    capturedEvent.setChangedElementClassName(value.getClass().getName());
                }
                ++n2;
            }
            if (EventMonitor.this.shouldBeCaptured(capturedEvent)) {
                EventMonitor.this.listener.newEvent(capturedEvent);
            }
        }
    };

    public EventMonitor(IEventBroker eventBroker) {
        this.eventBroker = eventBroker;
    }

    public void start(String baseTopic, Collection<CapturedEventFilter> filters) {
        this.filters = filters;
        this.eventBroker.subscribe(baseTopic, this.eventHandler);
    }

    public void stop() {
        this.eventBroker.unsubscribe(this.eventHandler);
    }

    public void setNewEventListener(NewEventListener listener) {
        this.listener = listener;
    }

    private boolean shouldBeCaptured(CapturedEvent event) {
        if (this.filters != null) {
            Iterator<CapturedEventFilter> iter = this.filters.iterator();
            while (iter.hasNext()) {
                if (this.getEventFilterMatcher().matches(event, iter.next())) continue;
                return false;
            }
        }
        return true;
    }

    private String getPublisherClassName() {
        StackTraceElement[] items = Thread.currentThread().getStackTrace();
        boolean foundEventBroker = false;
        int i = 0;
        while (i < items.length) {
            String clsName = items[i].getClassName();
            if (!foundEventBroker && clsName.equals(EventBroker.class.getName())) {
                foundEventBroker = true;
            } else if (foundEventBroker && !EVENT_HELPER_CLASSES.contains(clsName.hashCode())) {
                return String.format("%s (%s:%d)", clsName, items[i].getMethodName(), items[i].getLineNumber());
            }
            ++i;
        }
        return "";
    }

    private CapturedEventFilterMatcher getEventFilterMatcher() {
        if (this.eventFilterMatcher == null) {
            this.eventFilterMatcher = new CapturedEventFilterMatcher();
        }
        return this.eventFilterMatcher;
    }

    public static interface NewEventListener {
        public void newEvent(CapturedEvent var1);
    }
}

