/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.event.spy.internal.model;

import org.eclipse.e4.tools.event.spy.internal.model.ItemToFilter;
import org.eclipse.e4.tools.event.spy.internal.model.Operator;
import org.eclipse.e4.tools.event.spy.internal.model.SpecialValue;

public class CapturedEventFilter {
    private static final String FILTER_AS_STRING_PATTERN = "Capture event when '%s' %s '%s'";
    private ItemToFilter itemToFilter;
    private Operator operator;
    private String value;

    public CapturedEventFilter(ItemToFilter itemToFilter, Operator operator, String value) {
        this.itemToFilter = itemToFilter;
        this.operator = operator;
        this.value = this.normalize(itemToFilter, value);
    }

    public ItemToFilter getItemToFilter() {
        return this.itemToFilter;
    }

    public void setItemToFilter(ItemToFilter itemToFilter) {
        this.itemToFilter = itemToFilter;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private String normalize(ItemToFilter itemToFilter, String value) {
        if (ItemToFilter.ParameterNameAndValue.equals((Object)itemToFilter)) {
            String[] splitted = value.split("=");
            if (splitted.length != 2) {
                throw new IllegalArgumentException("Invalid value format, it should be: " + String.format(SpecialValue.NameAndValue.toString(), "Name", "Value"));
            }
            return String.format(SpecialValue.NameAndValue.toString(), splitted[0].trim(), splitted[1].trim());
        }
        return value;
    }

    public String toString() {
        return String.format(FILTER_AS_STRING_PATTERN, new Object[]{this.itemToFilter, this.operator, this.value});
    }

    public int hashCode() {
        return (String.valueOf(this.value) + (Object)((Object)this.itemToFilter) + (Object)((Object)this.operator)).hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CapturedEventFilter && obj.hashCode() == this.hashCode();
    }
}

