/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.Iterator;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.jface.internal.databinding.provisional.viewers.ViewerLabelProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ListeningLabelProvider
extends ViewerLabelProvider {
    private ISetChangeListener<Object> listener = new ISetChangeListener<Object>(){

        public void handleSetChange(SetChangeEvent<Object> event) {
            Iterator it = event.diff.getAdditions().iterator();
            while (it.hasNext()) {
                ListeningLabelProvider.this.addListenerTo(it.next());
            }
            it = event.diff.getRemovals().iterator();
            while (it.hasNext()) {
                ListeningLabelProvider.this.removeListenerFrom(it.next());
            }
        }
    };
    private IObservableSet<Object> items;

    public ListeningLabelProvider(IObservableSet<Object> itemsThatNeedLabels) {
        this.items = itemsThatNeedLabels;
        this.items.addSetChangeListener(this.listener);
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            this.addListenerTo(it.next());
        }
    }

    protected abstract void removeListenerFrom(Object var1);

    protected abstract void addListenerTo(Object var1);

    @Override
    public void dispose() {
        Iterator iter = this.items.iterator();
        while (iter.hasNext()) {
            this.removeListenerFrom(iter.next());
        }
        this.items.removeSetChangeListener(this.listener);
        super.dispose();
    }
}

