/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class Snippet0xffffffff {
    public static void main(String[] args) {
        ViewModel viewModel = new ViewModel();
        Shell shell = new View(viewModel).createShell();
        Display display = Display.getCurrent();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        System.out.println("person.getName() = " + viewModel.getPerson().getName());
    }

    public static abstract class AbstractModelObject {
        private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }

        public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }

        public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
            this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    static class Person
    extends AbstractModelObject {
        String name = "John Smith";

        Person() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    static class View {
        private ViewModel viewModel;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            final Display display = Display.getCurrent();
            Shell shell = new Shell(display);
            shell.setLayout((Layout)new RowLayout(512));
            final Text name = new Text((Composite)shell, 2048);
            name.setText(this.viewModel.getPerson().getName());
            name.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String text = name.getText();
                    View.this.viewModel.getPerson().setName(text);
                }
            });
            this.viewModel.person.addPropertyChangeListener("name", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            String newName = View.this.viewModel.person.getName();
                            name.setText(newName);
                        }
                    });
                }
            });
            shell.pack();
            shell.open();
            return shell;
        }
    }

    static class ViewModel {
        private Person person = new Person();

        ViewModel() {
        }

        public Person getPerson() {
            return this.person;
        }
    }
}

