/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.util.internal.session;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.platform.discovery.util.internal.session.ISession;
import org.eclipse.platform.discovery.util.internal.session.ISessionFactory;
import org.eclipse.platform.discovery.util.internal.session.ISessionManager;

public class SessionManager<T extends ISession<?>>
implements ISessionManager<T> {
    private final ISessionFactory<T> factory;
    private Map<String, T> sessions;

    public SessionManager(ISessionFactory<T> factory) {
        this.factory = factory;
        this.sessions = new IdentityHashMap<String, T>();
    }

    @Override
    public T session(String sessionId, int historySize) {
        ISession foundSession = (ISession)this.sessions.get(sessionId);
        if (foundSession != null) {
            return (T)foundSession;
        }
        T newSession = this.factory.newSession(sessionId, historySize);
        this.sessions.put(sessionId, newSession);
        return newSession;
    }

    @Override
    public int sessionCount() {
        return this.sessions.size();
    }
}

