/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.tools.emf.ui.common.IClassContributionProvider;
import org.eclipse.e4.tools.emf.ui.internal.Messages;
import org.eclipse.e4.tools.emf.ui.internal.common.ClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.ContributionDataFile;
import org.eclipse.e4.tools.emf.ui.internal.common.component.dialogs.FilteredContributionDialog;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.TargetPlatformClassContributionCollector;
import org.eclipse.e4.tools.emf.ui.internal.common.resourcelocator.TargetPlatformContributionCollector;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public class ContributionClassDialog
extends FilteredContributionDialog {
    private IProject project;
    private MApplicationElement contribution;
    private EditingDomain editingDomain;
    private EStructuralFeature feature;
    private Messages Messages;

    public ContributionClassDialog(Shell parentShell, IEclipseContext context, IProject project, EditingDomain editingDomain, MApplicationElement contribution, EStructuralFeature feature, Messages Messages2) {
        super(parentShell, context);
        this.project = project;
        this.contribution = contribution;
        this.editingDomain = editingDomain;
        this.feature = feature;
        this.Messages = Messages2;
    }

    @Override
    protected Image getTitleImage() {
        return new Image((Device)this.getShell().getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("/icons/full/wizban/newclass_wiz.png"));
    }

    protected void okPressed() {
        IClassContributionProvider.ContributionData cd;
        ContributionDataFile cdf;
        IFile file;
        IStructuredSelection s = (IStructuredSelection)this.getViewer().getSelection();
        if (!s.isEmpty() && (file = this.checkResourceAccessible(cdf = new ContributionDataFile(cd = (IClassContributionProvider.ContributionData)s.getFirstElement()), cd.installLocation)) != null) {
            String uri;
            Command cmd;
            if (file instanceof ContributionDataFile) {
                cdf = (ContributionDataFile)file;
                cd = cdf.getContributionData();
            }
            if ((cmd = SetCommand.create((EditingDomain)this.editingDomain, (Object)this.contribution, (Object)this.feature, (Object)(uri = "bundleclass://" + cd.bundleName + "/" + cd.className))).canExecute()) {
                this.editingDomain.getCommandStack().execute(cmd);
                super.okPressed();
            }
        }
    }

    @Override
    protected ClassContributionCollector getCollector() {
        switch (this.getScope()) {
            case WORKSPACE: 
            case TARGET_PLATFORM: {
                if (this.collector instanceof TargetPlatformContributionCollector) break;
                this.collector = TargetPlatformClassContributionCollector.getInstance();
                break;
            }
            case PROJECT: {
                Bundle bundle = FrameworkUtil.getBundle(ContributionClassDialog.class);
                BundleContext context = bundle.getBundleContext();
                ServiceReference ref = context.getServiceReference(ClassContributionCollector.class.getName());
                if (ref != null) {
                    this.collector = (ClassContributionCollector)context.getService(ref);
                    break;
                }
                this.collector = null;
                break;
            }
            default: {
                this.collector = null;
            }
        }
        return this.collector;
    }

    @Override
    protected String getShellTitle() {
        return this.Messages.ContributionClassDialog_DialogTitle;
    }

    @Override
    protected String getDialogTitle() {
        return this.Messages.ContributionClassDialog_DialogTitle;
    }

    @Override
    protected String getDialogMessage() {
        return this.Messages.ContributionClassDialog_DialogMessage;
    }

    @Override
    protected String getResourceNameText() {
        return this.Messages.ContributionClassDialog_Label_Classname;
    }

    @Override
    protected String getFilterTextMessage() {
        return this.Messages.ContributionClassDialog_FilterText_Message;
    }
}

