/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.spy;

import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.commands.MBindingContext;
import org.eclipse.e4.ui.model.application.commands.MBindingTable;
import org.eclipse.e4.ui.model.application.commands.MCommand;
import org.eclipse.e4.ui.model.application.commands.MCommandParameter;
import org.eclipse.e4.ui.model.application.commands.MHandler;
import org.eclipse.e4.ui.model.application.commands.MKeyBinding;
import org.eclipse.e4.ui.model.application.commands.MParameter;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class SpyProcessor {
    static final String SPY_TAG = "Spy";
    public static final String SPY_COMMAND = "org.eclipse.e4.tools.spy.command";
    public static final String SPY_COMMAND_PARAM = "org.eclipse.e4.tools.spy.command.partID";
    private static final String SPY_HANDLER = "org.eclipse.e4.tools.spy.handler";
    private static final String E4_SPIES_BINDING_TABLE = "org.eclipse.e4.tools.spy.bindings";
    @Inject
    MApplication application;
    @Inject
    EModelService modelService;
    @Inject
    Logger log;

    @Execute
    public void process(IExtensionRegistry extRegistry) {
        MCommand command = this.getOrCreateSpyCommand();
        IConfigurationElement[] iConfigurationElementArray = extRegistry.getConfigurationElementsFor("org.eclipse.e4.tools.spy.spyPart");
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            String partName = e.getAttribute("name");
            String shortCut = e.getAttribute("shortcut");
            String iconPath = e.getAttribute("icon");
            e.getAttribute("description");
            Bundle b = Platform.getBundle((String)e.getNamespaceIdentifier());
            String partID = e.getAttribute("part");
            try {
                Class partClass = b.loadClass(partID);
                this.bindSpyKeyBinding(shortCut, command, partID);
                this.addSpyPartDescriptor(partID, partName, iconPath, partClass);
            }
            catch (InvalidRegistryObjectException e1) {
                e1.printStackTrace();
            }
            catch (ClassNotFoundException e1) {
                this.log.error("The class '" + partID + "' can not be instantiated. Check name or launch config");
                e1.printStackTrace();
            }
            ++n2;
        }
    }

    public MCommand getOrCreateSpyCommand() {
        for (MCommand cmd : this.application.getCommands()) {
            if (!SPY_COMMAND.equals(cmd.getElementId())) continue;
            return cmd;
        }
        MCommand command = (MCommand)this.modelService.createModelElement(MCommand.class);
        command.setElementId(SPY_COMMAND);
        command.setCommandName("Open a spy");
        String contributorURI = "platform:/plugin/" + FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
        command.setContributorURI(contributorURI);
        command.setDescription("Open a spy in the E4 spy window");
        MCommandParameter cp = (MCommandParameter)this.modelService.createModelElement(MCommandParameter.class);
        cp.setElementId(SPY_COMMAND_PARAM);
        cp.setName("viewPart");
        cp.setContributorURI(contributorURI);
        command.getParameters().add(cp);
        this.application.getCommands().add(command);
        for (MHandler hdl : this.application.getHandlers()) {
            if (!SPY_HANDLER.equals(hdl.getElementId())) continue;
            return command;
        }
        MHandler handler = (MHandler)this.modelService.createModelElement(MHandler.class);
        handler.setElementId(SPY_HANDLER);
        handler.setContributionURI("bundleclass://org.eclipse.e4.tools.spy/org.eclipse.e4.tools.spy.SpyHandler");
        handler.setContributorURI("platform:/plugin/org.eclipse.e4.tools.spy");
        this.application.getHandlers().add(handler);
        handler.setCommand(command);
        return command;
    }

    public void bindSpyKeyBinding(String keySequence, MCommand cmd, String paramViewId) {
        MBindingTable spyBindingTable = null;
        for (MBindingTable bt : this.application.getBindingTables()) {
            if (!E4_SPIES_BINDING_TABLE.equals(bt.getElementId())) continue;
            spyBindingTable = bt;
        }
        if (spyBindingTable == null) {
            MBindingContext bc = null;
            List bindingContexts = this.application.getBindingContexts();
            if (bindingContexts.size() == 0) {
                bc = (MBindingContext)this.modelService.createModelElement(MBindingContext.class);
                bc.setElementId("org.eclipse.ui.contexts.window");
            } else {
                Iterator iterator = bindingContexts.iterator();
                while (iterator.hasNext()) {
                    MBindingContext aBindingContext;
                    bc = aBindingContext = (MBindingContext)iterator.next();
                    if ("org.eclipse.ui.contexts.dialogAndWindow".equals(aBindingContext.getElementId())) break;
                }
            }
            spyBindingTable = (MBindingTable)this.modelService.createModelElement(MBindingTable.class);
            spyBindingTable.setElementId(E4_SPIES_BINDING_TABLE);
            spyBindingTable.setBindingContext(bc);
            this.application.getBindingTables().add(spyBindingTable);
        }
        for (MKeyBinding kb : spyBindingTable.getBindings()) {
            if (!keySequence.equals(kb.getKeySequence())) continue;
            if (kb.getCommand().getElementId().equals(cmd.getElementId())) {
                return;
            }
            System.out.println("WARNING : Cannot bind the command '" + cmd.getElementId() + "' to the keySequence : " + keySequence + " because the command " + kb.getCommand().getElementId() + " is already bound !");
            return;
        }
        MKeyBinding binding = (MKeyBinding)this.modelService.createModelElement(MKeyBinding.class);
        binding.setElementId(String.valueOf(cmd.getElementId()) + ".binding");
        binding.setContributorURI(cmd.getContributorURI());
        binding.setKeySequence(keySequence);
        MParameter p = (MParameter)this.modelService.createModelElement(MParameter.class);
        p.setName(SPY_COMMAND_PARAM);
        p.setValue(paramViewId);
        binding.getParameters().add(p);
        spyBindingTable.getBindings().add(binding);
        binding.setCommand(cmd);
    }

    public void addSpyPartDescriptor(String partId, String partLabel, String iconPath, Class<?> spyPartClass) {
        for (MPartDescriptor mp : this.application.getDescriptors()) {
            if (!partId.equals(mp.getElementId())) continue;
            return;
        }
        MPartDescriptor descriptor = (MPartDescriptor)this.modelService.createModelElement(MPartDescriptor.class);
        descriptor.setCategory("org.eclipse.e4.secondaryDataStack");
        descriptor.setElementId(partId);
        descriptor.getTags().add("View");
        descriptor.getTags().add(SPY_TAG);
        descriptor.getTags().add("categoryTag:General");
        descriptor.setLabel(partLabel);
        descriptor.setCloseable(true);
        String bundleId = FrameworkUtil.getBundle(spyPartClass).getSymbolicName();
        descriptor.setContributionURI("bundleclass://" + bundleId + "/" + spyPartClass.getCanonicalName());
        String contributorURI = "platform:/plugin/" + bundleId;
        descriptor.setContributorURI(contributorURI);
        descriptor.setIconURI(String.valueOf(contributorURI) + "/" + iconPath);
        this.application.getDescriptors().add(descriptor);
    }
}

