/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.list;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.databinding.observable.DecoratingObservable;
import org.eclipse.core.databinding.observable.ListenerList;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListListenerManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnmodifiableObservableList<E>
extends DecoratingObservable
implements IObservableList<E> {
    private MyListenerManager<?> wrapper;
    private Class<E> elementType;
    private ListenerList<IListChangeListener<E>> listChangeListenerList = null;

    public UnmodifiableObservableList(IObservableList<E> decoratedList) {
        super(decoratedList, false);
        this.wrapper = this.wrap(decoratedList);
        this.elementType = decoratedList.getElementClass();
    }

    private <E2 extends E> MyListenerManager<E2> wrap(IObservableList<E2> decoratedList) {
        return new MyListenerManager<E2>(decoratedList);
    }

    public UnmodifiableObservableList(IObservableList<? extends E> decoratedList, Class<E> elementType) {
        super(decoratedList, false);
        this.wrapper = this.wrap(decoratedList);
        this.elementType = elementType;
    }

    @Override
    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        this.getterCalled();
        return this.wrapper.decoratedList.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.getterCalled();
        return this.wrapper.decoratedList.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        this.getterCalled();
        return this.wrapper.decoratedList.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        this.getterCalled();
        final Iterator decoratedIterator = this.wrapper.decoratedList.iterator();
        return new Iterator<E>(){

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                UnmodifiableObservableList.this.getterCalled();
                return decoratedIterator.hasNext();
            }

            @Override
            public E next() {
                UnmodifiableObservableList.this.getterCalled();
                return decoratedIterator.next();
            }
        };
    }

    @Override
    public E move(int oldIndex, int newIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        this.getterCalled();
        return this.wrapper.decoratedList.size();
    }

    @Override
    public Object[] toArray() {
        this.getterCalled();
        return this.wrapper.decoratedList.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.getterCalled();
        return this.wrapper.decoratedList.toArray(a);
    }

    @Override
    public Object getElementType() {
        return this.wrapper.decoratedList.getElementType();
    }

    @Override
    public Class<E> getElementClass() {
        return this.elementType;
    }

    @Override
    public boolean equals(Object obj) {
        this.getterCalled();
        if (this == obj) {
            return true;
        }
        return this.wrapper.decoratedList.equals(obj);
    }

    @Override
    public int hashCode() {
        this.getterCalled();
        return this.wrapper.decoratedList.hashCode();
    }

    public String toString() {
        this.getterCalled();
        return this.wrapper.decoratedList.toString();
    }

    @Override
    public synchronized void addListChangeListener(IListChangeListener<E> listener) {
        this.addListener(this.getListChangeListenerList(), listener);
    }

    @Override
    public synchronized void removeListChangeListener(IListChangeListener<E> listener) {
        if (this.listChangeListenerList != null) {
            this.removeListener(this.listChangeListenerList, listener);
        }
    }

    private ListenerList<IListChangeListener<E>> getListChangeListenerList() {
        if (this.listChangeListenerList == null) {
            this.listChangeListenerList = new ListenerList();
        }
        return this.listChangeListenerList;
    }

    @Override
    protected boolean hasListeners() {
        return this.listChangeListenerList != null && this.listChangeListenerList.hasListeners() || super.hasListeners();
    }

    protected void fireListChange(ListDiff<? extends E> diff) {
        super.fireChange();
        if (this.listChangeListenerList != null) {
            this.listChangeListenerList.fireEvent(new ListChangeEvent<E>(this, diff));
        }
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireListChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        this.wrapper.addListener();
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        this.wrapper.removeListener();
    }

    protected void handleListChange(ListChangeEvent<E> event) {
        this.fireListChange(event.diff);
    }

    @Override
    public E get(int index) {
        this.getterCalled();
        return this.wrapper.decoratedList.get(index);
    }

    @Override
    public int indexOf(Object o) {
        this.getterCalled();
        return this.wrapper.decoratedList.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        this.getterCalled();
        return this.wrapper.decoratedList.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        this.getterCalled();
        final ListIterator iterator = this.wrapper.decoratedList.listIterator(index);
        return new ListIterator<E>(){

            @Override
            public void add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.hasNext();
            }

            @Override
            public boolean hasPrevious() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.hasPrevious();
            }

            @Override
            public E next() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.next();
            }

            @Override
            public int nextIndex() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.nextIndex();
            }

            @Override
            public E previous() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.previous();
            }

            @Override
            public int previousIndex() {
                UnmodifiableObservableList.this.getterCalled();
                return iterator.previousIndex();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(E o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        this.getterCalled();
        return Collections.unmodifiableList(this.wrapper.decoratedList.subList(fromIndex, toIndex));
    }

    @Override
    public synchronized void dispose() {
        if (this.wrapper != null) {
            this.wrapper.removeListener();
        }
        this.wrapper = null;
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MyListenerManager<E2 extends E>
    extends ListListenerManager<E2> {
        public MyListenerManager(IObservableList<E2> decoratedList) {
            super(decoratedList);
        }

        @Override
        public void handleListChange(ListChangeEvent<E2> event) {
            ListChangeEvent event2 = new ListChangeEvent(UnmodifiableObservableList.this, event.diff);
            UnmodifiableObservableList.this.handleListChange(event2);
        }
    }
}

