/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.beans;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.masterdetail.MasterDetailObservables;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.util.Policy;
import org.eclipse.core.internal.databinding.beans.BeanObservableListDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableMapDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableSetDecorator;
import org.eclipse.core.internal.databinding.beans.BeanObservableValueDecorator;
import org.eclipse.core.internal.databinding.beans.BeanPropertyHelper;
import org.eclipse.core.internal.databinding.beans.Util;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeansObservables {
    public static final boolean DEBUG = true;

    public static <S> IObservableValue<?> observeValue(S bean, String propertyName) {
        return BeansObservables.observeValue(Realm.getDefault(), bean, propertyName);
    }

    public static <S, T> IObservableValue<T> observeValue(S bean, String propertyName, Class<T> valueType) {
        return BeansObservables.observeValue(Realm.getDefault(), bean, propertyName, valueType);
    }

    public static <S> IObservableValue<?> observeValue(Realm realm, S bean, String propertyName) {
        return BeansObservables.observeValue(realm, Util.getClass(bean), bean, propertyName);
    }

    private static <S, S2 extends S> IObservableValue<?> observeValue(Realm realm, Class<S2> beanClass, S bean, String propertyName) {
        return BeanProperties.value(beanClass, propertyName).observe(realm, beanClass.cast(bean));
    }

    public static <S, T> IObservableValue<T> observeValue(Realm realm, S bean, String propertyName, Class<T> valueType) {
        return BeanProperties.value(Util.getClass(bean), propertyName, valueType).observe(realm, bean);
    }

    public static <S> IObservableMap<S, Object> observeMap(IObservableSet<S> domain, String propertyName) {
        return BeanProperties.value(propertyName).observeDetail(domain);
    }

    public static <S> IObservableMap<S, ?> observeMap(IObservableSet<S> domain, Class<S> beanClass, String propertyName) {
        return BeanProperties.value(beanClass, propertyName).observeDetail(domain);
    }

    public static <S> IObservableMap<?, ?> observeMap(Realm realm, S bean, String propertyName) {
        return BeansObservables.observeMap(realm, bean, propertyName, null, null);
    }

    public static <S, K, V> IObservableMap<K, V> observeMap(Realm realm, S bean, String propertyName, Class<K> keyType, Class<V> valueType) {
        Class<S> beanClass = Util.getClass(bean);
        return BeanProperties.map(beanClass, propertyName, keyType, valueType).observe(realm, bean);
    }

    public static <S> IObservableMap<?, ?> observeMap(S bean, String propertyName) {
        return BeansObservables.observeMap(Realm.getDefault(), bean, propertyName, null, null);
    }

    public static <S, K, V> IObservableMap<K, V> observeMap(S bean, String propertyName, Class<K> keyType, Class<V> valueType) {
        return BeansObservables.observeMap(Realm.getDefault(), bean, propertyName, keyType, valueType);
    }

    public static <S> IObservableMap<?, ?>[] observeMaps(IObservableSet<S> domain, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = BeansObservables.observeMap(domain, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static <S> List<IObservableMap<S, ?>> observeMaps2(IObservableSet<S> domain, String[] propertyNames) {
        ArrayList result = new ArrayList(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            result.add(BeansObservables.observeMap(domain, propertyNames[i]));
            ++i;
        }
        return result;
    }

    public static IObservableMap[] observeMaps(IObservableSet domain, Class beanClass, String[] propertyNames) {
        IObservableMap[] result = new IObservableMap[propertyNames.length];
        int i = 0;
        while (i < propertyNames.length) {
            result[i] = BeansObservables.observeMap(domain, beanClass, propertyNames[i]);
            ++i;
        }
        return result;
    }

    public static <S> List<IObservableMap<S, ?>> observeMaps2(IObservableSet<S> domain, Class<S> beanClass, String[] propertyNames) {
        ArrayList result = new ArrayList(propertyNames.length);
        int i = 0;
        while (i < propertyNames.length) {
            result.add(BeansObservables.observeMap(domain, beanClass, propertyNames[i]));
            ++i;
        }
        return result;
    }

    public static <S, E> IObservableList<E> observeList(Realm realm, S bean, String propertyName) {
        return BeansObservables.observeList(realm, bean, propertyName, null);
    }

    public static <S, E> IObservableList<E> observeList(S bean, String propertyName) {
        return BeansObservables.observeList(Realm.getDefault(), bean, propertyName);
    }

    public static <E> IObservableList<E> observeList(Realm realm, Object bean, String propertyName, Class<E> elementType) {
        return BeanProperties.list(bean.getClass(), propertyName, elementType).observe(realm, bean);
    }

    public static <E> IObservableList<E> observeList(Object bean, String propertyName, Class<E> elementType) {
        return BeansObservables.observeList(Realm.getDefault(), bean, propertyName, elementType);
    }

    public static <S, E> IObservableSet<E> observeSet(Realm realm, S bean, String propertyName) {
        return BeansObservables.observeSet(realm, bean, propertyName, null);
    }

    public static <S, E> IObservableSet<E> observeSet(S bean, String propertyName) {
        return BeansObservables.observeSet(Realm.getDefault(), bean, propertyName);
    }

    public static IObservableFactory<Object, IObservableValue<Object>> valueFactory(Realm realm, String propertyName) {
        return BeanProperties.value(propertyName).valueFactory(realm);
    }

    public static IObservableFactory<Object, IObservableValue<Object>> valueFactory(String propertyName) {
        return BeansObservables.valueFactory(Realm.getDefault(), propertyName);
    }

    public static <S, E> IObservableFactory<S, IObservableList<E>> listFactory(Realm realm, String propertyName, Class<E> elementType) {
        return BeanProperties.list(propertyName, elementType).listFactory(realm);
    }

    public static <S, E> IObservableFactory<S, IObservableList<E>> listFactory(String propertyName, Class<E> elementType) {
        return BeansObservables.listFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static <S, E> IObservableFactory<S, IObservableSet<E>> setFactory(Realm realm, String propertyName) {
        return BeanProperties.set(propertyName).setFactory(realm);
    }

    public static <S, E> IObservableFactory<S, IObservableSet<E>> setFactory(String propertyName) {
        return BeansObservables.setFactory(Realm.getDefault(), propertyName);
    }

    public static <M, T> IObservableValue<T> observeDetailValue(Realm realm, IObservableValue<M> master, String propertyName, Class<T> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableValue value = MasterDetailObservables.detailValue(master, (IObservableFactory)BeanProperties.value(propertyName, propertyType).valueFactory(realm), propertyType);
        return new BeanObservableValueDecorator(value, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    static void warnIfDifferentRealms(Realm detailRealm, Realm masterRealm) {
        if (!Util.equals(detailRealm, masterRealm)) {
            Throwable throwable = new Throwable();
            throwable.fillInStackTrace();
            String message = "Detail realm (" + detailRealm + ") not equal to master realm (" + masterRealm + ")";
            Policy.getLog().log((IStatus)new Status(2, "org.eclipse.core.databinding", message, throwable));
        }
    }

    public static <M, T> IObservableValue<T> observeDetailValue(IObservableValue<M> master, String propertyName, Class<T> propertyType) {
        Class beanClass = master.getValueClass();
        return BeansObservables.observeDetailValue(master, beanClass, propertyName, propertyType);
    }

    public static <M, T> IObservableValue<T> observeDetailValue(Realm realm, IObservableValue<M> master, Class<M> masterType, String propertyName, Class<T> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        Assert.isNotNull(masterType, (String)"masterType cannot be null");
        IObservableValue value = MasterDetailObservables.detailValue(master, (IObservableFactory)BeanProperties.value(masterType, propertyName, propertyType).valueFactory(realm), propertyType);
        return new BeanObservableValueDecorator(value, BeanPropertyHelper.getPropertyDescriptor(masterType, propertyName));
    }

    public static <M, T> IObservableValue<T> observeDetailValue(IObservableValue<M> master, Class<M> masterType, String propertyName, Class<T> propertyType) {
        return BeanProperties.value(masterType, propertyName, propertyType).observeDetail(master);
    }

    public static <M, E> IObservableList<E> observeDetailList(Realm realm, IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableList observableList = MasterDetailObservables.detailList(master, (IObservableFactory)BeanProperties.list(propertyName, propertyType).listFactory(realm), propertyType);
        return new BeanObservableListDecorator(observableList, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M, E> IObservableList<E> observeDetailList(IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        Class beanClass = master.getValueClass();
        return BeanProperties.list(beanClass, propertyName, propertyType).observeDetail(master);
    }

    public static <M, E> IObservableSet<E> observeDetailSet(Realm realm, IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableSet observableSet = MasterDetailObservables.detailSet(master, (IObservableFactory)BeanProperties.set(propertyName, propertyType).setFactory(realm), propertyType);
        return new BeanObservableSetDecorator(observableSet, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M, E> IObservableSet<E> observeDetailSet(IObservableValue<M> master, String propertyName, Class<E> propertyType) {
        Class beanClass = master.getValueClass();
        return BeanProperties.set(beanClass, propertyName, propertyType).observeDetail(master);
    }

    public static <M, K, V> IObservableMap<K, V> observeDetailMap(Realm realm, IObservableValue<M> master, String propertyName) {
        BeansObservables.warnIfDifferentRealms(realm, master.getRealm());
        IObservableMap observableMap = MasterDetailObservables.detailMap(master, (IObservableFactory)BeanProperties.map(propertyName).mapFactory(realm));
        return new BeanObservableMapDecorator(observableMap, BeanPropertyHelper.getValueTypePropertyDescriptor(master, propertyName));
    }

    public static <M, K, V> IObservableMap<K, V> observeDetailMap(IObservableValue<M> master, String propertyName) {
        Class beanClass = master.getValueClass();
        return BeanProperties.map(beanClass, propertyName).observeDetail(master);
    }

    public static <S, E> IObservableSet<E> observeSet(Realm realm, S bean, String propertyName, Class<E> elementType) {
        Class<S> beanClass = Util.getClass(bean);
        return BeanProperties.set(beanClass, propertyName, elementType).observe(realm, bean);
    }

    public static <S, E> IObservableSet<E> observeSet(S bean, String propertyName, Class<E> elementType) {
        return BeansObservables.observeSet(Realm.getDefault(), bean, propertyName, elementType);
    }

    public static <E> IObservableFactory<Object, IObservableSet<E>> setFactory(Realm realm, String propertyName, Class<E> elementType) {
        return BeanProperties.set(propertyName, elementType).setFactory(realm);
    }

    public static <E> IObservableFactory<Object, IObservableSet<E>> setFactory(String propertyName, Class<E> elementType) {
        return BeansObservables.setFactory(Realm.getDefault(), propertyName, elementType);
    }

    public static <S> IObservableFactory<IObservableSet<S>, IObservableMap<S, ?>> setToMapFactory(final Class<S> beanClass, final String propertyName) {
        return new IObservableFactory<IObservableSet<S>, IObservableMap<S, ?>>(){

            public IObservableMap<S, ?> createObservable(IObservableSet<S> target) {
                return BeansObservables.observeMap(target, beanClass, propertyName);
            }
        };
    }

    public static <T, K, V> IObservableFactory<T, IObservableMap<K, V>> mapPropertyFactory(Realm realm, String propertyName) {
        return BeanProperties.map(propertyName).mapFactory(realm);
    }

    public static <T, K, V> IObservableFactory<T, IObservableMap<K, V>> mapPropertyFactory(String propertyName) {
        return BeansObservables.mapPropertyFactory(Realm.getDefault(), propertyName);
    }
}

