/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.internal.resources.semantic.ISemanticFileStoreInternal;
import org.eclipse.core.internal.resources.semantic.Messages;
import org.eclipse.core.internal.resources.semantic.SemanticFileStore;
import org.eclipse.core.internal.resources.semantic.SemanticFileSystemLog;
import org.eclipse.core.internal.resources.semantic.SemanticMetadataPersistenceManager;
import org.eclipse.core.internal.resources.semantic.SemanticQueryParser;
import org.eclipse.core.internal.resources.semantic.SemanticResourcesPlugin;
import org.eclipse.core.internal.resources.semantic.SfsTraceLocation;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.ResourceTreeNode;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.SemanticResourceDBFactory;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeNodeType;
import org.eclipse.core.internal.resources.semantic.model.SemanticResourceDB.TreeRoot;
import org.eclipse.core.internal.resources.semantic.util.ISemanticFileSystemLog;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticURILocatorService;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProvider;
import org.eclipse.core.resources.semantic.spi.ISemanticContentProviderFederation;
import org.eclipse.core.resources.semantic.spi.ISemanticFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SemanticFileSystem
extends FileSystem
implements ISemanticFileSystem {
    private static final String METADATA_FILENAME = "metadata.xmi";
    static final IPath EMPTY = new Path("");
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwl.readLock();
    private final Lock writeLock = this.rwl.writeLock();
    private final ISemanticFileSystemLog log = new SemanticFileSystemLog();
    SemanticMetadataPersistenceManager mgr;
    private File metadataFolder;
    private SemanticURILocatorService uriLocator;

    public SemanticFileSystem() {
        this.init(null);
    }

    public SemanticFileSystem(File rootFolder) {
        this.init(rootFolder);
    }

    @Override
    public String[] getRootNames() throws CoreException {
        if (this.mgr.getSemanticDB() == null) {
            throw new SemanticResourceException(SemanticResourceStatusCode.SFS_DB_NOT_INITIALIZED, EMPTY, Messages.SemanticFileSystem_NotInitialized_XMSG);
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            this.lockForRead();
            EList<TreeRoot> roots = this.mgr.getSemanticDB().getRoots();
            for (TreeRoot treeRoot : roots) {
                result.add(treeRoot.getName());
            }
        }
        finally {
            this.unlockForRead();
        }
        return result.toArray(new String[0]);
    }

    public void requestFlush(boolean force, ResourceTreeNode node) throws CoreException {
        node = this.getHighestParent(node);
        this.saveSemanticDB(node.getName());
    }

    public ResourceTreeNode getHighestParent(ResourceTreeNode node) {
        ResourceTreeNode parent = node.getParent();
        while (parent != null) {
            node = parent;
            parent = node.getParent();
        }
        return node;
    }

    public IFileStore getStore(URI uri) {
        if ("semanticfs".equals(uri.getScheme())) {
            return this.getFileStoreImplementation(uri);
        }
        return EFS.getNullFileSystem().getStore(uri);
    }

    IFileStore getFileStoreImplementation(String pathString, String queryString) {
        Path path = pathString != null ? new Path(null, pathString) : Path.EMPTY;
        if (this.mgr.getSemanticDB() == null) {
            return EFS.getNullFileSystem().getStore((IPath)path);
        }
        if (path.segmentCount() > 0) {
            SemanticQueryParser parser;
            ISemanticFileStore store;
            try {
                this.lockForWrite();
                EList<TreeRoot> roots = this.mgr.getSemanticDB().getRoots();
                TreeRoot treeRoot = null;
                for (TreeRoot root : roots) {
                    if (!path.segment(0).equals(root.getName())) continue;
                    if (path.segmentCount() == 1) {
                        ISemanticFileStore iSemanticFileStore = this.getStore(root);
                        return iSemanticFileStore;
                    }
                    treeRoot = root;
                    break;
                }
                if (treeRoot == null) {
                    if (path.segmentCount() == 1) {
                        treeRoot = this.createRootNode(path.segment(0), queryString);
                        ISemanticFileStore iSemanticFileStore = this.getStore(treeRoot);
                        return iSemanticFileStore;
                    }
                    treeRoot = this.createRootNode(path.segment(0));
                }
                store = (ISemanticFileStore)this.getFileStoreRecursive((IPath)path, treeRoot, queryString);
            }
            finally {
                this.unlockForWrite();
            }
            if (!store.isExists() && queryString != null && (parser = new SemanticQueryParser(queryString)).getShouldCreate()) {
                try {
                    if (parser.getType().equals((Object)TreeNodeType.FOLDER) || parser.getType().equals((Object)TreeNodeType.PROJECT)) {
                        store.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
                    } else if (parser.getType().equals((Object)TreeNodeType.FILE)) {
                        ISemanticFileStore parent = (ISemanticFileStore)store.getParent();
                        parent.mkdir(0, (IProgressMonitor)new NullProgressMonitor());
                        ((ISemanticFileStoreInternal)((Object)parent)).addResource(path.lastSegment(), false, parser.getProviderID(), null, (IProgressMonitor)new NullProgressMonitor());
                        ISemanticFileStoreInternal child = ((ISemanticFileStoreInternal)((Object)parent)).getChildResource(path.lastSegment());
                        child.setRemoteURI(new URI(parser.getURI()), (IProgressMonitor)new NullProgressMonitor());
                    }
                    return store;
                }
                catch (CoreException coreException) {
                    return EFS.getNullFileSystem().getStore((IPath)path);
                }
                catch (URISyntaxException uRISyntaxException) {
                    return EFS.getNullFileSystem().getStore((IPath)path);
                }
            }
            return store;
        }
        return EFS.getNullFileSystem().getStore((IPath)path);
    }

    private IFileStore getFileStoreImplementation(URI uri) {
        String pathString = uri.getPath();
        String queryString = uri.getQuery();
        return this.getFileStoreImplementation(pathString, queryString);
    }

    private IFileStore getFileStoreRecursive(IPath path, ResourceTreeNode rootNode, String queryString) {
        String[] segments = path.segments();
        ResourceTreeNode currentNode = rootNode;
        boolean ready = true;
        int i = 1;
        while (i < segments.length) {
            String name = segments[i];
            EList<ResourceTreeNode> children = currentNode.getChildren();
            boolean found = false;
            for (ResourceTreeNode resourceTreeNode : children) {
                if (!resourceTreeNode.getName().equals(name)) continue;
                currentNode = resourceTreeNode;
                found = true;
                break;
            }
            if (!found) {
                ready = false;
                break;
            }
            ++i;
        }
        if (ready) {
            return this.getStore(currentNode);
        }
        ResourceTreeNode newNode = this.createNonExistingNode(path);
        if (queryString != null) {
            SemanticQueryParser parser = new SemanticQueryParser(queryString);
            this.applyQueryParameters(newNode, parser);
        }
        return this.getStore(newNode);
    }

    ResourceTreeNode getParentNode(ResourceTreeNode childNode) {
        try {
            int idx;
            this.lockForRead();
            if (childNode.isExists()) {
                ResourceTreeNode resourceTreeNode = childNode.getParent();
                return resourceTreeNode;
            }
            if (childNode.getPath() != null && (idx = childNode.getPath().lastIndexOf("/")) >= 0) {
                String parentPath = childNode.getPath().substring(0, idx);
                ResourceTreeNode resourceTreeNode = this.getNodeByPath(parentPath);
                return resourceTreeNode;
            }
        }
        finally {
            this.unlockForRead();
        }
        return null;
    }

    public List<ResourceTreeNode> getNodesByPath(String pathString) {
        ArrayList<ResourceTreeNode> nodes = new ArrayList<ResourceTreeNode>();
        Path path = new Path(null, pathString);
        if (path.segmentCount() > 0) {
            try {
                this.lockForRead();
                if (this.mgr.getSemanticDB() != null) {
                    EList<TreeRoot> roots = this.mgr.getSemanticDB().getRoots();
                    for (TreeRoot treeRoot : roots) {
                        if (!path.segment(0).equals(treeRoot.getName())) continue;
                        nodes.add(treeRoot);
                        if (path.segmentCount() == 1) {
                            ArrayList<ResourceTreeNode> arrayList = nodes;
                            return arrayList;
                        }
                        ResourceTreeNode currentNode = treeRoot;
                        boolean withinExistingTree = true;
                        int i = 1;
                        while (i < path.segmentCount()) {
                            String name = path.segment(i);
                            if (withinExistingTree) {
                                EList<ResourceTreeNode> children = currentNode.getChildren();
                                boolean found = false;
                                for (ResourceTreeNode resourceTreeNode : children) {
                                    if (!resourceTreeNode.getName().equals(name)) continue;
                                    currentNode = resourceTreeNode;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    currentNode = this.createNonExistingNode(path.removeLastSegments(path.segmentCount() - i - 1));
                                    withinExistingTree = false;
                                }
                            } else {
                                currentNode = this.createNonExistingNode(path.removeLastSegments(path.segmentCount() - i - 1));
                            }
                            nodes.add(currentNode);
                            ++i;
                        }
                        ArrayList<ResourceTreeNode> arrayList = nodes;
                        return arrayList;
                    }
                }
                nodes.add(this.createRootNode(path.segment(0)));
                int i = 1;
                while (i < path.segmentCount()) {
                    nodes.add(this.createNonExistingNode(path.removeLastSegments(path.segmentCount() - i - 1)));
                    ++i;
                }
            }
            finally {
                this.unlockForRead();
            }
        }
        return nodes;
    }

    ResourceTreeNode getNodeByPath(String pathString) {
        Path path = new Path(null, pathString);
        if (path.segmentCount() > 0) {
            try {
                this.lockForRead();
                if (this.mgr.getSemanticDB() != null) {
                    EList<TreeRoot> roots = this.mgr.getSemanticDB().getRoots();
                    for (TreeRoot treeRoot : roots) {
                        if (!path.segment(0).equals(treeRoot.getName())) continue;
                        if (path.segmentCount() == 1) {
                            TreeRoot treeRoot2 = treeRoot;
                            return treeRoot2;
                        }
                        String[] segments = path.segments();
                        ResourceTreeNode currentNode = treeRoot;
                        boolean ready = true;
                        int i = 1;
                        while (i < segments.length) {
                            String name = segments[i];
                            EList<ResourceTreeNode> children = currentNode.getChildren();
                            boolean found = false;
                            for (ResourceTreeNode resourceTreeNode : children) {
                                if (!resourceTreeNode.getName().equals(name)) continue;
                                currentNode = resourceTreeNode;
                                found = true;
                                break;
                            }
                            if (!found) {
                                ready = false;
                                break;
                            }
                            ++i;
                        }
                        if (ready) {
                            TreeRoot treeRoot3 = currentNode;
                            return treeRoot3;
                        }
                        ResourceTreeNode resourceTreeNode = this.createNonExistingNode((IPath)path);
                        return resourceTreeNode;
                    }
                }
            }
            finally {
                this.unlockForRead();
            }
            if (path.segmentCount() == 1) {
                return this.createRootNode(path.segment(0));
            }
            return this.createNonExistingNode((IPath)path);
        }
        return null;
    }

    ISemanticContentProvider mkdir(ResourceTreeNode actNode, ResourceTreeNode parent) throws CoreException {
        ISemanticContentProvider parentProvider = null;
        if (parent != null && !parent.isExists()) {
            ResourceTreeNode parentParent = this.getParentNode(parent);
            parentProvider = this.mkdir(parent, parentParent);
        } else {
            parentProvider = parent != null ? this.getStore(parent).getEffectiveContentProvider() : this.getStore(actNode).getEffectiveContentProvider();
        }
        return this.makeFolder(actNode, parent, parentProvider);
    }

    ISemanticContentProvider makeFolder(ResourceTreeNode actNode, ResourceTreeNode parent, ISemanticContentProvider parentProvider) throws CoreException {
        ISemanticContentProvider effectiveProvider = parentProvider;
        String federatedContentProviderId = null;
        if (actNode.getType() == TreeNodeType.FILE) {
            throw new SemanticResourceException(SemanticResourceStatusCode.RESOURCE_WITH_OTHER_TYPE_EXISTS, this.getStore(actNode).getPath(), Messages.SemanticFileStore_MkDirOnFile_XMSG);
        }
        boolean bExistedBefore = actNode.isExists();
        if (!actNode.isExists() && actNode.getTemplateID() == null) {
            if (parentProvider instanceof ISemanticContentProviderFederation) {
                federatedContentProviderId = ((ISemanticContentProviderFederation)((Object)parentProvider)).getFederatedProviderIDForPath((IPath)new Path(actNode.getPath()));
            }
            actNode.setTemplateID(federatedContentProviderId);
        }
        this.switchToExists(actNode, parent);
        if (actNode.getType() != TreeNodeType.PROJECT) {
            actNode.setType(TreeNodeType.FOLDER);
        }
        if (actNode.getTemplateID() != null) {
            ISemanticFileStore newStore = this.getStore(actNode);
            effectiveProvider = newStore.getEffectiveContentProvider();
            if (!bExistedBefore) {
                effectiveProvider.onRootStoreCreate(newStore);
            }
        }
        return effectiveProvider;
    }

    void switchToExists(ResourceTreeNode node, ResourceTreeNode parent) {
        if (!node.isExists()) {
            if (node instanceof TreeRoot) {
                ((TreeRoot)node).setParentDB(this.mgr.getSemanticDB());
            } else if (parent != null) {
                node.setParent(parent);
            }
            node.setPath(null);
            node.setExists(true);
        }
    }

    private ResourceTreeNode createNonExistingNode(IPath childPath) {
        ResourceTreeNode child = SemanticResourceDBFactory.eINSTANCE.createResourceTreeNode();
        child.setName(childPath.lastSegment());
        child.setType(TreeNodeType.UNKNOWN);
        child.setExists(false);
        child.setPath(childPath.toString());
        child.setLocalOnly(true);
        return child;
    }

    public IPath getPathForNode(ResourceTreeNode node) {
        try {
            this.lockForRead();
            if (node.isExists()) {
                StringBuilder sb = new StringBuilder(50);
                sb.append('/');
                sb.append(node.getName());
                ResourceTreeNode parent = node.getParent();
                while (parent != null) {
                    sb.insert(0, parent.getName());
                    sb.insert(0, '/');
                    parent = parent.getParent();
                }
                Path path = new Path(sb.toString());
                return path;
            }
            if (node.getPath() != null) {
                Path path = new Path(node.getPath());
                return path;
            }
            IPath iPath = EMPTY;
            return iPath;
        }
        finally {
            this.unlockForRead();
        }
    }

    protected ISemanticFileStore getStore(ResourceTreeNode node) {
        return new SemanticFileStore(this, node);
    }

    /*
     * Unable to fully structure code
     */
    private void init(File rootFolder) {
        block3: {
            this.metadataFolder = rootFolder != null ? rootFolder : SemanticResourcesPlugin.getCacheLocation().toFile();
            this.mgr = new SemanticMetadataPersistenceManager(this.metadataFolder);
            try {
                this.mgr.init();
                break block3;
            }
            catch (IOException e) {
                ** for (diagnostic : this.mgr.getMetadataResource().getErrors())
            }
lbl-1000:
            // 1 sources

            {
                this.log.log(new SemanticResourceException(SemanticResourceStatusCode.SFS_INITIALIZATION_ERROR, SemanticFileSystem.EMPTY, diagnostic.getMessage()));
                continue;
            }
lbl10:
            // 1 sources

            this.log.log(new SemanticResourceException(SemanticResourceStatusCode.SFS_INITIALIZATION_ERROR, SemanticFileSystem.EMPTY, Messages.SemanticFileSystem_SFSInitError_XMSG, e));
        }
    }

    private TreeRoot createRootNode(String name) {
        TreeRoot root = SemanticResourceDBFactory.eINSTANCE.createTreeRoot();
        root.setName(name);
        root.setExists(false);
        root.setPath("/" + name);
        root.setType(TreeNodeType.PROJECT);
        return root;
    }

    private TreeRoot createRootNode(String name, String queryString) {
        TreeRoot root = SemanticResourceDBFactory.eINSTANCE.createTreeRoot();
        root.setName(name);
        root.setQueryPart(queryString);
        root.setExists(false);
        root.setPath("/" + name);
        root.setType(TreeNodeType.PROJECT);
        if (queryString != null) {
            SemanticQueryParser parser = new SemanticQueryParser(queryString);
            this.applyQueryParameters(root, parser);
            if (parser.getShouldCreate()) {
                root.setExists(true);
                root.setPath(null);
                root.setParentDB(this.mgr.getSemanticDB());
            }
        }
        return root;
    }

    private void applyQueryParameters(ResourceTreeNode node, SemanticQueryParser parser) {
        node.setTemplateID(parser.getProviderID());
        node.setType(parser.getType());
        node.setRemoteURI(parser.getURI());
    }

    private void saveSemanticDB(String name) throws CoreException {
        try {
            if (SfsTraceLocation.CORE_DB.isActive()) {
                SfsTraceLocation.getTrace().traceEntry(SfsTraceLocation.CORE_DB.getLocation());
            }
            try {
                this.lockForWrite();
                this.mgr.saveSemanticDB(name);
            }
            finally {
                this.unlockForWrite();
            }
        }
        catch (IOException e) {
            SemanticResourceException ex = new SemanticResourceException(SemanticResourceStatusCode.SFS_ERROR_WRITING_METADATA, EMPTY, Messages.SemanticFileSystem_SFSUpdateError_XMSG, e);
            throw ex;
        }
    }

    protected void lockForRead() {
        this.readLock.lock();
    }

    protected void unlockForRead() {
        this.readLock.unlock();
    }

    protected void lockForWrite() {
        this.writeLock.lock();
    }

    protected void unlockForWrite() {
        this.writeLock.unlock();
    }

    @Override
    public String getPathToDb() {
        File metadataFile = new File(this.metadataFolder, METADATA_FILENAME);
        String metadataLocation = metadataFile.getAbsolutePath();
        return metadataLocation;
    }

    @Override
    public ISemanticFileSystemLog getLog() {
        return this.log;
    }

    @Override
    public ISemanticURILocatorService getURILocatorService(IProgressMonitor monitor) throws CoreException {
        try {
            this.lockForWrite();
            if (this.uriLocator == null) {
                this.uriLocator = new SemanticURILocatorService(this);
                this.uriLocator.rebuildMapping(monitor);
            }
            SemanticURILocatorService semanticURILocatorService = this.uriLocator;
            return semanticURILocatorService;
        }
        finally {
            this.unlockForWrite();
        }
    }

    public void requestURILocatorRebuild() {
        if (this.uriLocator != null) {
            this.uriLocator.requestRebuild();
        }
    }

    public SemanticURILocatorService getURILocator() {
        return this.uriLocator;
    }

    static final class SemanticURILocatorService
    implements ISemanticURILocatorService {
        private HashMap<String, ArrayList<IPath>> uri2pathMapping = new HashMap();
        final SemanticFileSystem fs;
        boolean needsRebuild;

        public SemanticURILocatorService(SemanticFileSystem fs) {
            this.fs = fs;
        }

        public IPath[] locateURI(URI uri) throws CoreException {
            try {
                ArrayList<IPath> paths;
                this.fs.lockForWrite();
                if (this.needsRebuild) {
                    this.rebuildMapping(null);
                }
                if ((paths = this.uri2pathMapping.get(uri.toString())) != null) {
                    IPath[] iPathArray = paths.toArray(new IPath[paths.size()]);
                    return iPathArray;
                }
                IPath[] iPathArray = new IPath[]{};
                return iPathArray;
            }
            finally {
                this.fs.unlockForWrite();
            }
        }

        public IPath[] locateURI(URI uri, IPath rootpath) throws CoreException {
            try {
                ArrayList<IPath> paths;
                this.fs.lockForWrite();
                if (this.needsRebuild) {
                    this.rebuildMapping(null);
                }
                if ((paths = this.uri2pathMapping.get(uri.toString())) != null) {
                    ArrayList<IPath> filteredpaths = new ArrayList<IPath>();
                    for (IPath iPath : paths) {
                        if (!rootpath.isPrefixOf(iPath)) continue;
                        filteredpaths.add(iPath);
                    }
                    IPath[] iPathArray = filteredpaths.toArray(new IPath[filteredpaths.size()]);
                    return iPathArray;
                }
                IPath[] iPathArray = new IPath[]{};
                return iPathArray;
            }
            finally {
                this.fs.unlockForWrite();
            }
        }

        public IPath getPathForNode(ResourceTreeNode node) {
            return this.fs.getPathForNode(node);
        }

        public void rebuildMapping(IProgressMonitor monitor) {
            this.uri2pathMapping.clear();
            TreeIterator contents = this.fs.mgr.getMetadataResource().getAllContents();
            while (contents.hasNext()) {
                ResourceTreeNode node;
                String uriString;
                EObject eObject = (EObject)contents.next();
                if (!(eObject instanceof ResourceTreeNode) || (uriString = (node = (ResourceTreeNode)eObject).getRemoteURI()) == null) continue;
                this.addURI(this.getPathForNode(node), uriString);
            }
            this.needsRebuild = false;
        }

        public void addURI(IPath path, String uriString) {
            ArrayList<Object> paths = this.uri2pathMapping.get(uriString);
            if (paths != null) {
                paths.add(path);
            } else {
                paths = new ArrayList();
                paths.add(path);
                this.uri2pathMapping.put(uriString, paths);
            }
        }

        public void removeURI(IPath path, String uriString) {
            ArrayList<IPath> paths = this.uri2pathMapping.get(uriString);
            paths.remove(path);
            if (paths.isEmpty()) {
                this.uri2pathMapping.remove(uriString);
            }
        }

        public void requestRebuild() {
            this.needsRebuild = true;
        }
    }
}

