/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic;

import org.eclipse.core.internal.resources.semantic.util.ITraceLocation;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugTrace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SfsTraceLocation implements ITraceLocation
{
    CORE("/debug/core"),
    CORE_DB("/debug/core/database"),
    CORE_VERBOSE("/debug/core/verbose"),
    DEBUG("/debug"),
    RULEFACTORY("/debug/rulefactory"),
    TEAM("/debug/teamprovider"),
    CONTENTPROVIDER("/debug/contentprovider");

    private final String location;
    private final String fullPath;
    private boolean active = false;
    private static DebugTrace myTrace;

    public static void initializeFromOptions(DebugOptions options, boolean pluginIsDebugging) {
        if (pluginIsDebugging) {
            myTrace = options.newDebugTrace("org.eclipse.core.resources.semantic");
            SfsTraceLocation[] sfsTraceLocationArray = SfsTraceLocation.values();
            int n = sfsTraceLocationArray.length;
            int n2 = 0;
            while (n2 < n) {
                SfsTraceLocation loc = sfsTraceLocationArray[n2];
                boolean active = options.getBooleanOption(loc.getFullPath(), false);
                loc.setActive(active);
                ++n2;
            }
        } else {
            SfsTraceLocation[] sfsTraceLocationArray = SfsTraceLocation.values();
            int n = sfsTraceLocationArray.length;
            int n3 = 0;
            while (n3 < n) {
                SfsTraceLocation loc = sfsTraceLocationArray[n3];
                loc.setActive(false);
                ++n3;
            }
        }
    }

    private SfsTraceLocation(String path) {
        this.fullPath = "org.eclipse.core.resources.semantic" + path;
        this.location = path;
    }

    public static DebugTrace getTrace() {
        return myTrace;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public String getFullPath() {
        return this.fullPath;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    private void setActive(boolean active) {
        this.active = active;
    }
}

