/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources.semantic.team;

import org.eclipse.core.internal.resources.semantic.SemanticFileAdapterImpl;
import org.eclipse.core.internal.resources.semantic.team.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.semantic.ISemanticFile;
import org.eclipse.core.resources.semantic.ISemanticFileSystem;
import org.eclipse.core.resources.semantic.ISemanticFolder;
import org.eclipse.core.resources.semantic.ISemanticProject;
import org.eclipse.core.resources.semantic.ISemanticResource;
import org.eclipse.core.resources.semantic.SemanticResourceException;
import org.eclipse.core.resources.semantic.SemanticResourceStatusCode;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.IResourceTree;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class MoveDeleteHook
implements IMoveDeleteHook {
    private final ISemanticFileSystem sfs;

    public MoveDeleteHook(ISemanticFileSystem actSfs) {
        this.sfs = actSfs;
    }

    private boolean deleteResource(IResourceTree tree, IResource resource, int updateFlags, IProgressMonitor monitor) {
        ISemanticResource sresource = (ISemanticResource)resource.getAdapter(ISemanticResource.class);
        if (sresource != null) {
            try {
                if (!sresource.validateRemove(2, monitor).isOK()) {
                    monitor.setCanceled(true);
                    OperationCanceledException ex = new OperationCanceledException();
                    throw ex;
                }
                sresource.remove(65538, monitor);
                if (resource.getType() == 1) {
                    tree.deletedFile((IFile)resource);
                } else if (resource.getType() == 2) {
                    tree.deletedFolder((IFolder)resource);
                } else if (resource.getType() == 4) {
                    tree.deletedProject((IProject)resource);
                }
                return true;
            }
            catch (CoreException e) {
                this.sfs.getLog().log(e);
                monitor.setCanceled(true);
                OperationCanceledException ex = new OperationCanceledException();
                ex.initCause((Throwable)e);
                throw ex;
            }
        }
        return false;
    }

    public boolean deleteFile(IResourceTree tree, IFile file, int updateFlags, IProgressMonitor monitor) {
        return this.deleteResource(tree, (IResource)file, updateFlags, monitor);
    }

    public boolean deleteFolder(IResourceTree tree, IFolder folder, int updateFlags, IProgressMonitor monitor) {
        return this.deleteResource(tree, (IResource)folder, updateFlags, monitor);
    }

    public boolean deleteProject(IResourceTree tree, IProject project, int updateFlags, IProgressMonitor monitor) {
        return this.deleteResource(tree, (IResource)project, updateFlags, monitor);
    }

    public boolean moveFile(IResourceTree tree, IFile source, IFile destination, int updateFlags, IProgressMonitor monitor) {
        boolean localOnly;
        ISemanticFile sFile = (ISemanticFile)source.getAdapter(ISemanticFile.class);
        if (sFile == null) {
            return false;
        }
        try {
            localOnly = sFile.fetchResourceInfo(8, monitor).isLocalOnly();
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            OperationCanceledException ex = new OperationCanceledException(e.getMessage());
            ex.initCause((Throwable)e);
            throw ex;
        }
        if (!localOnly) {
            ISemanticFolder targetParent = (ISemanticFolder)destination.getParent().getAdapter(ISemanticFolder.class);
            if (targetParent != null) {
                try {
                    SemanticFileAdapterImpl sFileImpl = (SemanticFileAdapterImpl)sFile;
                    if (sFileImpl.supportsMoveInternal(targetParent, destination.getName(), monitor)) {
                        sFileImpl.moveToInternal(targetParent, destination.getName(), 2, monitor);
                        tree.movedFile(source, destination);
                        return true;
                    }
                }
                catch (CoreException coreException) {}
            }
            SemanticResourceException ex = new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, source.getFullPath(), Messages.MoveDeleteHook_MoveRenameNotSupported_XMSG);
            this.sfs.getLog().log(ex);
            throw new OperationCanceledException();
        }
        return false;
    }

    public boolean moveFolder(IResourceTree tree, IFolder source, IFolder destination, int updateFlags, IProgressMonitor monitor) {
        ISemanticFolder sFolder = (ISemanticFolder)source.getAdapter(ISemanticFolder.class);
        if (sFolder == null) {
            return false;
        }
        SemanticResourceException ex = new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, source.getFullPath(), Messages.MoveDeleteHook_MoveRenameNotSupported_XMSG);
        this.sfs.getLog().log(ex);
        throw new OperationCanceledException();
    }

    public boolean moveProject(IResourceTree tree, IProject source, IProjectDescription description, int updateFlags, IProgressMonitor monitor) {
        if (source.getAdapter(ISemanticProject.class) != null) {
            SemanticResourceException ex = new SemanticResourceException(SemanticResourceStatusCode.METHOD_NOT_SUPPORTED, source.getFullPath(), Messages.MoveDeleteHook_MoveRenameNotSupported_XMSG);
            this.sfs.getLog().log(ex);
            throw new OperationCanceledException();
        }
        return false;
    }
}

