/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.css.spy;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.css.core.dom.ExtendedDocumentCSS;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.internal.theme.ThemeEngine;
import org.eclipse.e4.ui.css.swt.theme.IThemeEngine;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.css.sac.CSSParseException;
import org.w3c.dom.stylesheets.StyleSheet;
import org.w3c.dom.stylesheets.StyleSheetList;

public class CSSScratchPadPart {
    @Inject
    @Optional
    private IThemeEngine themeEngine;
    private static final int APPLY_ID = 100;
    private HashMap<Integer, Button> buttons = new HashMap();
    private Text cssText;
    private Text exceptions;

    @PostConstruct
    protected Control createDialogArea(Composite parent) {
        Composite outer = parent;
        outer.setLayout((Layout)new GridLayout());
        outer.setLayoutData((Object)new GridData(1808));
        SashForm sashForm = new SashForm(outer, 512);
        this.cssText = new Text((Composite)sashForm, 2626);
        this.exceptions = new Text((Composite)sashForm, 2058);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)sashForm);
        sashForm.setWeights(new int[]{80, 20});
        this.createButtonsForButtonBar(parent);
        return outer;
    }

    private void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 100, "Apply", true);
        this.createButton(parent, 0, "Close", false);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Shell shell;
        ++((GridLayout)parent.getLayout()).numColumns;
        Button button = new Button(parent, 8);
        button.setText(label);
        button.setFont(JFaceResources.getDialogFont());
        button.setData((Object)new Integer(id));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CSSScratchPadPart.this.buttonPressed((Integer)event.widget.getData());
            }
        });
        if (defaultButton && (shell = parent.getShell()) != null) {
            shell.setDefaultButton(button);
        }
        this.buttons.put(new Integer(id), button);
        return button;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 100: {
                this.applyCSS();
                break;
            }
        }
    }

    private void applyCSS() {
        if (this.themeEngine == null) {
            this.exceptions.setText("No theme engine available!");
            return;
        }
        long start = System.nanoTime();
        this.exceptions.setText("");
        StringBuilder sb = new StringBuilder();
        ((ThemeEngine)this.themeEngine).resetCurrentTheme();
        int count = 0;
        for (CSSEngine engine : ((ThemeEngine)this.themeEngine).getCSSEngines()) {
            if (count++ > 0) {
                sb.append("\n\n");
            }
            sb.append("Engine[").append(engine.getClass().getSimpleName()).append("]");
            ExtendedDocumentCSS doc = (ExtendedDocumentCSS)engine.getDocumentCSS();
            ArrayList<StyleSheet> sheets = new ArrayList<StyleSheet>();
            StyleSheetList list = doc.getStyleSheets();
            int i = 0;
            while (i < list.getLength()) {
                sheets.add(list.item(i));
                ++i;
            }
            try {
                StringReader reader = new StringReader(this.cssText.getText());
                sheets.add(0, engine.parseStyleSheet((Reader)reader));
                doc.removeAllStyleSheets();
                for (StyleSheet sheet : sheets) {
                    doc.addStyleSheet(sheet);
                }
                engine.reapply();
                long nanoDiff = System.nanoTime() - start;
                sb.append("\nTime: ").append(nanoDiff / 1000000L).append("ms");
            }
            catch (CSSParseException e) {
                sb.append("\nError: line ").append(e.getLineNumber()).append(" col ").append(e.getColumnNumber()).append(": ").append(e.getLocalizedMessage());
            }
            catch (IOException e) {
                sb.append("\nError: ").append(e.getLocalizedMessage());
            }
        }
        this.exceptions.setText(sb.toString());
    }
}

