/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.databinding.observable.map.IMapChangeListener;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.map.MapChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObservableMapLabelProvider<T>
extends LabelProvider
implements ILabelProvider,
ITableLabelProvider {
    protected IObservableMap<?, ?>[] attributeMaps;
    List<MapWrapper<?>> attributeMapsList;

    public <E> ObservableMapLabelProvider(IObservableMap<T, E> attributeMap) {
        this(ObservableMapLabelProvider.singletonList(attributeMap));
    }

    private static <T2, E> List<IObservableMap<T2, ?>> singletonList(IObservableMap<T2, E> attributeMap) {
        ArrayList singletonList = new ArrayList();
        singletonList.add(attributeMap);
        return singletonList;
    }

    public ObservableMapLabelProvider(IObservableMap<?, ?>[] attributeMaps) {
        this(Arrays.asList(attributeMaps));
    }

    public ObservableMapLabelProvider(List<IObservableMap<T, ?>> attributeMapsList) {
        this.attributeMapsList = new ArrayList(attributeMapsList.size());
        this.attributeMaps = attributeMapsList.toArray(new IObservableMap[attributeMapsList.size()]);
        for (IObservableMap<IObservableMap, ?> iObservableMap : attributeMapsList) {
            this.attributeMapsList.add(this.createMapWrapper(iObservableMap));
        }
    }

    private <E> MapWrapper<E> createMapWrapper(IObservableMap<T, E> map) {
        return new MapWrapper<E>(map);
    }

    public void dispose() {
        for (MapWrapper<?> wrapper : this.attributeMapsList) {
            wrapper.removeListener();
        }
        super.dispose();
        this.attributeMapsList = null;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (columnIndex < this.attributeMapsList.size()) {
            Object result = this.attributeMapsList.get((int)columnIndex).attributeMap.get(element);
            return result == null ? "" : result.toString();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MapWrapper<E> {
        IObservableMap<T, E> attributeMap;
        private IMapChangeListener<T, E> mapChangeListener = new IMapChangeListener<T, E>(){

            public void handleMapChange(MapChangeEvent<T, E> event) {
                Set affectedElements = event.diff.getChangedKeys();
                LabelProviderChangedEvent newEvent = new LabelProviderChangedEvent((IBaseLabelProvider)ObservableMapLabelProvider.this, affectedElements.toArray());
                ObservableMapLabelProvider.this.fireLabelProviderChanged(newEvent);
            }
        };

        public MapWrapper(IObservableMap<T, E> map) {
            this.attributeMap = map;
        }

        public void removeListener() {
            this.attributeMap.removeMapChangeListener(this.mapChangeListener);
        }
    }
}

