/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.viewers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.internal.databinding.viewers.ViewerElementWrapper;
import org.eclipse.jface.viewers.IElementComparer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewerElementSet<E>
implements Set<E> {
    private final Set<ViewerElementWrapper<E>> wrappedSet;
    private final IElementComparer comparer;

    public ViewerElementSet(IElementComparer comparer) {
        Assert.isNotNull((Object)comparer);
        this.wrappedSet = new HashSet<ViewerElementWrapper<E>>();
        this.comparer = comparer;
    }

    public ViewerElementSet(Collection<? extends E> collection, IElementComparer comparer) {
        this(comparer);
        this.addAll(collection);
    }

    @Override
    public boolean add(E o) {
        return this.wrappedSet.add(new ViewerElementWrapper<E>(o, this.comparer));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        Iterator<E> iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.wrappedSet.add(new ViewerElementWrapper<E>(iterator.next(), this.comparer));
        }
        return changed;
    }

    @Override
    public void clear() {
        this.wrappedSet.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrappedSet.contains(new ViewerElementWrapper<Object>(o, this.comparer));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            if (this.wrappedSet.contains(new ViewerElementWrapper(iterator.next(), this.comparer))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedSet.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator<ViewerElementWrapper<E>> wrappedIterator = this.wrappedSet.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return wrappedIterator.hasNext();
            }

            @Override
            public E next() {
                return ((ViewerElementWrapper)wrappedIterator.next()).unwrap();
            }

            @Override
            public void remove() {
                wrappedIterator.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.wrappedSet.remove(new ViewerElementWrapper<Object>(o, this.comparer));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<?> iterator = c.iterator();
        while (iterator.hasNext()) {
            changed |= this.remove(iterator.next());
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        Object[] retainAll = c.toArray();
        Iterator<E> iterator = this.iterator();
        block0: while (iterator.hasNext()) {
            E element = iterator.next();
            int i = 0;
            while (i < retainAll.length) {
                if (this.comparer.equals(element, retainAll[i])) continue block0;
                ++i;
            }
            iterator.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public int size() {
        return this.wrappedSet.size();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.wrappedSet.size()]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList<E> unwrappedElements = new ArrayList<E>(this.wrappedSet.size());
        for (ViewerElementWrapper<E> wrappedElement : this.wrappedSet) {
            unwrappedElements.add(wrappedElement.unwrap());
        }
        return unwrappedElements.toArray(a);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Set)) {
            return false;
        }
        Set that = (Set)obj;
        return this.size() == that.size() && this.containsAll(that);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (E element : this) {
            hash += element == null ? 0 : element.hashCode();
        }
        return hash;
    }

    public static <E> Set<E> withComparer(IElementComparer comparer) {
        if (comparer == null) {
            return new HashSet();
        }
        return new ViewerElementSet<E>(comparer);
    }
}

