/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.conformance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.Test;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.jface.databinding.conformance.MutableObservableCollectionContractTest;
import org.eclipse.jface.databinding.conformance.delegate.IObservableCollectionContractDelegate;
import org.eclipse.jface.databinding.conformance.util.ChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.ListChangeEventTracker;
import org.eclipse.jface.databinding.conformance.util.SuiteBuilder;

public class MutableObservableListContractTest
extends MutableObservableCollectionContractTest {
    private IObservableCollectionContractDelegate delegate;
    private IObservableList list;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MutableObservableListContractTest(IObservableCollectionContractDelegate delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public MutableObservableListContractTest(String testName, IObservableCollectionContractDelegate delegate) {
        super(testName, delegate);
        this.delegate = delegate;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.list = (IObservableList)this.getObservable();
    }

    public void testAdd_ListChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.add(element);
            }
        }, "List.add(Object)", this.list, Collections.singletonList(element));
    }

    public void testAdd_ListDiffEntry() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.add(element1);
            }
        }, "List.add(Object)", this.list, Arrays.asList(element0, element1));
    }

    public void testAddAtIndex_ChangeEvent() throws Exception {
        this.assertChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.add(0, MutableObservableListContractTest.this.delegate.createElement((IObservableCollection)MutableObservableListContractTest.this.list));
            }
        }, "List.add(int, Object)", (IObservableCollection)this.list);
    }

    public void testAddAtIndex_ListChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.add(0, element);
            }
        }, "List.add(int, Object)", this.list, Collections.singletonList(element));
    }

    public void testAddAtIndex_ChangeEventFiredAfterElementIsAdded() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertContainsDuringChangeEvent(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.add(0, element);
            }
        }, "List.add(int, Collection)", (IObservableCollection)this.list, element);
    }

    public void testAddAtIndex_ListDiffEntry() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.add(1, element1);
            }
        }, "List.add(int, Object)", this.list, Arrays.asList(element0, element1));
    }

    public void testAddAll_ListChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(Collections.singletonList(element));
            }
        }, "List.addAll(Collection", this.list, Collections.singletonList(element));
    }

    public void testAddAll_ListDiffEntry() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(Collections.singletonList(element));
            }
        }, "List.addAll(Collection)", this.list, Collections.singletonList(element));
    }

    public void testAddAll_ListDiffEntry2() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(Collections.singletonList(element1));
            }
        }, "List.addAll(Collection)", this.list, Arrays.asList(element0, element1));
    }

    public void testAddAllAtIndex_ChangeEvent() throws Exception {
        this.assertChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(0, Arrays.asList(MutableObservableListContractTest.this.delegate.createElement((IObservableCollection)MutableObservableListContractTest.this.list)));
            }
        }, "List.addAll(int, Collection)", (IObservableCollection)this.list);
    }

    public void testAddAllAtIndex_ListChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(0, Collections.singletonList(element));
            }
        }, "List.addAll(int, Collection)", this.list, Collections.singletonList(element));
    }

    public void testAddAllAtIndex_ChangeEventFiredAfterElementIsAdded() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.assertContainsDuringChangeEvent(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(0, Arrays.asList(element));
            }
        }, "List.addAll(int, Collection)", (IObservableCollection)this.list, element);
    }

    public void testAddAllAtIndex_ListDiffEntry() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.addAll(1, Collections.singletonList(element1));
            }
        }, "List.addAll(int, Collection)", this.list, Arrays.asList(element0, element1));
    }

    public void testSet_ChangeEvent() throws Exception {
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.set(0, MutableObservableListContractTest.this.delegate.createElement((IObservableCollection)MutableObservableListContractTest.this.list));
            }
        }, "List.set(int, Object)", (IObservableCollection)this.list);
    }

    public void testSet_ListChangeEvent() throws Exception {
        final Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.assertSame((Object)element0, (Object)MutableObservableListContractTest.this.list.set(0, element1));
            }
        }, "List.set(int, Object)", this.list, Arrays.asList(element1));
    }

    public void testSet_ChangeEventFiredAfterElementIsSet() throws Exception {
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element1);
        final Object element2 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertContainsDuringChangeEvent(new Runnable(){

            public void run() {
                MutableObservableListContractTest.assertSame((Object)element1, (Object)MutableObservableListContractTest.this.list.set(0, element2));
            }
        }, "List.set(int, Object)", (IObservableCollection)this.list, element2);
    }

    public void testSet_ListChangeEvent2() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        Object oldElement1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(oldElement1);
        final Object newElement1 = this.delegate.createElement((IObservableCollection)this.list);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.set(1, newElement1);
            }
        }, "List.set(int, Object)", this.list, Arrays.asList(element0, newElement1));
    }

    public void testMove_ChangeEvent() throws Exception {
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.move(0, 1);
            }
        }, "IObservableList.move(int, int)", (IObservableCollection)this.list);
    }

    public void testMove_NoChangeEventAtSameIndex() throws Exception {
        Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        ListChangeEventTracker tracker = ListChangeEventTracker.observe(this.list);
        Object movedElement = this.list.move(0, 0);
        MutableObservableListContractTest.assertEquals((String)this.formatFail("IObservableList.move(int,int) should return the moved element"), (Object)element, (Object)movedElement);
        MutableObservableListContractTest.assertEquals((String)this.formatFail("IObservableLIst.move(int,int) should not fire a change eventwhen the old and new indices are the same"), (int)0, (int)tracker.count);
    }

    public void testMove_ListChangeEvent() throws Exception {
        final Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element1);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.assertSame((Object)element0, (Object)MutableObservableListContractTest.this.list.move(0, 1));
            }
        }, "IObservableList.move(int, int)", this.list, Arrays.asList(element1, element0));
    }

    public void testMove_ChangeEventFiredAfterElementIsMoved() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        this.list.add(element1);
        MutableObservableListContractTest.assertSame((Object)element0, (Object)this.list.get(0));
        MutableObservableListContractTest.assertSame((Object)element1, (Object)this.list.get(1));
        this.list.move(0, 1);
        MutableObservableListContractTest.assertSame((Object)element1, (Object)this.list.get(0));
        MutableObservableListContractTest.assertSame((Object)element0, (Object)this.list.get(1));
    }

    public void testMove_ListChangeEvent2() {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element1);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.move(0, 1);
            }
        }, "IObservableList.move(int, int)", this.list, Arrays.asList(element1, element0));
    }

    public void testRemove_ListChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.remove(element);
            }
        }, "List.remove(Object)", this.list, Collections.EMPTY_LIST);
    }

    public void testRemove_ListDiffEntry() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element1);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.remove(element1);
            }
        }, "List.remove(Object)", this.list, Collections.singletonList(element0));
    }

    public void testRemoveAtIndex_ChangeEvent() throws Exception {
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.remove(0);
            }
        }, "List.remove(int)", (IObservableCollection)this.list);
    }

    public void testRemoveAtIndex_ListChangeEvent() throws Exception {
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.remove(0);
            }
        }, "List.remove(int)", this.list, Collections.EMPTY_LIST);
    }

    public void testRemoveAtIndex_ChangeEventFiredAfterElementIsRemoved() throws Exception {
        Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        this.assertDoesNotContainDuringChangeEvent(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.remove(0);
            }
        }, "List.remove(int)", (IObservableCollection)this.list, element);
    }

    public void testRemoveAtIndex_ListDiffEntry() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element1);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.remove(1);
            }
        }, "List.remove(int)", this.list, Collections.singletonList(element0));
    }

    public void testRemoveAll_ListChangeEvent() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.removeAll(Collections.singletonList(element));
            }
        }, "List.removeAll(Collection)", this.list, Collections.EMPTY_LIST);
    }

    public void testRemoveAll_ListDiffEntry() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.removeAll(Collections.singletonList(element));
            }
        }, "List.removeAll(Collection)", this.list, Collections.EMPTY_LIST);
    }

    public void testRemoveAll_ListDiffEntry2() throws Exception {
        Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        final Object element1 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element1);
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.removeAll(Arrays.asList(element1));
            }
        }, "List.removeAll(Collection)", this.list, Collections.singletonList(element0));
    }

    public void testRetainAll_ListChangeEvent() throws Exception {
        final Object element0 = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element0);
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.retainAll(Arrays.asList(element0));
            }
        }, "List.retainAll(Collection", this.list, Collections.singletonList(element0));
    }

    public void testRetainAll_ListDiffEntry() throws Exception {
        final Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.retainAll(Arrays.asList(element));
            }
        }, "List.retainAll(Collection)", this.list, Collections.singletonList(element));
    }

    public void testClear_ListChangeEvent() throws Exception {
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.clear();
            }
        }, "List.clear()", this.list, Collections.EMPTY_LIST);
    }

    public void testClear_ListDiffEntry() throws Exception {
        this.list.add(this.delegate.createElement((IObservableCollection)this.list));
        this.assertListChangeEventFired(new Runnable(){

            public void run() {
                MutableObservableListContractTest.this.list.clear();
            }
        }, "List.clear()", this.list, Collections.EMPTY_LIST);
    }

    public void testClear_ClearsList() {
        Object element = this.delegate.createElement((IObservableCollection)this.list);
        this.list.add(element);
        Assert.assertEquals(Collections.singletonList(element), (Object)this.list);
        this.list.clear();
        Assert.assertEquals((Object)Collections.EMPTY_LIST, (Object)this.list);
    }

    private void assertListChangeEventFired(Runnable runnable, String methodName, IObservableList list, List newList) {
        ArrayList oldList = new ArrayList(list);
        ArrayList queue = new ArrayList();
        ListChangeEventTracker listListener = new ListChangeEventTracker(queue);
        ChangeEventTracker changeListener = new ChangeEventTracker(queue);
        list.addListChangeListener((IListChangeListener)listListener);
        list.addChangeListener((IChangeListener)changeListener);
        runnable.run();
        MutableObservableListContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " should fire one ListChangeEvent."), (int)1, (int)listListener.count);
        MutableObservableListContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + "'s change event observable should be the created List."), (Object)list, (Object)listListener.event.getObservable());
        MutableObservableListContractTest.assertEquals((String)this.formatFail("Two notifications should have been received."), (int)2, (int)queue.size());
        MutableObservableListContractTest.assertEquals((String)("ChangeEvent of " + methodName + " should have fired before the ListChangeEvent."), (Object)changeListener, queue.get(0));
        MutableObservableListContractTest.assertEquals((String)("ListChangeEvent of " + methodName + " should have fired after the ChangeEvent."), (Object)listListener, queue.get(1));
        MutableObservableListContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " did not leave observable list with the expected contents"), (Object)newList, (Object)list);
        ListDiff diff = listListener.event.diff;
        diff.applyTo(oldList);
        MutableObservableListContractTest.assertEquals((String)this.formatFail(String.valueOf(methodName) + " fired a diff which does not represent the expected list change"), (Object)newList, oldList);
    }

    public static Test suite(IObservableCollectionContractDelegate delegate) {
        SuiteBuilder suiteBuilder = new SuiteBuilder();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.databinding.conformance.MutableObservableListContractTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        SuiteBuilder suiteBuilder2 = suiteBuilder.addObservableContractTest(clazz, delegate);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.jface.databinding.conformance.ObservableListContractTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return suiteBuilder2.addObservableContractTest(clazz2, delegate).build();
    }
}

