/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.platform.discovery.ui.internal.view.result.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.platform.discovery.ui.api.IGenericViewCustomization;

public class GenericResultContentProvider
implements ITreeContentProvider {
    private List<ITreeContentProvider> contentProviders = new ArrayList<ITreeContentProvider>();
    private final List<IGenericViewCustomization> customizations;

    public GenericResultContentProvider(List<IGenericViewCustomization> viewCustomizations) {
        this.customizations = Collections.unmodifiableList(viewCustomizations);
        for (IGenericViewCustomization cust : this.customizations) {
            ITreeContentProvider cp = cust.getContentProvider();
            if (cp == null) continue;
            this.contentProviders.add(cp);
        }
    }

    protected List<IGenericViewCustomization> availableCustomizations() {
        return this.customizations;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ITreeContentProvider cp : this.contentProviders) {
            Object[] objects = cp.getElements(inputElement);
            if (objects == null) continue;
            result.addAll(Arrays.asList(objects));
        }
        return result.toArray();
    }

    public void dispose() {
        for (ITreeContentProvider cp : this.contentProviders) {
            cp.dispose();
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        for (ITreeContentProvider cp : this.contentProviders) {
            cp.inputChanged(viewer, oldInput, newInput);
        }
    }

    public Object[] getChildren(Object parentElement) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (ITreeContentProvider cp : this.contentProviders) {
            Object[] objects = cp.getChildren(parentElement);
            if (objects == null) continue;
            result.addAll(Arrays.asList(objects));
        }
        return result.toArray();
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        for (ITreeContentProvider cp : this.contentProviders) {
            if (!cp.hasChildren(element)) continue;
            return true;
        }
        return false;
    }
}

